/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.util.BigNumber;
import java.util.ArrayList;

public class GTSQLTypeInfoDataSource
extends GTDataSource {
    private DatabaseConnection database;
    private ArrayList key_value_pairs;
    private static final BigNumber TYPE_NULLABLE = BigNumber.fromInt(1);
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTSQLTypeInfoDataSource(DatabaseConnection connection) {
        super(connection.getSystem());
        this.database = connection;
        this.key_value_pairs = new ArrayList();
    }

    private void addType(String name, int type, int precision, String prefix, String suffix, String oops, boolean searchable) {
        this.key_value_pairs.add(name);
        this.key_value_pairs.add(BigNumber.fromLong(type));
        this.key_value_pairs.add(BigNumber.fromLong(precision));
        this.key_value_pairs.add(prefix);
        this.key_value_pairs.add(suffix);
        this.key_value_pairs.add(searchable ? BigNumber.fromLong(3L) : BigNumber.fromLong(0L));
    }

    public GTSQLTypeInfoDataSource init() {
        this.addType("BIT", -7, 1, null, null, null, true);
        this.addType("BOOLEAN", -7, 1, null, null, null, true);
        this.addType("TINYINT", -6, 9, null, null, null, true);
        this.addType("SMALLINT", 5, 9, null, null, null, true);
        this.addType("INTEGER", 4, 9, null, null, null, true);
        this.addType("BIGINT", -5, 9, null, null, null, true);
        this.addType("FLOAT", 6, 9, null, null, null, true);
        this.addType("REAL", 7, 9, null, null, null, true);
        this.addType("DOUBLE", 8, 9, null, null, null, true);
        this.addType("NUMERIC", 2, 9, null, null, null, true);
        this.addType("DECIMAL", 3, 9, null, null, null, true);
        this.addType("CHAR", 1, 9, "'", "'", null, true);
        this.addType("VARCHAR", 12, 9, "'", "'", null, true);
        this.addType("LONGVARCHAR", -1, 9, "'", "'", null, true);
        this.addType("DATE", 91, 9, null, null, null, true);
        this.addType("TIME", 92, 9, null, null, null, true);
        this.addType("TIMESTAMP", 93, 9, null, null, null, true);
        this.addType("BINARY", -2, 9, null, null, null, false);
        this.addType("VARBINARY", -3, 9, null, null, null, false);
        this.addType("LONGVARBINARY", -4, 9, null, null, null, false);
        this.addType("JAVA_OBJECT", 2000, 9, null, null, null, false);
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.key_value_pairs.size() / 6;
    }

    public TObject getCellContents(int column, int row) {
        int i = row * 6;
        switch (column) {
            case 0: {
                return this.columnValue(column, (String)this.key_value_pairs.get(i));
            }
            case 1: {
                return this.columnValue(column, (BigNumber)this.key_value_pairs.get(i + 1));
            }
            case 2: {
                return this.columnValue(column, (BigNumber)this.key_value_pairs.get(i + 2));
            }
            case 3: {
                return this.columnValue(column, (String)this.key_value_pairs.get(i + 3));
            }
            case 4: {
                return this.columnValue(column, (String)this.key_value_pairs.get(i + 4));
            }
            case 5: {
                return this.columnValue(column, null);
            }
            case 6: {
                return this.columnValue(column, TYPE_NULLABLE);
            }
            case 7: {
                return this.columnValue(column, Boolean.TRUE);
            }
            case 8: {
                return this.columnValue(column, (BigNumber)this.key_value_pairs.get(i + 5));
            }
            case 9: {
                return this.columnValue(column, Boolean.FALSE);
            }
            case 10: {
                return this.columnValue(column, Boolean.FALSE);
            }
            case 11: {
                return this.columnValue(column, Boolean.FALSE);
            }
            case 12: {
                return this.columnValue(column, null);
            }
            case 13: {
                return this.columnValue(column, BigNumber.fromLong(0L));
            }
            case 14: {
                return this.columnValue(column, BigNumber.fromLong(10000000L));
            }
            case 15: {
                return this.columnValue(column, null);
            }
            case 16: {
                return this.columnValue(column, null);
            }
            case 17: {
                return this.columnValue(column, BigNumber.fromLong(10L));
            }
        }
        throw new Error("Column out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.key_value_pairs = null;
        this.database = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRSQLTypeInfo"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("TYPE_NAME"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("DATA_TYPE"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("PRECISION"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("LITERAL_PREFIX"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("LITERAL_SUFFIX"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("CREATE_PARAMS"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("NULLABLE"));
        def.addColumn(GTSQLTypeInfoDataSource.booleanColumn("CASE_SENSITIVE"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("SEARCHABLE"));
        def.addColumn(GTSQLTypeInfoDataSource.booleanColumn("UNSIGNED_ATTRIBUTE"));
        def.addColumn(GTSQLTypeInfoDataSource.booleanColumn("FIXED_PREC_SCALE"));
        def.addColumn(GTSQLTypeInfoDataSource.booleanColumn("AUTO_INCREMENT"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("LOCAL_TYPE_NAME"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("MINIMUM_SCALE"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("MAXIMUM_SCALE"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("SQL_DATA_TYPE"));
        def.addColumn(GTSQLTypeInfoDataSource.stringColumn("SQL_DATETIME_SUB"));
        def.addColumn(GTSQLTypeInfoDataSource.numericColumn("NUM_PREC_RADIX"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

