/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.global.StandardMessages;
import java.util.ArrayList;

final class GTProductDataSource
extends GTDataSource {
    private ArrayList key_value_pairs = new ArrayList();
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTProductDataSource(Transaction transaction) {
        super(transaction.getSystem());
    }

    public GTProductDataSource init() {
        this.key_value_pairs.add("name");
        this.key_value_pairs.add(StandardMessages.NAME);
        this.key_value_pairs.add("version");
        this.key_value_pairs.add(StandardMessages.VERSION);
        this.key_value_pairs.add("copyright");
        this.key_value_pairs.add(StandardMessages.COPYRIGHT);
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.key_value_pairs.size() / 2;
    }

    public TObject getCellContents(int column, int row) {
        switch (column) {
            case 0: {
                return this.columnValue(column, (String)this.key_value_pairs.get(row * 2));
            }
            case 1: {
                return this.columnValue(column, (String)this.key_value_pairs.get(row * 2 + 1));
            }
        }
        throw new Error("Column out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.key_value_pairs = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRProductInfo"));
        def.addColumn(GTProductDataSource.stringColumn("var"));
        def.addColumn(GTProductDataSource.stringColumn("value"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

