/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.TObject;
import com.mckoi.database.TableName;
import com.mckoi.database.User;
import com.mckoi.database.UserManager;
import java.util.ArrayList;
import java.util.Date;

final class GTCurrentConnectionsDataSource
extends GTDataSource {
    private DatabaseConnection database;
    private ArrayList key_value_pairs;
    static final DataTableDef DEF_DATA_TABLE_DEF;

    public GTCurrentConnectionsDataSource(DatabaseConnection connection) {
        super(connection.getSystem());
        this.database = connection;
        this.key_value_pairs = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GTCurrentConnectionsDataSource init() {
        UserManager user_manager;
        UserManager userManager = user_manager = this.database.getDatabase().getUserManager();
        synchronized (userManager) {
            for (int i = 0; i < user_manager.userCount(); ++i) {
                User user = user_manager.userAt(i);
                this.key_value_pairs.add(user.getUserName());
                this.key_value_pairs.add(user.getConnectionString());
                this.key_value_pairs.add(new Date(user.getLastCommandTime()));
                this.key_value_pairs.add(new Date(user.getTimeConnected()));
            }
        }
        return this;
    }

    public DataTableDef getDataTableDef() {
        return DEF_DATA_TABLE_DEF;
    }

    public int getRowCount() {
        return this.key_value_pairs.size() / 4;
    }

    public TObject getCellContents(int column, int row) {
        switch (column) {
            case 0: {
                return this.columnValue(column, (String)this.key_value_pairs.get(row * 4));
            }
            case 1: {
                return this.columnValue(column, (String)this.key_value_pairs.get(row * 4 + 1));
            }
            case 2: {
                return this.columnValue(column, (Date)this.key_value_pairs.get(row * 4 + 2));
            }
            case 3: {
                return this.columnValue(column, (Date)this.key_value_pairs.get(row * 4 + 3));
            }
        }
        throw new Error("Column out of bounds.");
    }

    public void dispose() {
        super.dispose();
        this.key_value_pairs = null;
        this.database = null;
    }

    static {
        DataTableDef def = new DataTableDef();
        def.setTableName(new TableName("SYS_INFO", "sUSRCurrentConnections"));
        def.addColumn(GTCurrentConnectionsDataSource.stringColumn("username"));
        def.addColumn(GTCurrentConnectionsDataSource.stringColumn("host_string"));
        def.addColumn(GTCurrentConnectionsDataSource.dateColumn("last_command"));
        def.addColumn(GTCurrentConnectionsDataSource.dateColumn("time_connected"));
        def.setImmutable();
        DEF_DATA_TABLE_DEF = def;
    }
}

