/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.store.AreaWriter;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import java.io.IOException;
import java.util.ArrayList;

public class FixedRecordList {
    private static final int MAGIC = 141636010;
    private final Store store;
    private final int element_size;
    private long list_header_p;
    private MutableArea list_header_area;
    private int list_block_count;
    private long[] list_block_element;
    private MutableArea[] list_block_area;

    public FixedRecordList(Store store, int element_size) {
        this.store = store;
        this.element_size = element_size;
        this.list_block_element = new long[64];
        this.list_block_area = new MutableArea[64];
    }

    public long create() throws IOException {
        AreaWriter writer = this.store.createArea(528L);
        this.list_header_p = writer.getID();
        writer.putInt(141636010);
        writer.finish();
        this.list_header_area = this.store.getMutableArea(this.list_header_p);
        this.list_block_count = 0;
        this.updateListHeaderArea();
        return this.list_header_p;
    }

    public void init(long list_pointer) throws IOException {
        this.list_header_p = list_pointer;
        this.list_header_area = this.store.getMutableArea(this.list_header_p);
        int magic = this.list_header_area.getInt();
        if (magic != 141636010) {
            throw new IOException("Incorrect magic for list block. [magic=" + magic + "]");
        }
        this.list_block_count = this.list_header_area.getInt();
        this.list_header_area.getLong();
        for (int i = 0; i < this.list_block_count; ++i) {
            long block_pointer;
            this.list_block_element[i] = block_pointer = this.list_header_area.getLong();
            this.list_block_area[i] = this.store.getMutableArea(block_pointer);
        }
    }

    public void addAllAreasUsed(ArrayList list) throws IOException {
        list.add(new Long(this.list_header_p));
        for (int i = 0; i < this.list_block_count; ++i) {
            list.add(new Long(this.list_block_element[i]));
        }
    }

    public long getReservedLong() throws IOException {
        this.list_header_area.position(8);
        return this.list_header_area.getLong();
    }

    public void setReservedLong(long v) throws IOException {
        this.list_header_area.position(8);
        this.list_header_area.putLong(v);
        this.list_header_area.checkOut();
    }

    private void updateListHeaderArea() throws IOException {
        this.list_header_area.position(4);
        this.list_header_area.putInt(this.list_block_count);
        this.list_header_area.position(16);
        for (int i = 0; i < this.list_block_count; ++i) {
            this.list_header_area.putLong(this.list_block_element[i]);
        }
        this.list_header_area.checkOut();
    }

    public MutableArea positionOnNode(long record_number) throws IOException {
        int bit = 0;
        long work = record_number + 32L;
        while (work != 0L) {
            work >>= 1;
            ++bit;
        }
        long start_val = (1 << bit - 1) - 32;
        int block_offset = bit - 6;
        long record_offset = record_number - start_val;
        MutableArea block_area = this.list_block_area[block_offset];
        block_area.position((int)(record_offset * (long)this.element_size));
        return block_area;
    }

    public int listBlockCount() {
        return this.list_block_count;
    }

    public long addressableNodeCount() {
        return this.listBlockFirstPosition(this.list_block_count);
    }

    public long listBlockNodeCount(int block_number) {
        return 32L << block_number;
    }

    public long listBlockFirstPosition(int block_number) {
        long start_index = 0L;
        long diff = 32L;
        for (int i = block_number; i > 0; --i) {
            start_index += diff;
            diff <<= 1;
        }
        return start_index;
    }

    public void increaseSize() throws IOException {
        long size_of_block = 32L << this.list_block_count;
        AreaWriter writer = this.store.createArea(size_of_block * (long)this.element_size);
        long nblock_p = writer.getID();
        writer.finish();
        MutableArea nblock_area = this.store.getMutableArea(nblock_p);
        this.list_block_element[this.list_block_count] = nblock_p;
        this.list_block_area[this.list_block_count] = nblock_area;
        ++this.list_block_count;
        this.updateListHeaderArea();
    }

    public void decreaseSize() throws IOException {
        --this.list_block_count;
        this.store.deleteArea(this.list_block_element[this.list_block_count]);
        this.list_block_area[this.list_block_count] = null;
        this.list_block_element[this.list_block_count] = 0L;
        this.updateListHeaderArea();
    }
}

