/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.CorrelatedVariable;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.Function;
import com.mckoi.database.FunctionDef;
import com.mckoi.database.GroupResolver;
import com.mckoi.database.Operator;
import com.mckoi.database.ParameterSubstitution;
import com.mckoi.database.QueryContext;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.StatementTreeObject;
import com.mckoi.database.TArrayType;
import com.mckoi.database.TObject;
import com.mckoi.database.TQueryPlanType;
import com.mckoi.database.TType;
import com.mckoi.database.Variable;
import com.mckoi.database.VariableResolver;
import com.mckoi.database.global.NullObject;
import com.mckoi.database.sql.ParseException;
import com.mckoi.database.sql.SQL;
import com.mckoi.util.BigNumber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class Expression
implements Serializable,
Cloneable {
    static final long serialVersionUID = 6981261114471924028L;
    private ArrayList elements = new ArrayList();
    private transient ArrayList eval_stack;
    private StringBuffer text;
    private static final SQL expression_parser = new SQL(new StringReader(""));

    public Expression() {
        this.text = new StringBuffer();
    }

    public Expression(Object ob) {
        this();
        this.addElement(ob);
    }

    public Expression(Expression exp) {
        this.concat(exp);
        this.text = new StringBuffer(new String(exp.text));
    }

    public Expression(Expression exp1, Operator op, Expression exp2) {
        this.elements.addAll(exp1.elements);
        this.elements.addAll(exp2.elements);
        this.elements.add(op);
    }

    public StringBuffer text() {
        return this.text;
    }

    public void copyTextFrom(Expression e) {
        this.text = new StringBuffer(new String(e.text()));
    }

    public static Expression parse(String expression) {
        SQL sQL = expression_parser;
        synchronized (sQL) {
            try {
                expression_parser.ReInit(new StringReader(expression));
                expression_parser.reset();
                Expression exp = expression_parser.parseExpression();
                exp.text().setLength(0);
                exp.text().append(expression);
                return exp;
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public static Expression simple(Object ob1, Operator op, Object ob2) {
        Expression exp = new Expression(ob1);
        exp.addElement(ob2);
        exp.addElement(op);
        return exp;
    }

    public void addElement(Object ob) {
        if (ob == null) {
            this.elements.add(TObject.nullVal());
        } else if (ob instanceof TObject || ob instanceof ParameterSubstitution || ob instanceof CorrelatedVariable || ob instanceof Variable || ob instanceof FunctionDef || ob instanceof Operator || ob instanceof StatementTreeObject) {
            this.elements.add(ob);
        } else {
            throw new Error("Unknown element type added to expression: " + ob.getClass());
        }
    }

    public Expression concat(Expression expr) {
        this.elements.addAll(expr.elements);
        return this;
    }

    public void addOperator(Operator op) {
        this.elements.add(op);
    }

    public int size() {
        return this.elements.size();
    }

    public Object elementAt(int n) {
        return this.elements.get(n);
    }

    public Object last() {
        return this.elements.get(this.size() - 1);
    }

    public void setElementAt(int n, Object ob) {
        this.elements.set(n, ob);
    }

    private final void push(Object ob) {
        this.eval_stack.add(ob);
    }

    private final Object pop() {
        return this.eval_stack.remove(this.eval_stack.size() - 1);
    }

    public List allVariables() {
        ArrayList vars = new ArrayList();
        for (int i = 0; i < this.elements.size(); ++i) {
            TObject tob;
            Object ob = this.elements.get(i);
            if (ob instanceof Variable) {
                vars.add(ob);
                continue;
            }
            if (ob instanceof FunctionDef) {
                Expression[] params = ((FunctionDef)ob).getParameters();
                for (int n = 0; n < params.length; ++n) {
                    vars.addAll(params[n].allVariables());
                }
                continue;
            }
            if (!(ob instanceof TObject) || !((tob = (TObject)ob).getTType() instanceof TArrayType)) continue;
            Expression[] exp_list = (Expression[])tob.getObject();
            for (int n = 0; n < exp_list.length; ++n) {
                vars.addAll(exp_list[n].allVariables());
            }
        }
        return vars;
    }

    public List allElements() {
        ArrayList elems = new ArrayList();
        for (int i = 0; i < this.elements.size(); ++i) {
            Object ob = this.elements.get(i);
            if (ob instanceof Operator) continue;
            if (ob instanceof FunctionDef) {
                Expression[] params = ((FunctionDef)ob).getParameters();
                for (int n = 0; n < params.length; ++n) {
                    elems.addAll(params[n].allElements());
                }
                continue;
            }
            if (ob instanceof TObject) {
                TObject tob = (TObject)ob;
                if (tob.getTType() instanceof TArrayType) {
                    Expression[] exp_list = (Expression[])tob.getObject();
                    for (int n = 0; n < exp_list.length; ++n) {
                        elems.addAll(exp_list[n].allElements());
                    }
                    continue;
                }
                elems.add(ob);
                continue;
            }
            elems.add(ob);
        }
        return elems;
    }

    public void prepare(ExpressionPreparer preparer) throws DatabaseException {
        for (int n = 0; n < this.elements.size(); ++n) {
            Object ob = this.elements.get(n);
            if (preparer.canPrepare(ob)) {
                this.elements.set(n, preparer.prepare(ob));
            }
            Expression[] exp_list = null;
            if (ob instanceof FunctionDef) {
                FunctionDef func = (FunctionDef)ob;
                exp_list = func.getParameters();
            } else if (ob instanceof TObject) {
                TObject tob = (TObject)ob;
                if (tob.getTType() instanceof TArrayType) {
                    exp_list = (Expression[])tob.getObject();
                }
            } else if (ob instanceof StatementTreeObject) {
                StatementTreeObject stree = (StatementTreeObject)ob;
                stree.prepareExpressions(preparer);
            }
            if (exp_list == null) continue;
            for (int p = 0; p < exp_list.length; ++p) {
                exp_list[p].prepare(preparer);
            }
        }
    }

    public boolean isConstant() {
        for (int n = 0; n < this.elements.size(); ++n) {
            Object ob = this.elements.get(n);
            if (ob instanceof TObject) {
                TObject tob = (TObject)ob;
                TType ttype = tob.getTType();
                if (ttype instanceof TQueryPlanType) {
                    return false;
                }
                if (!(ttype instanceof TArrayType)) continue;
                Expression[] exp_list = (Expression[])tob.getObject();
                for (int p = 0; p < exp_list.length; ++p) {
                    if (exp_list[p].isConstant()) continue;
                    return false;
                }
                continue;
            }
            if (ob instanceof Variable) {
                return false;
            }
            if (!(ob instanceof FunctionDef)) continue;
            Expression[] params = ((FunctionDef)ob).getParameters();
            for (int p = 0; p < params.length; ++p) {
                if (params[p].isConstant()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean hasSubQuery() {
        List list = this.allElements();
        int len = list.size();
        for (int n = 0; n < len; ++n) {
            TObject tob;
            Object ob = list.get(n);
            if (!(ob instanceof TObject) || !((tob = (TObject)ob).getTType() instanceof TQueryPlanType)) continue;
            return true;
        }
        return false;
    }

    public boolean containsNotOperator() {
        for (int n = 0; n < this.elements.size(); ++n) {
            Object ob = this.elements.get(n);
            if (!(ob instanceof Operator) || !((Operator)ob).isNot()) continue;
            return true;
        }
        return false;
    }

    public ArrayList discoverCorrelatedVariables(int level, ArrayList list) {
        List elems = this.allElements();
        int sz = elems.size();
        for (int i = 0; i < sz; ++i) {
            TObject tob;
            Object ob = elems.get(i);
            if (ob instanceof CorrelatedVariable) {
                CorrelatedVariable v = (CorrelatedVariable)ob;
                if (v.getQueryLevelOffset() != level) continue;
                list.add(v);
                continue;
            }
            if (!(ob instanceof TObject) || !((tob = (TObject)ob).getTType() instanceof TQueryPlanType)) continue;
            QueryPlanNode node = (QueryPlanNode)tob.getObject();
            list = node.discoverCorrelatedVariables(level + 1, list);
        }
        return list;
    }

    public ArrayList discoverTableNames(ArrayList list) {
        List elems = this.allElements();
        int sz = elems.size();
        for (int i = 0; i < sz; ++i) {
            TObject tob;
            Object ob = elems.get(i);
            if (!(ob instanceof TObject) || !((tob = (TObject)ob).getTType() instanceof TQueryPlanType)) continue;
            QueryPlanNode node = (QueryPlanNode)tob.getObject();
            list = node.discoverTableNames(list);
        }
        return list;
    }

    public QueryPlanNode getQueryPlanNode() {
        TObject tob;
        Object ob = this.elementAt(0);
        if (this.size() == 1 && ob instanceof TObject && (tob = (TObject)ob).getTType() instanceof TQueryPlanType) {
            return (QueryPlanNode)tob.getObject();
        }
        return null;
    }

    public Variable getVariable() {
        Object ob = this.elementAt(0);
        if (this.size() == 1 && ob instanceof Variable) {
            return (Variable)ob;
        }
        return null;
    }

    public Expression[] split() {
        if (this.size() <= 1) {
            throw new Error("Can only split expressions with more than 1 element.");
        }
        int midpoint = -1;
        int stack_size = 0;
        for (int n = 0; n < this.size() - 1; ++n) {
            Object ob = this.elementAt(n);
            stack_size = ob instanceof Operator ? --stack_size : ++stack_size;
            if (stack_size != 1) continue;
            midpoint = n;
        }
        if (midpoint == -1) {
            throw new Error("postfix format error: Midpoint not found.");
        }
        Expression lhs = new Expression();
        for (int n = 0; n <= midpoint; ++n) {
            lhs.addElement(this.elementAt(n));
        }
        Expression rhs = new Expression();
        for (int n = midpoint + 1; n < this.size() - 1; ++n) {
            rhs.addElement(this.elementAt(n));
        }
        return new Expression[]{lhs, rhs};
    }

    public Expression getEndExpression() {
        int end;
        int stack_size = 1;
        for (int n = end = this.size() - 1; n > 0; --n) {
            Object ob = this.elementAt(n);
            stack_size = ob instanceof Operator ? ++stack_size : --stack_size;
            if (stack_size != 0) continue;
            Expression new_exp = new Expression();
            for (int i = n; i <= end; ++i) {
                new_exp.addElement(this.elementAt(i));
            }
            return new_exp;
        }
        return new Expression(this);
    }

    public ArrayList breakByOperator(ArrayList list, String logical_op) {
        Operator op;
        Object ob = this.last();
        if (ob instanceof Operator && (op = (Operator)ob).is(logical_op)) {
            Expression[] exps = this.split();
            list = exps[0].breakByOperator(list, logical_op);
            list = exps[1].breakByOperator(list, logical_op);
            return list;
        }
        list.add(this);
        return list;
    }

    public TObject evaluate(GroupResolver group, VariableResolver resolver, QueryContext context) {
        int element_count = this.elements.size();
        if (element_count == 1) {
            return (TObject)this.elementToObject(0, group, resolver, context);
        }
        if (element_count == 3) {
            TObject o1 = (TObject)this.elementToObject(0, group, resolver, context);
            TObject o2 = (TObject)this.elementToObject(1, group, resolver, context);
            Operator op = (Operator)this.elements.get(2);
            return op.eval(o1, o2, group, resolver, context);
        }
        if (this.eval_stack == null) {
            this.eval_stack = new ArrayList();
        }
        for (int n = 0; n < element_count; ++n) {
            Object val = this.elementToObject(n, group, resolver, context);
            if (val instanceof Operator) {
                Operator op = (Operator)val;
                TObject v2 = (TObject)this.pop();
                TObject v1 = (TObject)this.pop();
                this.push(op.eval(v1, v2, group, resolver, context));
                continue;
            }
            this.push(val);
        }
        return (TObject)this.pop();
    }

    public TObject evaluate(VariableResolver resolver, QueryContext context) {
        return this.evaluate(null, resolver, context);
    }

    private Object elementToObject(int n, GroupResolver group, VariableResolver resolver, QueryContext context) {
        Object ob = this.elements.get(n);
        if (ob instanceof TObject || ob instanceof Operator) {
            return ob;
        }
        if (ob instanceof Variable) {
            return resolver.resolve((Variable)ob);
        }
        if (ob instanceof CorrelatedVariable) {
            return ((CorrelatedVariable)ob).getEvalResult();
        }
        if (ob instanceof FunctionDef) {
            Function fun = ((FunctionDef)ob).getFunction(context);
            return fun.evaluate(group, resolver, context);
        }
        if (ob == null) {
            throw new NullPointerException("Null element in expression");
        }
        throw new Error("Unknown element type: " + ob.getClass());
    }

    public boolean hasAggregateFunction(QueryContext context) {
        for (int n = 0; n < this.elements.size(); ++n) {
            TObject tob;
            Object ob = this.elements.get(n);
            if (ob instanceof FunctionDef) {
                if (!((FunctionDef)ob).isAggregate(context)) continue;
                return true;
            }
            if (!(ob instanceof TObject) || !((tob = (TObject)ob).getTType() instanceof TArrayType)) continue;
            Expression[] list = (Expression[])tob.getObject();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].hasAggregateFunction(context)) continue;
                return true;
            }
        }
        return false;
    }

    public TType returnTType(VariableResolver resolver, QueryContext context) {
        Object ob = this.elements.get(this.elements.size() - 1);
        if (ob instanceof FunctionDef) {
            Function fun = ((FunctionDef)ob).getFunction(context);
            return fun.returnTType(resolver, context);
        }
        if (ob instanceof TObject) {
            return ((TObject)ob).getTType();
        }
        if (ob instanceof Operator) {
            Operator op = (Operator)ob;
            return op.returnTType();
        }
        if (ob instanceof Variable) {
            Variable variable = (Variable)ob;
            return resolver.returnTType(variable);
        }
        if (ob instanceof CorrelatedVariable) {
            CorrelatedVariable variable = (CorrelatedVariable)ob;
            return variable.returnTType();
        }
        throw new Error("Unable to determine type for expression.");
    }

    public Object clone() throws CloneNotSupportedException {
        ArrayList cloned_elements;
        Expression v = (Expression)super.clone();
        v.eval_stack = null;
        int size = this.elements.size();
        v.elements = cloned_elements = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            Object element = this.elements.get(i);
            if (element instanceof TObject) {
                TObject tob = (TObject)element;
                TType ttype = tob.getTType();
                if (ttype instanceof TQueryPlanType) {
                    QueryPlanNode node = (QueryPlanNode)tob.getObject();
                    node = (QueryPlanNode)node.clone();
                    element = new TObject(ttype, node);
                } else if (ttype instanceof TArrayType) {
                    Expression[] arr = (Expression[])tob.getObject();
                    arr = (Expression[])arr.clone();
                    for (int n = 0; n < arr.length; ++n) {
                        arr[n] = (Expression)arr[n].clone();
                    }
                    element = new TObject(ttype, arr);
                }
            } else if (!(element instanceof Operator) && !(element instanceof ParameterSubstitution)) {
                if (element instanceof CorrelatedVariable) {
                    element = ((CorrelatedVariable)element).clone();
                } else if (element instanceof Variable) {
                    element = ((Variable)element).clone();
                } else if (element instanceof FunctionDef) {
                    element = ((FunctionDef)element).clone();
                } else if (element instanceof StatementTreeObject) {
                    element = ((StatementTreeObject)element).clone();
                } else {
                    throw new CloneNotSupportedException(element.getClass().toString());
                }
            }
            cloned_elements.add(element);
        }
        return v;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[ Expression ");
        if (this.text() != null) {
            buf.append("[");
            buf.append(this.text().toString());
            buf.append("]");
        }
        buf.append(": ");
        for (int n = 0; n < this.elements.size(); ++n) {
            buf.append(this.elements.get(n));
            if (n >= this.elements.size() - 1) continue;
            buf.append(",");
        }
        buf.append(" ]");
        return new String(buf);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int sz = this.elements.size();
        for (int i = 0; i < sz; ++i) {
            Object ob = this.elements.get(i);
            TObject conv_object = null;
            if (ob == null || ob instanceof NullObject) {
                conv_object = TObject.nullVal();
            } else if (ob instanceof String) {
                conv_object = TObject.stringVal((String)ob);
            } else if (ob instanceof BigDecimal) {
                conv_object = TObject.bigNumberVal(BigNumber.fromBigDecimal((BigDecimal)ob));
            } else if (ob instanceof Date) {
                conv_object = TObject.dateVal((Date)ob);
            } else if (ob instanceof Boolean) {
                conv_object = TObject.booleanVal((Boolean)ob);
            }
            if (conv_object == null) continue;
            this.elements.set(i, conv_object);
        }
    }
}

