/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.RowEnumeration;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import java.io.PrintStream;

class DumpHelper {
    DumpHelper() {
    }

    static void dump(Table table, PrintStream out) {
        int row_num;
        int col_count = table.getColumnCount();
        out.println("Table row count: " + table.getRowCount());
        out.print("      ");
        for (int i = 0; i < col_count; ++i) {
            out.print(table.getResolvedVariable(i).toString());
            if (i >= col_count - 1) continue;
            out.print(", ");
        }
        out.println();
        RowEnumeration r_enum = table.rowEnumeration();
        for (row_num = 0; r_enum.hasMoreRows() && row_num < 250; ++row_num) {
            String num = Integer.toString(row_num);
            int space_gap = 4 - num.length();
            for (int i = 0; i < space_gap; ++i) {
                out.print(' ');
            }
            out.print(num);
            out.print(": ");
            int row_index = r_enum.nextRowIndex();
            for (int col_index = 0; col_index < col_count; ++col_index) {
                TObject cell = table.getCellContents(col_index, row_index);
                out.print(cell.toString());
                if (col_index >= col_count - 1) continue;
                out.print(", ");
            }
            out.println();
        }
        out.println("Finished: " + row_num + "/" + table.getRowCount());
    }
}

