/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.StatementCache;
import com.mckoi.database.Transaction;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.User;
import com.mckoi.database.UserManager;
import com.mckoi.database.WorkerPool;
import com.mckoi.database.control.DBConfig;
import java.util.ArrayList;

public final class DatabaseSystem
extends TransactionSystem {
    private StatementCache statement_cache = null;
    private boolean query_logging;
    private WorkerPool worker_pool;
    private ArrayList database_list;
    private boolean shutdown = false;
    private UserManager user_manager;
    private ShutdownThread shutdown_thread;
    private final ArrayList shut_down_delegates = new ArrayList();
    static /* synthetic */ Class class$com$mckoi$database$DatabaseSystem;

    public void init(DBConfig config) {
        int max_worker_threads;
        super.init(config);
        this.database_list = new ArrayList();
        this.user_manager = new UserManager();
        if (config != null) {
            boolean status = this.getConfigBoolean("statement_cache", true);
            if (status) {
                this.statement_cache = new StatementCache(this, 127, 140, 20);
            }
            this.Debug().write(10000, class$com$mckoi$database$DatabaseSystem == null ? (class$com$mckoi$database$DatabaseSystem = DatabaseSystem.class$("com.mckoi.database.DatabaseSystem")) : class$com$mckoi$database$DatabaseSystem, "statement_cache = " + status);
            max_worker_threads = this.getConfigInt("maximum_worker_threads", 4);
            if (max_worker_threads <= 0) {
                max_worker_threads = 1;
            }
        } else {
            throw new Error("Config bundle already set.");
        }
        this.Debug().write(10000, class$com$mckoi$database$DatabaseSystem == null ? (class$com$mckoi$database$DatabaseSystem = DatabaseSystem.class$("com.mckoi.database.DatabaseSystem")) : class$com$mckoi$database$DatabaseSystem, "Max worker threads set to: " + max_worker_threads);
        this.worker_pool = new WorkerPool(this, max_worker_threads);
        this.query_logging = this.getConfigBoolean("query_logging", false);
        this.shutdown = false;
    }

    public boolean logQueries() {
        return this.query_logging;
    }

    public void dispose() {
        super.dispose();
        this.worker_pool = null;
        this.database_list = null;
        this.user_manager = null;
    }

    public StatementCache getStatementCache() {
        return this.statement_cache;
    }

    public Transaction.CheckExpression prepareTransactionCheckConstraint(DataTableDef table_def, Transaction.CheckExpression check) {
        return super.prepareTransactionCheckConstraint(table_def, check);
    }

    UserManager getUserManager() {
        return this.user_manager;
    }

    void waitUntilAllWorkersQuiet() {
        this.worker_pool.waitUntilAllWorkersQuiet();
    }

    void setIsExecutingCommands(boolean status) {
        this.worker_pool.setIsExecutingCommands(status);
    }

    void execute(User user, DatabaseConnection database, Runnable runner) {
        this.worker_pool.execute(user, database, runner);
    }

    void registerShutDownDelegate(Runnable delegate) {
        this.shut_down_delegates.add(delegate);
    }

    void startShutDownThread() {
        if (!this.shutdown) {
            this.shutdown = true;
            this.shutdown_thread = new ShutdownThread();
            this.shutdown_thread.start();
        }
    }

    boolean hasShutDown() {
        return this.shutdown;
    }

    void waitUntilShutdown() {
        this.shutdown_thread.waitTillFinished();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownThread
    extends Thread {
        private boolean finished = false;

        private ShutdownThread() {
        }

        synchronized void waitTillFinished() {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ShutdownThread shutdownThread = this;
            synchronized (shutdownThread) {
                if (this.finished) {
                    return;
                }
            }
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            DatabaseSystem.this.setIsExecutingCommands(false);
            DatabaseSystem.this.waitUntilAllWorkersQuiet();
            DatabaseSystem.this.worker_pool.shutdown();
            int sz = DatabaseSystem.this.shut_down_delegates.size();
            if (sz == 0) {
                DatabaseSystem.this.Debug().write(20, this, "No shut down delegates registered!");
            } else {
                for (int i = 0; i < sz; ++i) {
                    Runnable shut_down_delegate = (Runnable)DatabaseSystem.this.shut_down_delegates.get(i);
                    shut_down_delegate.run();
                }
                DatabaseSystem.this.shut_down_delegates.clear();
            }
            ShutdownThread shutdownThread2 = this;
            synchronized (shutdownThread2) {
                DatabaseSystem.this.dispose();
                this.finished = true;
                this.notifyAll();
            }
        }
    }
}

