/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractInternalTableInfo;
import com.mckoi.database.ConnectionTriggerManager;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseSystem;
import com.mckoi.database.Expression;
import com.mckoi.database.GTConnectionInfoDataSource;
import com.mckoi.database.GTCurrentConnectionsDataSource;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.GTPrivMapDataSource;
import com.mckoi.database.GTSQLTypeInfoDataSource;
import com.mckoi.database.GTStatisticsDataSource;
import com.mckoi.database.GrantManager;
import com.mckoi.database.InternalJDBCHelper;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.LockingMechanism;
import com.mckoi.database.MasterTableJournal;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.ProcedureConnection;
import com.mckoi.database.ProcedureManager;
import com.mckoi.database.QueryPlan;
import com.mckoi.database.QueryPlanNode;
import com.mckoi.database.RowData;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.SequenceManager;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.TableBackedCache;
import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TableModificationEvent;
import com.mckoi.database.TableName;
import com.mckoi.database.TableQueryDef;
import com.mckoi.database.Transaction;
import com.mckoi.database.TransactionException;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.TriggerEvent;
import com.mckoi.database.TriggerListener;
import com.mckoi.database.User;
import com.mckoi.database.ViewDef;
import com.mckoi.database.ViewManager;
import com.mckoi.database.global.Ref;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.debug.DebugLogger;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;

public class DatabaseConnection
implements TriggerListener {
    private User user;
    private Database database;
    private DebugLogger logger;
    private CallBack call_back;
    private LockingMechanism locking_mechanism;
    private TableDataConglomerate conglomerate;
    private Transaction transaction;
    private Connection jdbc_connection;
    private HashMap tables_cache;
    private ArrayList trigger_event_buffer;
    private ArrayList trigger_event_list;
    private boolean auto_commit;
    private int transaction_isolation;
    private boolean close_transaction_disabled;
    private String current_schema;
    private GrantManager grant_manager;
    private ProcedureManager procedure_manager;
    private ConnectionTriggerManager connection_trigger_manager;
    private ViewManager view_manager;
    private ArrayList table_backed_cache_list;
    private ConnectionInternalTableInfo connection_internal_table_info;
    private boolean error_on_dirty_select;
    private boolean case_insensitive_identifiers;
    private OldAndNewInternalTableInfo old_new_table_info;
    private OldNewTableState current_old_new_state = new OldNewTableState();
    private static final DataTableDef[] INTERNAL_DEF_LIST = new DataTableDef[5];

    DatabaseConnection(Database database, User user, CallBack call_back) {
        this.database = database;
        this.user = user;
        this.logger = database.Debug();
        this.call_back = call_back;
        this.conglomerate = database.getConglomerate();
        this.locking_mechanism = new LockingMechanism(this.Debug());
        this.trigger_event_buffer = new ArrayList();
        this.trigger_event_list = new ArrayList();
        this.tables_cache = new HashMap();
        this.auto_commit = true;
        this.current_schema = "APP";
        this.close_transaction_disabled = false;
        this.table_backed_cache_list = new ArrayList();
        this.connection_internal_table_info = new ConnectionInternalTableInfo();
        this.old_new_table_info = new OldAndNewInternalTableInfo();
        this.error_on_dirty_select = database.getSystem().transactionErrorOnDirtySelect();
        this.case_insensitive_identifiers = database.getSystem().ignoreIdentifierCase();
    }

    void init() {
        this.grant_manager = new GrantManager(this);
        this.procedure_manager = new ProcedureManager(this);
        this.connection_trigger_manager = new ConnectionTriggerManager(this);
        this.view_manager = new ViewManager(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction getTransaction() {
        DatabaseConnection databaseConnection = this;
        synchronized (databaseConnection) {
            if (this.transaction == null) {
                this.transaction = this.conglomerate.createTransaction();
                this.transaction.setErrorOnDirtySelect(this.error_on_dirty_select);
                this.transaction.addInternalTableInfo(this.connection_internal_table_info);
                this.transaction.addInternalTableInfo(this.old_new_table_info);
                this.transaction.addInternalTableInfo(ViewManager.createInternalTableInfo(this.view_manager, this.transaction));
                this.transaction.addInternalTableInfo(ProcedureManager.createInternalTableInfo(this.transaction));
                this.transaction.addInternalTableInfo(SequenceManager.createInternalTableInfo(this.transaction));
                this.transaction.addInternalTableInfo(ConnectionTriggerManager.createInternalTableInfo(this.transaction));
                int sz = this.table_backed_cache_list.size();
                for (int i = 0; i < sz; ++i) {
                    TableBackedCache cache = (TableBackedCache)this.table_backed_cache_list.get(i);
                    cache.transactionStarted();
                }
            }
        }
        return this.transaction;
    }

    QueryPlanNode createViewQueryPlanNode(TableName table_name) {
        return this.view_manager.createViewQueryPlanNode(table_name);
    }

    public Connection getJDBCConnection() {
        if (this.jdbc_connection == null) {
            this.jdbc_connection = InternalJDBCHelper.createJDBCConnection(this.getUser(), this);
        }
        return this.jdbc_connection;
    }

    ProcedureConnection createProcedureConnection(User user) {
        DCProcedureConnection c = new DCProcedureConnection();
        c.previous_user = this.getUser();
        c.transaction_disabled_flag = this.close_transaction_disabled;
        this.setUser(user);
        this.close_transaction_disabled = true;
        return c;
    }

    void disposeProcedureConnection(ProcedureConnection connection) {
        DCProcedureConnection c = (DCProcedureConnection)connection;
        this.setUser(c.previous_user);
        this.close_transaction_disabled = c.transaction_disabled_flag;
        c.dispose();
    }

    public DatabaseSystem getSystem() {
        return this.database.getSystem();
    }

    public Database getDatabase() {
        return this.database;
    }

    TableDataConglomerate getConglomerate() {
        return this.conglomerate;
    }

    void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public final DebugLogger Debug() {
        return this.logger;
    }

    public ConnectionTriggerManager getConnectionTriggerManager() {
        return this.connection_trigger_manager;
    }

    public GrantManager getGrantManager() {
        return this.grant_manager;
    }

    public ProcedureManager getProcedureManager() {
        return this.procedure_manager;
    }

    public void setAutoCommit(boolean status) {
        this.auto_commit = status;
    }

    public void setTransactionIsolation(String name) {
        if (!name.equals("serializable")) {
            throw new Error("Can not set transaction isolation to " + name);
        }
        this.transaction_isolation = 4;
    }

    public void setVar(String name, Expression exp) {
        if (name.toUpperCase().equals("ERROR_ON_DIRTY_SELECT")) {
            this.error_on_dirty_select = DatabaseConnection.toBooleanValue(exp);
        } else if (name.toUpperCase().equals("CASE_INSENSITIVE_IDENTIFIERS")) {
            this.case_insensitive_identifiers = DatabaseConnection.toBooleanValue(exp);
        }
    }

    private static boolean toBooleanValue(Expression exp) {
        Boolean b = exp.evaluate(null, null, null).toBoolean();
        if (b == null) {
            throw new StatementException("Expression does not evaluate to a boolean (true or false).");
        }
        return b;
    }

    public boolean getAutoCommit() {
        return this.auto_commit;
    }

    public int getTransactionIsolation() {
        return this.transaction_isolation;
    }

    public String getTransactionIsolationAsString() {
        int il = this.getTransactionIsolation();
        if (il == 1) {
            return "read uncommitted";
        }
        if (il == 2) {
            return "read committed";
        }
        if (il == 3) {
            return "repeatable read";
        }
        if (il == 4) {
            return "serializable";
        }
        return "unknown isolation level";
    }

    public String getCurrentSchema() {
        return this.current_schema;
    }

    public boolean isInCaseInsensitiveMode() {
        return this.case_insensitive_identifiers;
    }

    public void setCurrentSchema(String current_schema) {
        this.current_schema = current_schema;
    }

    public LockingMechanism getLockingMechanism() {
        return this.locking_mechanism;
    }

    void attachTableBackedCache(TableBackedCache cache) {
        cache.attachTo(this.conglomerate);
        this.table_backed_cache_list.add(cache);
    }

    public TableName[] getTableList() {
        return this.getTransaction().getTableList();
    }

    public boolean tableExists(String table_name) {
        return this.tableExists(new TableName(this.current_schema, table_name));
    }

    public boolean tableExists(TableName table_name) {
        table_name = DatabaseConnection.substituteReservedTableName(table_name);
        return this.getTransaction().tableExists(table_name);
    }

    public String getTableType(TableName table_name) {
        table_name = DatabaseConnection.substituteReservedTableName(table_name);
        return this.getTransaction().getTableType(table_name);
    }

    public TableName tryResolveCase(TableName table_name) {
        table_name = DatabaseConnection.substituteReservedTableName(table_name);
        table_name = this.getTransaction().tryResolveCase(table_name);
        return table_name;
    }

    public TableName resolveTableName(String name) {
        TableName table_name = TableName.resolve(this.getCurrentSchema(), name);
        table_name = DatabaseConnection.substituteReservedTableName(table_name);
        if (this.isInCaseInsensitiveMode()) {
            table_name = this.tryResolveCase(table_name);
        }
        return table_name;
    }

    public TableName resolveToTableName(String name) {
        TableName table_name = TableName.resolve(this.getCurrentSchema(), name);
        if (table_name.getName().equalsIgnoreCase("OLD")) {
            return Database.OLD_TRIGGER_TABLE;
        }
        if (table_name.getName().equalsIgnoreCase("NEW")) {
            return Database.NEW_TRIGGER_TABLE;
        }
        return this.getTransaction().resolveToTableName(this.getCurrentSchema(), name, this.isInCaseInsensitiveMode());
    }

    public DataTableDef getDataTableDef(TableName name) {
        name = DatabaseConnection.substituteReservedTableName(name);
        return this.getTransaction().getDataTableDef(name);
    }

    public DataTable getTable(TableName name) {
        name = DatabaseConnection.substituteReservedTableName(name);
        try {
            if (name.equals(Database.OLD_TRIGGER_TABLE)) {
                if (this.current_old_new_state.OLD_data_table == null) {
                    this.current_old_new_state.OLD_data_table = new DataTable(this, this.getTransaction().getTable(name));
                }
                return this.current_old_new_state.OLD_data_table;
            }
            if (name.equals(Database.NEW_TRIGGER_TABLE)) {
                if (this.current_old_new_state.NEW_data_table == null) {
                    this.current_old_new_state.NEW_data_table = new DataTable(this, this.getTransaction().getTable(name));
                }
                return this.current_old_new_state.NEW_data_table;
            }
            MutableTableDataSource table = this.getTransaction().getTable(name);
            DataTable dtable = (DataTable)this.tables_cache.get(table);
            if (dtable == null) {
                dtable = new DataTable(this, table);
                this.tables_cache.put(table, dtable);
            }
            return dtable;
        }
        catch (DatabaseException e) {
            this.Debug().writeException(e);
            throw new Error("Database Exception: " + e.getMessage());
        }
    }

    public DataTable getTable(String table_name) {
        return this.getTable(new TableName(this.current_schema, table_name));
    }

    public void createTable(DataTableDef table_def) {
        DatabaseConnection.checkAllowCreate(table_def.getTableName());
        this.getTransaction().createTable(table_def);
    }

    public void createTable(DataTableDef table_def, int data_sector_size, int index_sector_size) {
        DatabaseConnection.checkAllowCreate(table_def.getTableName());
        this.getTransaction().createTable(table_def, data_sector_size, index_sector_size);
    }

    public void createView(SQLQuery query, ViewDef view) {
        DatabaseConnection.checkAllowCreate(view.getDataTableDef().getTableName());
        try {
            this.view_manager.defineView(view, query, this.getUser());
        }
        catch (DatabaseException e) {
            this.Debug().writeException(e);
            throw new RuntimeException("Database Exception: " + e.getMessage());
        }
    }

    public boolean dropView(TableName view_name) {
        try {
            return this.view_manager.deleteView(view_name);
        }
        catch (DatabaseException e) {
            this.Debug().writeException(e);
            throw new RuntimeException("Database Exception: " + e.getMessage());
        }
    }

    public void updateTable(DataTableDef table_def) {
        DatabaseConnection.checkAllowCreate(table_def.getTableName());
        this.getTransaction().alterTable(table_def.getTableName(), table_def);
    }

    public void updateTable(DataTableDef table_def, int data_sector_size, int index_sector_size) {
        DatabaseConnection.checkAllowCreate(table_def.getTableName());
        this.getTransaction().alterTable(table_def.getTableName(), table_def, data_sector_size, index_sector_size);
    }

    public void alterCreateTable(DataTableDef table_def, int data_sector_size, int index_sector_size) {
        if (!this.tableExists(table_def.getTableName())) {
            this.createTable(table_def, data_sector_size, index_sector_size);
        } else {
            this.updateTable(table_def, data_sector_size, index_sector_size);
        }
    }

    public void alterCreateTable(DataTableDef table_def) {
        if (!this.tableExists(table_def.getTableName())) {
            this.createTable(table_def);
        } else {
            this.updateTable(table_def);
        }
    }

    void databaseObjectCreated(TableName table_name) {
        this.getTransaction().databaseObjectCreated(table_name);
    }

    void databaseObjectDropped(TableName table_name) {
        this.getTransaction().databaseObjectDropped(table_name);
    }

    public void checkAllConstraints(TableName table_name) {
        this.checkExclusive();
        this.getTransaction().checkAllConstraints(table_name);
    }

    public void dropTable(String table_name) {
        this.dropTable(new TableName(this.current_schema, table_name));
    }

    public void dropTable(TableName table_name) {
        this.getTransaction().dropTable(table_name);
    }

    public void compactTable(String table_name) {
        this.compactTable(new TableName(this.current_schema, table_name));
    }

    public void compactTable(TableName table_name) {
        this.getTransaction().compactTable(table_name);
    }

    public void addSelectedFromTable(String table_name) {
        this.addSelectedFromTable(new TableName(this.current_schema, table_name));
    }

    public void addSelectedFromTable(TableName name) {
        this.getTransaction().addSelectedFromTable(name);
    }

    public long nextSequenceValue(String name) {
        TableName seq_name = this.resolveToTableName(name);
        return this.getTransaction().nextSequenceValue(seq_name);
    }

    public long lastSequenceValue(String name) {
        TableName seq_name = this.resolveToTableName(name);
        return this.getTransaction().lastSequenceValue(seq_name);
    }

    public void setSequenceValue(String name, long value) {
        TableName seq_name = this.resolveToTableName(name);
        this.getTransaction().setSequenceValue(seq_name, value);
    }

    public long nextUniqueID(TableName name) {
        return this.getTransaction().nextUniqueID(name);
    }

    public long nextUniqueID(String table_name) {
        TableName tname = TableName.resolve(this.current_schema, table_name);
        return this.nextUniqueID(tname);
    }

    static TableName substituteReservedTableName(TableName table_name) {
        String name = table_name.getName();
        if (name.equalsIgnoreCase("OLD")) {
            return Database.OLD_TRIGGER_TABLE;
        }
        if (name.equalsIgnoreCase("NEW")) {
            return Database.NEW_TRIGGER_TABLE;
        }
        return table_name;
    }

    static void checkAllowCreate(TableName table_name) {
        String name = table_name.getName();
        if (name.equalsIgnoreCase("OLD") || name.equalsIgnoreCase("NEW")) {
            throw new StatementException("Table name '" + table_name + "' is reserved.");
        }
    }

    public void createSequenceGenerator(TableName name, long start_value, long increment_by, long min_value, long max_value, long cache, boolean cycle) {
        DatabaseConnection.checkAllowCreate(name);
        this.getTransaction().createSequenceGenerator(name, start_value, increment_by, min_value, max_value, cache, cycle);
    }

    public void dropSequenceGenerator(TableName name) {
        this.getTransaction().dropSequenceGenerator(name);
    }

    public void createTrigger(String trigger_name, String trigger_source, int type) {
        this.database.getTriggerManager().addTriggerListener(this, trigger_name, type, trigger_source, this);
    }

    public void deleteTrigger(String trigger_name) {
        this.database.getTriggerManager().removeTriggerListener(this, trigger_name);
    }

    public void notifyTriggerEvent(TriggerEvent evt) {
        this.trigger_event_list.add(evt);
    }

    public Ref createNewLargeObject(byte type, long object_size) {
        if (type == 3 || type == 4) {
            type = (byte)(type | 0x10);
        }
        return this.conglomerate.createNewLargeObject(type, object_size);
    }

    public void flushBlobStore() {
        this.conglomerate.flushBlobStore();
    }

    public TableQueryDef getTableQueryDef(final TableName table_name, final TableName aliased_as) {
        DataTableDef dtf = this.getDataTableDef(table_name);
        if (aliased_as != null) {
            dtf = new DataTableDef(dtf);
            dtf.setTableName(aliased_as);
            dtf.setImmutable();
        }
        final DataTableDef data_table_def = dtf;
        return new TableQueryDef(){

            public DataTableDef getDataTableDef() {
                return data_table_def;
            }

            public QueryPlanNode getQueryPlanNode() {
                return DatabaseConnection.this.createObjectFetchQueryPlan(table_name, aliased_as);
            }
        };
    }

    public QueryPlanNode createObjectFetchQueryPlan(TableName table_name, TableName aliased_name) {
        String table_type = this.getTableType(table_name);
        if (table_type.equals("VIEW")) {
            return new QueryPlan.FetchViewNode(table_name, aliased_name);
        }
        return new QueryPlan.FetchTableNode(table_name, aliased_name);
    }

    public void setDefaultSchema(String schema_name) {
        boolean ignore_case = this.isInCaseInsensitiveMode();
        SchemaDef schema = this.resolveSchemaCase(schema_name, ignore_case);
        if (schema == null) {
            throw new Error("Schema '" + schema_name + "' does not exist.");
        }
        this.setCurrentSchema(schema.getName());
    }

    private void checkExclusive() {
        if (!this.getLockingMechanism().isInExclusiveMode()) {
            throw new Error("Assertion failed: Expected to be in exclusive mode.");
        }
    }

    public void createSchema(String name, String type) {
        this.checkExclusive();
        this.getTransaction().createSchema(name, type);
    }

    public void dropSchema(String name) {
        this.checkExclusive();
        this.getTransaction().dropSchema(name);
    }

    public boolean schemaExists(String name) {
        return this.getTransaction().schemaExists(name);
    }

    public SchemaDef resolveSchemaCase(String name, boolean ignore_case) {
        return this.getTransaction().resolveSchemaCase(name, ignore_case);
    }

    public SchemaDef resolveSchemaName(String name) {
        boolean ignore_case = this.isInCaseInsensitiveMode();
        return this.resolveSchemaCase(name, ignore_case);
    }

    public SchemaDef[] getSchemaList() {
        return this.getTransaction().getSchemaList();
    }

    public void setPersistentVar(String variable, String value) {
        this.checkExclusive();
        this.getTransaction().setPersistentVar(variable, value);
    }

    public String getPersistentVar(String variable) {
        return this.getTransaction().getPersistantVar(variable);
    }

    public void addUniqueConstraint(TableName table_name, String[] cols, short deferred, String constraint_name) {
        this.checkExclusive();
        this.getTransaction().addUniqueConstraint(table_name, cols, deferred, constraint_name);
    }

    public void addForeignKeyConstraint(TableName table, String[] cols, TableName ref_table, String[] ref_cols, String delete_rule, String update_rule, short deferred, String constraint_name) {
        this.checkExclusive();
        this.getTransaction().addForeignKeyConstraint(table, cols, ref_table, ref_cols, delete_rule, update_rule, deferred, constraint_name);
    }

    public void addPrimaryKeyConstraint(TableName table_name, String[] cols, short deferred, String constraint_name) {
        this.checkExclusive();
        this.getTransaction().addPrimaryKeyConstraint(table_name, cols, deferred, constraint_name);
    }

    public void addCheckConstraint(TableName table_name, Expression expression, short deferred, String constraint_name) {
        this.checkExclusive();
        this.getTransaction().addCheckConstraint(table_name, expression, deferred, constraint_name);
    }

    public void dropAllConstraintsForTable(TableName table_name) {
        this.checkExclusive();
        this.getTransaction().dropAllConstraintsForTable(table_name);
    }

    public int dropNamedConstraint(TableName table_name, String constraint_name) {
        this.checkExclusive();
        return this.getTransaction().dropNamedConstraint(table_name, constraint_name);
    }

    public boolean dropPrimaryKeyConstraintForTable(TableName table_name, String constraint_name) {
        this.checkExclusive();
        return this.getTransaction().dropPrimaryKeyConstraintForTable(table_name, constraint_name);
    }

    public TableName[] queryTablesRelationallyLinkedTo(TableName table) {
        return Transaction.queryTablesRelationallyLinkedTo(this.getTransaction(), table);
    }

    public Transaction.ColumnGroup[] queryTableUniqueGroups(TableName table_name) {
        return Transaction.queryTableUniqueGroups(this.getTransaction(), table_name);
    }

    public Transaction.ColumnGroup queryTablePrimaryKeyGroup(TableName table_name) {
        return Transaction.queryTablePrimaryKeyGroup(this.getTransaction(), table_name);
    }

    public Transaction.CheckExpression[] queryTableCheckExpressions(TableName table_name) {
        return Transaction.queryTableCheckExpressions(this.getTransaction(), table_name);
    }

    public Transaction.ColumnGroupReference[] queryTableForeignKeyReferences(TableName table_name) {
        return Transaction.queryTableForeignKeyReferences(this.getTransaction(), table_name);
    }

    public Transaction.ColumnGroupReference[] queryTableImportedForeignKeyReferences(TableName table_name) {
        return Transaction.queryTableImportedForeignKeyReferences(this.getTransaction(), table_name);
    }

    OldNewTableState getOldNewTableState() {
        return this.current_old_new_state;
    }

    void setOldNewTableState(OldNewTableState state) {
        this.current_old_new_state = state;
    }

    void fireTableEvent(TableModificationEvent evt) {
        this.connection_trigger_manager.performTriggerAction(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTrigger(DatabaseConnection database, String trigger_name, TriggerEvent evt) {
        block8: {
            if (this != database) {
                throw new Error("User object mismatch.");
            }
            try {
                if (this.call_back == null) break block8;
                ArrayList arrayList = this.trigger_event_buffer;
                synchronized (arrayList) {
                    if (this.transaction == null) {
                        this.call_back.triggerNotify(trigger_name, evt.getType(), evt.getSource(), evt.getCount());
                    } else {
                        this.trigger_event_buffer.add(trigger_name);
                        this.trigger_event_buffer.add(evt);
                    }
                }
            }
            catch (Throwable e) {
                this.Debug().write(40, this, "TRIGGER Exception: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePendingTriggerEvents() {
        int sz;
        ArrayList arrayList = this.trigger_event_buffer;
        synchronized (arrayList) {
            sz = this.trigger_event_buffer.size();
        }
        if (sz > 0) {
            Runnable runner = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList arrayList = DatabaseConnection.this.trigger_event_buffer;
                    synchronized (arrayList) {
                        for (int i = 0; i < DatabaseConnection.this.trigger_event_buffer.size(); i += 2) {
                            String trigger_name = (String)DatabaseConnection.this.trigger_event_buffer.get(i);
                            TriggerEvent evt = (TriggerEvent)DatabaseConnection.this.trigger_event_buffer.get(i + 1);
                            DatabaseConnection.this.call_back.triggerNotify(trigger_name, evt.getType(), evt.getSource(), evt.getCount());
                        }
                        DatabaseConnection.this.trigger_event_buffer.clear();
                    }
                }
            };
            this.database.postEvent(3, this.database.createEvent(runner));
        }
    }

    private void disposeTransaction() {
        this.transaction = null;
        this.firePendingTriggerEvents();
        this.trigger_event_list.clear();
        int sz = this.table_backed_cache_list.size();
        for (int i = 0; i < sz; ++i) {
            TableBackedCache cache = (TableBackedCache)this.table_backed_cache_list.get(i);
            cache.transactionFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws TransactionException {
        if (this.close_transaction_disabled) {
            throw new RuntimeException("Commit is not allowed.");
        }
        if (this.user != null) {
            this.user.refreshLastCommandTime();
        }
        this.getLockingMechanism().reset();
        this.tables_cache.clear();
        if (this.transaction != null) {
            try {
                this.transaction.closeAndCommit();
                this.database.getTriggerManager().flushTriggerEvents(this.trigger_event_list);
            }
            finally {
                this.disposeTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        block9: {
            if (this.close_transaction_disabled) {
                throw new RuntimeException("Rollback is not allowed.");
            }
            if (this.user != null) {
                this.user.refreshLastCommandTime();
            }
            this.tables_cache.clear();
            if (this.transaction != null) {
                this.getLockingMechanism().reset();
                try {
                    this.transaction.closeAndRollback();
                    Object var2_1 = null;
                    this.disposeTransaction();
                    if (this.jdbc_connection == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.disposeTransaction();
                    if (this.jdbc_connection != null) {
                        try {
                            InternalJDBCHelper.disposeJDBCConnection(this.jdbc_connection);
                        }
                        catch (Throwable e) {
                            this.Debug().write(40, this, "Error disposing internal JDBC connection.");
                            this.Debug().writeException(40, e);
                        }
                        this.jdbc_connection = null;
                    }
                    throw throwable;
                }
                try {
                    InternalJDBCHelper.disposeJDBCConnection(this.jdbc_connection);
                }
                catch (Throwable e) {
                    this.Debug().write(40, this, "Error disposing internal JDBC connection.");
                    this.Debug().writeException(40, e);
                }
                this.jdbc_connection = null;
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void close() {
        block14: {
            block13: {
                this.rollback();
                Object var3_1 = null;
                if (this.table_backed_cache_list == null) break block13;
                try {
                    int sz = this.table_backed_cache_list.size();
                    for (int i = 0; i < sz; ++i) {
                        TableBackedCache cache = (TableBackedCache)this.table_backed_cache_list.get(i);
                        cache.detatchFrom(this.conglomerate);
                    }
                    this.table_backed_cache_list = null;
                }
                catch (Throwable e2) {
                    e2.printStackTrace(System.err);
                }
            }
            this.database.getTriggerManager().clearAllDatabaseConnectionTriggers(this);
            {
                break block14;
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                    Object var3_2 = null;
                    if (this.table_backed_cache_list != null) {
                        try {
                            int sz = this.table_backed_cache_list.size();
                            for (int i = 0; i < sz; ++i) {
                                TableBackedCache cache = (TableBackedCache)this.table_backed_cache_list.get(i);
                                cache.detatchFrom(this.conglomerate);
                            }
                            this.table_backed_cache_list = null;
                        }
                        catch (Throwable e2) {
                            e2.printStackTrace(System.err);
                        }
                    }
                    this.database.getTriggerManager().clearAllDatabaseConnectionTriggers(this);
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.table_backed_cache_list != null) {
                    try {
                        int sz = this.table_backed_cache_list.size();
                        for (int i = 0; i < sz; ++i) {
                            TableBackedCache cache = (TableBackedCache)this.table_backed_cache_list.get(i);
                            cache.detatchFrom(this.conglomerate);
                        }
                        this.table_backed_cache_list = null;
                    }
                    catch (Throwable e2) {
                        e2.printStackTrace(System.err);
                    }
                }
                this.database.getTriggerManager().clearAllDatabaseConnectionTriggers(this);
                throw throwable;
            }
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    static {
        DatabaseConnection.INTERNAL_DEF_LIST[0] = GTStatisticsDataSource.DEF_DATA_TABLE_DEF;
        DatabaseConnection.INTERNAL_DEF_LIST[1] = GTConnectionInfoDataSource.DEF_DATA_TABLE_DEF;
        DatabaseConnection.INTERNAL_DEF_LIST[2] = GTCurrentConnectionsDataSource.DEF_DATA_TABLE_DEF;
        DatabaseConnection.INTERNAL_DEF_LIST[3] = GTSQLTypeInfoDataSource.DEF_DATA_TABLE_DEF;
        DatabaseConnection.INTERNAL_DEF_LIST[4] = GTPrivMapDataSource.DEF_DATA_TABLE_DEF;
    }

    static class OldNewTableState {
        TableName trigger_source;
        int OLD_row_index = -1;
        RowData NEW_row_data;
        boolean mutable_NEW;
        DataTable OLD_data_table;
        DataTable NEW_data_table;

        OldNewTableState(TableName table_source, int old_d, RowData new_d, boolean is_mutable) {
            this.trigger_source = table_source;
            this.OLD_row_index = old_d;
            this.NEW_row_data = new_d;
            this.mutable_NEW = is_mutable;
        }

        OldNewTableState() {
        }
    }

    public static interface CallBack {
        public void triggerNotify(String var1, int var2, String var3, int var4);
    }

    private class ConnectionInternalTableInfo
    extends AbstractInternalTableInfo {
        public ConnectionInternalTableInfo() {
            super("SYSTEM TABLE", INTERNAL_DEF_LIST);
        }

        public MutableTableDataSource createInternalTable(int index) {
            if (index == 0) {
                return new GTStatisticsDataSource(DatabaseConnection.this).init();
            }
            if (index == 1) {
                return new GTConnectionInfoDataSource(DatabaseConnection.this).init();
            }
            if (index == 2) {
                return new GTCurrentConnectionsDataSource(DatabaseConnection.this).init();
            }
            if (index == 3) {
                return new GTSQLTypeInfoDataSource(DatabaseConnection.this).init();
            }
            if (index == 4) {
                return new GTPrivMapDataSource(DatabaseConnection.this);
            }
            throw new RuntimeException();
        }
    }

    private static class TriggeredOldNewDataSource
    extends GTDataSource {
        private DataTableDef table_def;
        private RowData content;
        private boolean immutable;

        public TriggeredOldNewDataSource(TransactionSystem system, DataTableDef table_def) {
            super(system);
            this.table_def = table_def;
        }

        void setImmutable(boolean im) {
            this.immutable = im;
        }

        void setRowData(RowData row_data) {
            this.content = row_data;
        }

        public DataTableDef getDataTableDef() {
            return this.table_def;
        }

        public int getRowCount() {
            return 1;
        }

        public TObject getCellContents(int column, int row) {
            if (row < 0 || row > 0) {
                throw new RuntimeException("Row index out of bounds.");
            }
            return this.content.getCellData(column);
        }

        public int addRow(RowData row_data) {
            throw new RuntimeException("Inserting into table '" + this.getDataTableDef().getTableName() + "' is not permitted.");
        }

        public void removeRow(int row_index) {
            throw new RuntimeException("Deleting from table '" + this.getDataTableDef().getTableName() + "' is not permitted.");
        }

        public int updateRow(int row_index, RowData row_data) {
            if (this.immutable) {
                throw new RuntimeException("Updating table '" + this.getDataTableDef().getTableName() + "' is not permitted.");
            }
            if (row_index < 0 || row_index > 0) {
                throw new RuntimeException("Row index out of bounds.");
            }
            int sz = this.getDataTableDef().columnCount();
            for (int i = 0; i < sz; ++i) {
                this.content.setColumnDataFromTObject(i, row_data.getCellData(i));
            }
            return 0;
        }

        public MasterTableJournal getJournal() {
            throw new RuntimeException("Invalid method used.");
        }

        public void flushIndexChanges() {
            throw new RuntimeException("Invalid method used.");
        }

        public void constraintIntegrityCheck() {
        }
    }

    private class OldAndNewInternalTableInfo
    implements InternalTableInfo {
        private OldAndNewInternalTableInfo() {
        }

        private boolean hasOLDTable() {
            return ((DatabaseConnection)DatabaseConnection.this).current_old_new_state.OLD_row_index != -1;
        }

        private boolean hasNEWTable() {
            return ((DatabaseConnection)DatabaseConnection.this).current_old_new_state.NEW_row_data != null;
        }

        public int getTableCount() {
            int count = 0;
            if (this.hasOLDTable()) {
                ++count;
            }
            if (this.hasNEWTable()) {
                ++count;
            }
            return count;
        }

        public int findTableName(TableName name) {
            if (this.hasOLDTable() && name.equals(Database.OLD_TRIGGER_TABLE)) {
                return 0;
            }
            if (this.hasNEWTable() && name.equals(Database.NEW_TRIGGER_TABLE)) {
                if (this.hasOLDTable()) {
                    return 1;
                }
                return 0;
            }
            return -1;
        }

        public TableName getTableName(int i) {
            if (this.hasOLDTable() && i == 0) {
                return Database.OLD_TRIGGER_TABLE;
            }
            return Database.NEW_TRIGGER_TABLE;
        }

        public boolean containsTableName(TableName name) {
            return this.findTableName(name) != -1;
        }

        public String getTableType(int i) {
            return "SYSTEM TABLE";
        }

        public DataTableDef getDataTableDef(int i) {
            DataTableDef table_def = DatabaseConnection.this.getDataTableDef(((DatabaseConnection)DatabaseConnection.this).current_old_new_state.trigger_source);
            DataTableDef new_table_def = new DataTableDef(table_def);
            new_table_def.setTableName(this.getTableName(i));
            return new_table_def;
        }

        public MutableTableDataSource createInternalTable(int index) {
            DataTableDef t_def = this.getDataTableDef(index);
            TriggeredOldNewDataSource table = new TriggeredOldNewDataSource(DatabaseConnection.this.getSystem(), t_def);
            if (this.hasOLDTable() && index == 0) {
                DataTable dtable = DatabaseConnection.this.getTable(((DatabaseConnection)DatabaseConnection.this).current_old_new_state.trigger_source);
                RowData old_row_data = new RowData(table);
                int row_index = ((DatabaseConnection)DatabaseConnection.this).current_old_new_state.OLD_row_index;
                for (int i = 0; i < t_def.columnCount(); ++i) {
                    old_row_data.setColumnDataFromTObject(i, dtable.getCellContents(i, row_index));
                }
                table.setImmutable(true);
                table.setRowData(old_row_data);
                return table;
            }
            table.setImmutable(!((DatabaseConnection)DatabaseConnection.this).current_old_new_state.mutable_NEW);
            table.setRowData(((DatabaseConnection)DatabaseConnection.this).current_old_new_state.NEW_row_data);
            return table;
        }
    }

    private class DCProcedureConnection
    implements ProcedureConnection {
        private User previous_user;
        private boolean transaction_disabled_flag;
        private Connection jdbc_connection;

        private DCProcedureConnection() {
        }

        public Connection getJDBCConnection() {
            if (this.jdbc_connection == null) {
                this.jdbc_connection = InternalJDBCHelper.createJDBCConnection(DatabaseConnection.this.getUser(), DatabaseConnection.this);
            }
            return this.jdbc_connection;
        }

        public Database getDatabase() {
            return DatabaseConnection.this.getDatabase();
        }

        void dispose() {
            this.previous_user = null;
            if (this.jdbc_connection != null) {
                try {
                    InternalJDBCHelper.disposeJDBCConnection(this.jdbc_connection);
                }
                catch (Throwable e) {
                    DatabaseConnection.this.Debug().write(40, this, "Error disposing internal JDBC connection.");
                    DatabaseConnection.this.Debug().writeException(40, e);
                }
            }
        }
    }
}

