/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Assignment;
import com.mckoi.database.BlobStore;
import com.mckoi.database.DataCellCache;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseConstants;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseProcedure;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.DatabaseSystem;
import com.mckoi.database.Expression;
import com.mckoi.database.GrantManager;
import com.mckoi.database.LockingMechanism;
import com.mckoi.database.Operator;
import com.mckoi.database.Privileges;
import com.mckoi.database.ProcedureManager;
import com.mckoi.database.ProcedureName;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.SchemaDef;
import com.mckoi.database.StateStore;
import com.mckoi.database.StoreSystem;
import com.mckoi.database.TObject;
import com.mckoi.database.TType;
import com.mckoi.database.Table;
import com.mckoi.database.TableDataConglomerate;
import com.mckoi.database.TableName;
import com.mckoi.database.TemporaryTable;
import com.mckoi.database.TransactionException;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.TriggerManager;
import com.mckoi.database.User;
import com.mckoi.database.UserManager;
import com.mckoi.database.V1FileStoreSystem;
import com.mckoi.database.Variable;
import com.mckoi.database.control.DefaultDBConfig;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.Ref;
import com.mckoi.database.global.StringObject;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.debug.DebugLogger;
import com.mckoi.store.MutableArea;
import com.mckoi.store.Store;
import com.mckoi.util.Log;
import com.mckoi.util.Stats;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;

public final class Database
implements DatabaseConstants {
    public static final String SYSTEM_SCHEMA = "SYS_INFO";
    public static final String DEFAULT_SCHEMA = "APP";
    public static final String JDBC_SCHEMA = "SYS_JDBC";
    public static final TableName SYS_PASSWORD = new TableName("SYS_INFO", "sUSRPassword");
    public static final TableName SYS_USERCONNECT = new TableName("SYS_INFO", "sUSRUserConnectPriv");
    public static final TableName SYS_USERPRIV = new TableName("SYS_INFO", "sUSRUserPriv");
    public static final TableName SYS_GRANTS = new TableName("SYS_INFO", "sUSRGrant");
    public static final TableName SYS_SERVICE = new TableName("SYS_INFO", "sUSRService");
    public static final TableName SYS_FUNCTIONFACTORY = new TableName("SYS_INFO", "sUSRFunctionFactory");
    public static final TableName SYS_FUNCTION = new TableName("SYS_INFO", "sUSRFunction");
    public static final TableName SYS_VIEW = new TableName("SYS_INFO", "sUSRView");
    public static final TableName SYS_LABEL = new TableName("SYS_INFO", "sUSRLabel");
    public static final TableName SYS_TABLE_COLUMNS = new TableName("SYS_INFO", "sUSRTableColumns");
    public static final TableName SYS_TABLE_INFO = new TableName("SYS_INFO", "sUSRTableInfo");
    public static final TableName SYS_DATA_TRIGGER = new TableName("SYS_INFO", "sUSRDataTrigger");
    public static final TableName SYS_DB_STATISTICS = new TableName("SYS_INFO", "sUSRDatabaseStatistics");
    public static final TableName OLD_TRIGGER_TABLE = new TableName("SYS_INFO", "OLD");
    public static final TableName NEW_TRIGGER_TABLE = new TableName("SYS_INFO", "NEW");
    public static final String LOCK_GROUP = "#locked";
    public static final String SECURE_GROUP = "secure access";
    public static final String USER_MANAGER_GROUP = "user manager";
    public static final String SCHEMA_MANAGER_GROUP = "schema manager";
    public static final String INTERNAL_SECURE_USERNAME = "@SYSTEM";
    private DatabaseSystem system;
    private String name;
    private TableDataConglomerate conglomerate;
    private boolean delete_on_shutdown;
    private User internal_system_user;
    private TriggerManager trigger_manager;
    private Log commands_log;
    private boolean initialised = false;
    private final Table SINGLE_ROW_TABLE;
    static /* synthetic */ Class class$com$mckoi$database$procedure$SystemBackup;

    public Database(DatabaseSystem system, String name) {
        this.system = system;
        this.delete_on_shutdown = false;
        this.name = name;
        this.conglomerate = new TableDataConglomerate(system, system.storeSystem());
        this.internal_system_user = new User(INTERNAL_SECURE_USERNAME, this, "", System.currentTimeMillis());
        TemporaryTable t = new TemporaryTable(this, "SINGLE_ROW_TABLE", new DataTableColumnDef[0]);
        t.newRow();
        this.SINGLE_ROW_TABLE = t;
        this.trigger_manager = new TriggerManager(system);
    }

    public String getName() {
        return this.name;
    }

    public boolean isReadOnly() {
        return this.getSystem().readOnlyAccess();
    }

    private User internalSystemUser() {
        return this.internal_system_user;
    }

    public Log getCommandsLog() {
        return this.commands_log;
    }

    TableDataConglomerate getConglomerate() {
        return this.conglomerate;
    }

    public DatabaseConnection createNewConnection(User user, DatabaseConnection.CallBack call_back) {
        if (user == null) {
            user = this.internalSystemUser();
        }
        DatabaseConnection connection = new DatabaseConnection(this, user, call_back);
        connection.init();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public User authenticateUser(String username, String password, String connection_string) {
        User user;
        User user2;
        DatabaseConnection connection = this.createNewConnection(null, null);
        DatabaseQueryContext context = new DatabaseQueryContext(connection);
        connection.setCurrentSchema(SYSTEM_SCHEMA);
        LockingMechanism locker = connection.getLockingMechanism();
        locker.setMode(2);
        Connection jdbc = connection.getJDBCConnection();
        PreparedStatement stmt = jdbc.prepareStatement(" SELECT \"UserName\" FROM \"sUSRPassword\"   WHERE \"sUSRPassword.UserName\" = ?     AND \"sUSRPassword.Password\" = ? ");
        stmt.setString(1, username);
        stmt.setString(2, password);
        ResultSet rs = stmt.executeQuery();
        if (rs.next()) break block18;
        User user3 = null;
        Object var13_14 = null;
        try {
            connection.commit();
        }
        catch (TransactionException e) {
            this.Debug().writeException(20, e);
        }
        finally {
            locker.finishMode(2);
        }
        connection.close();
        {
            block18: {
                return user3;
            }
            rs.close();
            stmt.close();
            if (!this.userAllowedAccessFromHost(context, username, connection_string)) break block20;
            User user4 = new User(username, this, connection_string, System.currentTimeMillis());
            this.system.getUserManager().userLoggedIn(user4);
            user2 = user4;
        }
        Object var13_15 = null;
        try {
            connection.commit();
            locker.finishMode(2);
        }
        catch (TransactionException e) {
            try {}
            catch (Throwable throwable) {
                locker.finishMode(2);
                throw throwable;
            }
            this.Debug().writeException(20, e);
            locker.finishMode(2);
        }
        connection.close();
        {
            block20: {
                return user2;
            }
            user = null;
        }
        Object var13_16 = null;
        try {
            connection.commit();
            locker.finishMode(2);
        }
        catch (TransactionException e) {
            try {}
            catch (Throwable throwable) {
                locker.finishMode(2);
                throw throwable;
            }
            this.Debug().writeException(20, e);
            locker.finishMode(2);
        }
        connection.close();
        {
            return user;
            catch (SQLException e) {
                if (e instanceof MSQLException) {
                    MSQLException msqle = (MSQLException)e;
                    this.Debug().write(40, this, msqle.getServerErrorStackTrace());
                }
                this.Debug().writeException(40, e);
                throw new RuntimeException("SQL Error: " + e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            try {
                connection.commit();
                locker.finishMode(2);
            }
            catch (TransactionException e) {
                try {}
                catch (Throwable throwable2) {
                    locker.finishMode(2);
                    throw throwable2;
                }
                this.Debug().writeException(20, e);
                locker.finishMode(2);
            }
            connection.close();
            throw throwable;
        }
    }

    private boolean userAllowedAccessFromHost(DatabaseQueryContext context, String username, String connection_string) {
        if (username.equals(INTERNAL_SECURE_USERNAME)) {
            return false;
        }
        if (connection_string.startsWith("Internal/")) {
            return true;
        }
        int protocol_host_deliminator = connection_string.indexOf("/");
        String protocol = connection_string.substring(0, protocol_host_deliminator);
        String host = connection_string.substring(protocol_host_deliminator + 1);
        if (this.Debug().isInterestedIn(10)) {
            this.Debug().write(10, this, "Checking host: protocol = " + protocol + ", host = " + host);
        }
        DataTable connect_priv = context.getTable(SYS_USERCONNECT);
        Variable un_col = connect_priv.getResolvedVariable(0);
        Variable proto_col = connect_priv.getResolvedVariable(1);
        Variable host_col = connect_priv.getResolvedVariable(2);
        Variable access_col = connect_priv.getResolvedVariable(3);
        Table t = connect_priv.simpleSelect(context, un_col, Operator.get("="), new Expression(TObject.stringVal(username)));
        Expression exp = Expression.simple(TObject.stringVal(protocol), Operator.get("like"), proto_col);
        t = t.exhaustiveSelect(context, exp);
        exp = Expression.simple(TObject.stringVal(host), Operator.get("like"), host_col);
        Table t2 = (t = t.exhaustiveSelect(context, exp)).simpleSelect(context, access_col, Operator.get("="), new Expression(TObject.stringVal("DENY")));
        if (t2.getRowCount() > 0) {
            return false;
        }
        Table t3 = t.simpleSelect(context, access_col, Operator.get("="), new Expression(TObject.stringVal("ALLOW")));
        return t3.getRowCount() > 0;
    }

    public boolean userExists(DatabaseQueryContext context, String username) throws DatabaseException {
        Variable c1;
        DataTable table = context.getTable(SYS_PASSWORD);
        Table t = table.simpleSelect(context, c1 = table.getResolvedVariable(0), Operator.get("="), new Expression(TObject.stringVal(username)));
        return t.getRowCount() > 0;
    }

    public void createUser(DatabaseQueryContext context, String username, String password) throws DatabaseException {
        if (username == null || password == null) {
            throw new DatabaseException("Username or password can not be NULL.");
        }
        if (username.length() <= 1) {
            throw new DatabaseException("Username must be at least 2 characters.");
        }
        if (password.length() <= 1) {
            throw new DatabaseException("Password must be at least 2 characters.");
        }
        if (this.userExists(context, username)) {
            throw new DatabaseException("User '" + username + "' already exists.");
        }
        if (username.equalsIgnoreCase("public")) {
            throw new DatabaseException("User '" + username + "' not allowed - reserved.");
        }
        char c = username.charAt(0);
        if (c == '@' || c == '&' || c == '#' || c == '$') {
            throw new DatabaseException("User name can not start with '" + c + "' character.");
        }
        DataTable table = context.getTable(SYS_PASSWORD);
        RowData rdat = new RowData(table);
        rdat.setColumnDataFromObject(0, username);
        rdat.setColumnDataFromObject(1, password);
        table.add(rdat);
    }

    public void deleteAllUserGroups(DatabaseQueryContext context, String username) throws DatabaseException {
        Operator EQUALS_OP = Operator.get("=");
        Expression USER_EXPR = new Expression(TObject.stringVal(username));
        DataTable table = context.getTable(SYS_USERPRIV);
        Variable c1 = table.getResolvedVariable(0);
        Table t = table.simpleSelect(context, c1, EQUALS_OP, USER_EXPR);
        table.delete(t);
    }

    public void deleteUser(DatabaseQueryContext context, String username) throws DatabaseException {
        Operator EQUALS_OP = Operator.get("=");
        Expression USER_EXPR = new Expression(TObject.stringVal(username));
        this.deleteAllUserGroups(context, username);
        DataTable table = context.getTable(SYS_USERCONNECT);
        Variable c1 = table.getResolvedVariable(0);
        Table t = table.simpleSelect(context, c1, EQUALS_OP, USER_EXPR);
        table.delete(t);
        table = context.getTable(SYS_PASSWORD);
        c1 = table.getResolvedVariable(0);
        t = table.simpleSelect(context, c1, EQUALS_OP, USER_EXPR);
        table.delete(t);
    }

    public void alterUserPassword(DatabaseQueryContext context, String username, String password) throws DatabaseException {
        Variable c1;
        Operator EQUALS_OP = Operator.get("=");
        Expression USER_EXPR = new Expression(TObject.stringVal(username));
        DataTable table = context.getTable(SYS_PASSWORD);
        Table t = table.simpleSelect(context, c1 = table.getResolvedVariable(0), EQUALS_OP, USER_EXPR);
        if (t.getRowCount() != 1) {
            throw new DatabaseException("Username '" + username + "' was not found.");
        }
        table.delete(t);
        table = context.getTable(SYS_PASSWORD);
        RowData rdat = new RowData(table);
        rdat.setColumnDataFromObject(0, username);
        rdat.setColumnDataFromObject(1, password);
        table.add(rdat);
    }

    public String[] groupsUserBelongsTo(DatabaseQueryContext context, String username) throws DatabaseException {
        DataTable table = context.getTable(SYS_USERPRIV);
        Variable c1 = table.getResolvedVariable(0);
        Table t = table.simpleSelect(context, c1, Operator.get("="), new Expression(TObject.stringVal(username)));
        int sz = t.getRowCount();
        String[] groups = new String[sz];
        RowEnumeration row_enum = t.rowEnumeration();
        int i = 0;
        while (row_enum.hasMoreRows()) {
            groups[i] = t.getCellContents(1, row_enum.nextRowIndex()).getObject().toString();
            ++i;
        }
        return groups;
    }

    public boolean userBelongsToGroup(DatabaseQueryContext context, String username, String group) throws DatabaseException {
        DataTable table = context.getTable(SYS_USERPRIV);
        Variable c1 = table.getResolvedVariable(0);
        Variable c2 = table.getResolvedVariable(1);
        Table t = table.simpleSelect(context, c1, Operator.get("="), new Expression(TObject.stringVal(username)));
        return (t = t.simpleSelect(context, c2, Operator.get("="), new Expression(TObject.stringVal(group)))).getRowCount() > 0;
    }

    public void addUserToGroup(DatabaseQueryContext context, String username, String group) throws DatabaseException {
        if (group == null) {
            throw new DatabaseException("Can add NULL group.");
        }
        char c = group.charAt(0);
        if (c == '@' || c == '&' || c == '#' || c == '$') {
            throw new DatabaseException("The group name can not start with '" + c + "' character.");
        }
        if (!this.userBelongsToGroup(context, username, group)) {
            DataTable table = context.getTable(SYS_USERPRIV);
            RowData rdat = new RowData(table);
            rdat.setColumnDataFromObject(0, username);
            rdat.setColumnDataFromObject(1, group);
            table.add(rdat);
        }
    }

    public void setUserLock(DatabaseQueryContext context, User user, boolean lock_status) throws DatabaseException {
        boolean user_belongs_to_lock_group;
        String username = user.getUserName();
        DataTable table = context.getTable(SYS_USERPRIV);
        Variable c1 = table.getResolvedVariable(0);
        Variable c2 = table.getResolvedVariable(1);
        Table t = table.simpleSelect(context, c1, Operator.get("="), new Expression(TObject.stringVal(username)));
        boolean bl = user_belongs_to_lock_group = (t = t.simpleSelect(context, c2, Operator.get("="), new Expression(TObject.stringVal(LOCK_GROUP)))).getRowCount() > 0;
        if (lock_status && !user_belongs_to_lock_group) {
            RowData rdat = new RowData(table);
            rdat.setColumnDataFromObject(0, username);
            rdat.setColumnDataFromObject(1, LOCK_GROUP);
            table.add(rdat);
        } else if (!lock_status && user_belongs_to_lock_group) {
            table.delete(t);
        }
    }

    public void grantHostAccessToUser(DatabaseQueryContext context, String user, String protocol, String host) throws DatabaseException {
        DataTable table = context.getTable(SYS_USERCONNECT);
        RowData rdat = new RowData(table);
        rdat.setColumnDataFromObject(0, user);
        rdat.setColumnDataFromObject(1, protocol);
        rdat.setColumnDataFromObject(2, host);
        rdat.setColumnDataFromObject(3, "ALLOW");
        table.add(rdat);
    }

    private boolean userHasSecureAccess(DatabaseQueryContext context, User user) throws DatabaseException {
        if (user.getUserName().equals(INTERNAL_SECURE_USERNAME)) {
            return true;
        }
        return this.userBelongsToGroup(context, user.getUserName(), SECURE_GROUP);
    }

    private boolean userHasSchemaGrant(DatabaseQueryContext context, User user, String schema, int grant) throws DatabaseException {
        if (user.getUserName().equals(INTERNAL_SECURE_USERNAME)) {
            return true;
        }
        if (schema.equals(SYSTEM_SCHEMA)) {
            return false;
        }
        GrantManager manager = context.getGrantManager();
        Privileges privs = manager.userGrants(65, schema, user.getUserName());
        return privs.permits(grant);
    }

    private boolean userHasTableObjectGrant(DatabaseQueryContext context, User user, TableName table_name, Variable[] columns, int grant) throws DatabaseException {
        if (user.getUserName().equals(INTERNAL_SECURE_USERNAME)) {
            return true;
        }
        GrantManager manager = context.getGrantManager();
        Privileges privs = manager.userGrants(1, table_name.toString(), user.getUserName());
        return privs.permits(grant);
    }

    public boolean canUserCreateAndDropUsers(DatabaseQueryContext context, User user) throws DatabaseException {
        return this.userHasSecureAccess(context, user) || this.userBelongsToGroup(context, user.getUserName(), USER_MANAGER_GROUP);
    }

    public boolean canUserCreateAndDropSchema(DatabaseQueryContext context, User user, String schema) throws DatabaseException {
        if (user.getUserName().equals(INTERNAL_SECURE_USERNAME)) {
            return true;
        }
        if (schema.equals(SYSTEM_SCHEMA)) {
            return false;
        }
        return this.userHasSecureAccess(context, user) || this.userBelongsToGroup(context, user.getUserName(), SCHEMA_MANAGER_GROUP);
    }

    public boolean canUserShutDown(DatabaseQueryContext context, User user) throws DatabaseException {
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserExecuteStoredProcedure(DatabaseQueryContext context, User user, String procedure_name) throws DatabaseException {
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserCreateTableObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 128)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserAlterTableObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 256)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserDropTableObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 512)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserSelectFromTableObject(DatabaseQueryContext context, User user, TableName table, Variable[] columns) throws DatabaseException {
        if (this.userHasTableObjectGrant(context, user, table, columns, 1)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserInsertIntoTableObject(DatabaseQueryContext context, User user, TableName table, Variable[] columns) throws DatabaseException {
        if (this.userHasTableObjectGrant(context, user, table, columns, 8)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserUpdateTableObject(DatabaseQueryContext context, User user, TableName table, Variable[] columns) throws DatabaseException {
        if (this.userHasTableObjectGrant(context, user, table, columns, 4)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserDeleteFromTableObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasTableObjectGrant(context, user, table, null, 2)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserCompactTableObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasTableObjectGrant(context, user, table, null, 64)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserCreateProcedureObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 128)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserDropProcedureObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 512)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserCreateSequenceObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 128)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    public boolean canUserDropSequenceObject(DatabaseQueryContext context, User user, TableName table) throws DatabaseException {
        if (this.userHasSchemaGrant(context, user, table.getSchema(), 512)) {
            return true;
        }
        return this.userHasSecureAccess(context, user);
    }

    void createSchemaInfoTables(DatabaseConnection connection) throws DatabaseException {
        connection.createSchema(DEFAULT_SCHEMA, "DEFAULT");
        connection.createSchema(JDBC_SCHEMA, "SYSTEM");
    }

    private void createSystemViews(DatabaseConnection connection) throws DatabaseException {
        try {
            Connection jdbc = connection.getJDBCConnection();
            Statement stmt = jdbc.createStatement();
            stmt.executeUpdate("CREATE VIEW SYS_JDBC.ThisUserSimpleGrant AS   SELECT \"priv_bit\", \"object\", \"param\", \"grantee\",          \"grant_option\", \"granter\"     FROM SYS_INFO.sUSRGrant    WHERE ( grantee = user() OR grantee = '@PUBLIC' )");
            stmt.executeUpdate("CREATE VIEW SYS_JDBC.ThisUserGrant AS   SELECT \"description\", \"object\", \"param\", \"grantee\",          \"grant_option\", \"granter\"     FROM SYS_INFO.sUSRGrant, SYS_INFO.sUSRPrivMap    WHERE ( grantee = user() OR grantee = '@PUBLIC' )     AND sUSRGrant.priv_bit = sUSRPrivMap.priv_bit");
            stmt.executeUpdate("CREATE VIEW SYS_JDBC.ThisUserSchemaInfo AS   SELECT * FROM SYS_INFO.sUSRSchemaInfo    WHERE \"name\" IN (      SELECT \"param\"        FROM SYS_JDBC.ThisUserGrant       WHERE \"object\" = 65         AND \"description\" = 'LIST' )");
            stmt.executeUpdate("CREATE VIEW SYS_JDBC.ThisUserTableColumns AS   SELECT * FROM SYS_INFO.sUSRTableColumns    WHERE \"schema\" IN (      SELECT \"name\" FROM SYS_JDBC.ThisUserSchemaInfo )");
            stmt.executeUpdate("CREATE VIEW SYS_JDBC.ThisUserTableInfo AS   SELECT * FROM SYS_INFO.sUSRTableInfo    WHERE \"schema\" IN (      SELECT \"name\" FROM SYS_JDBC.ThisUserSchemaInfo )");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.Tables AS   SELECT NULL AS \"TABLE_CAT\", \n         \"schema\" AS \"TABLE_SCHEM\", \n         \"name\" AS \"TABLE_NAME\", \n         \"type\" AS \"TABLE_TYPE\", \n         \"other\" AS \"REMARKS\", \n         NULL AS \"TYPE_CAT\", \n         NULL AS \"TYPE_SCHEM\", \n         NULL AS \"TYPE_NAME\", \n         NULL AS \"SELF_REFERENCING_COL_NAME\", \n         NULL AS \"REF_GENERATION\" \n    FROM SYS_JDBC.ThisUserTableInfo \n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.Schemas AS   SELECT \"name\" AS \"TABLE_SCHEM\", \n         NULL AS \"TABLE_CATALOG\" \n    FROM SYS_JDBC.ThisUserSchemaInfo\n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.Catalogs AS   SELECT NULL AS \"TABLE_CAT\" \n    FROM SYS_INFO.sUSRSchemaInfo\n   WHERE FALSE\n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.Columns AS   SELECT NULL AS \"TABLE_CAT\",\n         \"schema\" AS \"TABLE_SCHEM\",\n         \"table\" AS \"TABLE_NAME\",\n         \"column\" AS \"COLUMN_NAME\",\n         \"sql_type\" AS \"DATA_TYPE\",\n         \"type_desc\" AS \"TYPE_NAME\",\n         IF(\"size\" = -1, 1024, \"size\") AS \"COLUMN_SIZE\",\n         NULL AS \"BUFFER_LENGTH\",\n         \"scale\" AS \"DECIMAL_DIGITS\",\n         IF(\"sql_type\" = -7, 2, 10) AS \"NUM_PREC_RADIX\",\n         IF(\"not_null\", 0, 1) AS \"NULLABLE\",\n         '' AS \"REMARKS\",\n         \"default\" AS \"COLUMN_DEF\",\n         NULL AS \"SQL_DATA_TYPE\",\n         NULL AS \"SQL_DATETIME_SUB\",\n         IF(\"size\" = -1, 1024, \"size\") AS \"CHAR_OCTET_LENGTH\",\n         \"seq_no\" + 1 AS \"ORDINAL_POSITION\",\n         IF(\"not_null\", 'NO', 'YES') AS \"IS_NULLABLE\"\n    FROM SYS_JDBC.ThisUserTableColumns\n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.ColumnPrivileges AS   SELECT \"TABLE_CAT\",\n         \"TABLE_SCHEM\",\n         \"TABLE_NAME\",\n         \"COLUMN_NAME\",\n         IF(\"ThisUserGrant.granter\" = '@SYSTEM', \n                        NULL, \"ThisUserGrant.granter\") AS \"GRANTOR\",\n         IF(\"ThisUserGrant.grantee\" = '@PUBLIC', \n                    'public', \"ThisUserGrant.grantee\") AS \"GRANTEE\",\n         \"ThisUserGrant.description\" AS \"PRIVILEGE\",\n         IF(\"grant_option\" = 'true', 'YES', 'NO') AS \"IS_GRANTABLE\" \n    FROM SYS_JDBC.Columns, SYS_JDBC.ThisUserGrant \n   WHERE CONCAT(Columns.TABLE_SCHEM, '.', Columns.TABLE_NAME) = \n         ThisUserGrant.param \n     AND SYS_JDBC.ThisUserGrant.object = 1 \n     AND SYS_JDBC.ThisUserGrant.description IS NOT NULL \n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.TablePrivileges AS   SELECT \"TABLE_CAT\",\n         \"TABLE_SCHEM\",\n         \"TABLE_NAME\",\n         IF(\"ThisUserGrant.granter\" = '@SYSTEM', \n                        NULL, \"ThisUserGrant.granter\") AS \"GRANTOR\",\n         IF(\"ThisUserGrant.grantee\" = '@PUBLIC', \n                    'public', \"ThisUserGrant.grantee\") AS \"GRANTEE\",\n         \"ThisUserGrant.description\" AS \"PRIVILEGE\",\n         IF(\"grant_option\" = 'true', 'YES', 'NO') AS \"IS_GRANTABLE\" \n    FROM SYS_JDBC.Tables, SYS_JDBC.ThisUserGrant \n   WHERE CONCAT(Tables.TABLE_SCHEM, '.', Tables.TABLE_NAME) = \n         ThisUserGrant.param \n     AND SYS_JDBC.ThisUserGrant.object = 1 \n     AND SYS_JDBC.ThisUserGrant.description IS NOT NULL \n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.PrimaryKeys AS   SELECT NULL \"TABLE_CAT\",\n         \"schema\" \"TABLE_SCHEM\",\n         \"table\" \"TABLE_NAME\",\n         \"column\" \"COLUMN_NAME\",\n         \"SYS_INFO.sUSRPrimaryColumns.seq_no\" \"KEY_SEQ\",\n         \"name\" \"PK_NAME\"\n    FROM SYS_INFO.sUSRPKeyInfo, SYS_INFO.sUSRPrimaryColumns\n   WHERE sUSRPKeyInfo.id = sUSRPrimaryColumns.pk_id\n     AND \"schema\" IN\n            ( SELECT \"name\" FROM SYS_JDBC.ThisUserSchemaInfo )\n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.ImportedKeys AS   SELECT NULL \"PKTABLE_CAT\",\n         \"sUSRFKeyInfo.ref_schema\" \"PKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.ref_table\" \"PKTABLE_NAME\",\n         \"sUSRForeignColumns.pcolumn\" \"PKCOLUMN_NAME\",\n         NULL \"FKTABLE_CAT\",\n         \"sUSRFKeyInfo.schema\" \"FKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.table\" \"FKTABLE_NAME\",\n         \"sUSRForeignColumns.fcolumn\" \"FKCOLUMN_NAME\",\n         \"sUSRForeignColumns.seq_no\" \"KEY_SEQ\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.update_rule\") \"UPDATE_RULE\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.delete_rule\") \"DELETE_RULE\",\n         \"sUSRFKeyInfo.name\" \"FK_NAME\",\n         NULL \"PK_NAME\",\n         \"sUSRFKeyInfo.deferred\" \"DEFERRABILITY\"\n    FROM SYS_INFO.sUSRFKeyInfo, SYS_INFO.sUSRForeignColumns\n   WHERE sUSRFKeyInfo.id = sUSRForeignColumns.fk_id\n     AND \"sUSRFKeyInfo.schema\" IN\n              ( SELECT \"name\" FROM SYS_JDBC.ThisUserSchemaInfo )\n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.ExportedKeys AS   SELECT NULL \"PKTABLE_CAT\",\n         \"sUSRFKeyInfo.ref_schema\" \"PKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.ref_table\" \"PKTABLE_NAME\",\n         \"sUSRForeignColumns.pcolumn\" \"PKCOLUMN_NAME\",\n         NULL \"FKTABLE_CAT\",\n         \"sUSRFKeyInfo.schema\" \"FKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.table\" \"FKTABLE_NAME\",\n         \"sUSRForeignColumns.fcolumn\" \"FKCOLUMN_NAME\",\n         \"sUSRForeignColumns.seq_no\" \"KEY_SEQ\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.update_rule\") \"UPDATE_RULE\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.delete_rule\") \"DELETE_RULE\",\n         \"sUSRFKeyInfo.name\" \"FK_NAME\",\n         NULL \"PK_NAME\",\n         \"sUSRFKeyInfo.deferred\" \"DEFERRABILITY\"\n    FROM SYS_INFO.sUSRFKeyInfo, SYS_INFO.sUSRForeignColumns\n   WHERE sUSRFKeyInfo.id = sUSRForeignColumns.fk_id\n     AND \"sUSRFKeyInfo.schema\" IN\n              ( SELECT \"name\" FROM SYS_JDBC.ThisUserSchemaInfo )\n");
            stmt.executeUpdate("  CREATE VIEW SYS_JDBC.CrossReference AS   SELECT NULL \"PKTABLE_CAT\",\n         \"sUSRFKeyInfo.ref_schema\" \"PKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.ref_table\" \"PKTABLE_NAME\",\n         \"sUSRForeignColumns.pcolumn\" \"PKCOLUMN_NAME\",\n         NULL \"FKTABLE_CAT\",\n         \"sUSRFKeyInfo.schema\" \"FKTABLE_SCHEM\",\n         \"sUSRFKeyInfo.table\" \"FKTABLE_NAME\",\n         \"sUSRForeignColumns.fcolumn\" \"FKCOLUMN_NAME\",\n         \"sUSRForeignColumns.seq_no\" \"KEY_SEQ\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.update_rule\") \"UPDATE_RULE\",\n         I_FRULE_CONVERT(\"sUSRFKeyInfo.delete_rule\") \"DELETE_RULE\",\n         \"sUSRFKeyInfo.name\" \"FK_NAME\",\n         NULL \"PK_NAME\",\n         \"sUSRFKeyInfo.deferred\" \"DEFERRABILITY\"\n    FROM SYS_INFO.sUSRFKeyInfo, SYS_INFO.sUSRForeignColumns\n   WHERE sUSRFKeyInfo.id = sUSRForeignColumns.fk_id\n     AND \"sUSRFKeyInfo.schema\" IN\n              ( SELECT \"name\" FROM SYS_JDBC.ThisUserSchemaInfo )\n");
        }
        catch (SQLException e) {
            if (e instanceof MSQLException) {
                MSQLException msqle = (MSQLException)e;
                this.Debug().write(40, this, msqle.getServerErrorStackTrace());
            }
            this.Debug().writeException(40, e);
            throw new RuntimeException("SQL Error: " + e.getMessage());
        }
    }

    private void createSystemTables(DatabaseConnection connection) throws DatabaseException {
        DataTableDef sUSRPassword = new DataTableDef();
        sUSRPassword.setTableName(SYS_PASSWORD);
        sUSRPassword.addColumn(DataTableColumnDef.createStringColumn("UserName"));
        sUSRPassword.addColumn(DataTableColumnDef.createStringColumn("Password"));
        DataTableDef sUSRUserPriv = new DataTableDef();
        sUSRUserPriv.setTableName(SYS_USERPRIV);
        sUSRUserPriv.addColumn(DataTableColumnDef.createStringColumn("UserName"));
        sUSRUserPriv.addColumn(DataTableColumnDef.createStringColumn("PrivGroupName"));
        DataTableDef sUSRUserConnectPriv = new DataTableDef();
        sUSRUserConnectPriv.setTableName(SYS_USERCONNECT);
        sUSRUserConnectPriv.addColumn(DataTableColumnDef.createStringColumn("UserName"));
        sUSRUserConnectPriv.addColumn(DataTableColumnDef.createStringColumn("Protocol"));
        sUSRUserConnectPriv.addColumn(DataTableColumnDef.createStringColumn("Host"));
        sUSRUserConnectPriv.addColumn(DataTableColumnDef.createStringColumn("Access"));
        DataTableDef sUSRGrant = new DataTableDef();
        sUSRGrant.setTableName(SYS_GRANTS);
        sUSRGrant.addColumn(DataTableColumnDef.createNumericColumn("priv_bit"));
        sUSRGrant.addColumn(DataTableColumnDef.createNumericColumn("object"));
        sUSRGrant.addColumn(DataTableColumnDef.createStringColumn("param"));
        sUSRGrant.addColumn(DataTableColumnDef.createStringColumn("grantee"));
        sUSRGrant.addColumn(DataTableColumnDef.createStringColumn("grant_option"));
        sUSRGrant.addColumn(DataTableColumnDef.createStringColumn("granter"));
        DataTableDef sUSRService = new DataTableDef();
        sUSRService.setTableName(SYS_SERVICE);
        sUSRService.addColumn(DataTableColumnDef.createStringColumn("name"));
        sUSRService.addColumn(DataTableColumnDef.createStringColumn("class"));
        sUSRService.addColumn(DataTableColumnDef.createStringColumn("type"));
        DataTableDef sUSRFunctionFactory = new DataTableDef();
        sUSRFunctionFactory.setTableName(SYS_FUNCTIONFACTORY);
        sUSRFunctionFactory.addColumn(DataTableColumnDef.createStringColumn("name"));
        sUSRFunctionFactory.addColumn(DataTableColumnDef.createStringColumn("class"));
        sUSRFunctionFactory.addColumn(DataTableColumnDef.createStringColumn("type"));
        DataTableDef sUSRFunction = new DataTableDef();
        sUSRFunction.setTableName(SYS_FUNCTION);
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("schema"));
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("name"));
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("type"));
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("location"));
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("return_type"));
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("args_type"));
        sUSRFunction.addColumn(DataTableColumnDef.createStringColumn("username"));
        DataTableDef sUSRView = new DataTableDef();
        sUSRView.setTableName(SYS_VIEW);
        sUSRView.addColumn(DataTableColumnDef.createStringColumn("schema"));
        sUSRView.addColumn(DataTableColumnDef.createStringColumn("name"));
        sUSRView.addColumn(DataTableColumnDef.createBinaryColumn("query"));
        sUSRView.addColumn(DataTableColumnDef.createBinaryColumn("data"));
        sUSRView.addColumn(DataTableColumnDef.createStringColumn("username"));
        DataTableDef sUSRLabel = new DataTableDef();
        sUSRLabel.setTableName(SYS_LABEL);
        sUSRLabel.addColumn(DataTableColumnDef.createNumericColumn("object_type"));
        sUSRLabel.addColumn(DataTableColumnDef.createStringColumn("object_name"));
        sUSRLabel.addColumn(DataTableColumnDef.createStringColumn("label"));
        DataTableDef sUSRDataTrigger = new DataTableDef();
        sUSRDataTrigger.setTableName(SYS_DATA_TRIGGER);
        sUSRDataTrigger.addColumn(DataTableColumnDef.createStringColumn("schema"));
        sUSRDataTrigger.addColumn(DataTableColumnDef.createStringColumn("name"));
        sUSRDataTrigger.addColumn(DataTableColumnDef.createNumericColumn("type"));
        sUSRDataTrigger.addColumn(DataTableColumnDef.createStringColumn("on_object"));
        sUSRDataTrigger.addColumn(DataTableColumnDef.createStringColumn("action"));
        sUSRDataTrigger.addColumn(DataTableColumnDef.createBinaryColumn("misc"));
        sUSRDataTrigger.addColumn(DataTableColumnDef.createStringColumn("username"));
        connection.alterCreateTable(sUSRPassword, 91, 128);
        connection.alterCreateTable(sUSRUserPriv, 91, 128);
        connection.alterCreateTable(sUSRUserConnectPriv, 91, 128);
        connection.alterCreateTable(sUSRGrant, 195, 128);
        connection.alterCreateTable(sUSRService, 91, 128);
        connection.alterCreateTable(sUSRFunctionFactory, 91, 128);
        connection.alterCreateTable(sUSRFunction, 91, 128);
        connection.alterCreateTable(sUSRView, 91, 128);
        connection.alterCreateTable(sUSRLabel, 91, 128);
        connection.alterCreateTable(sUSRDataTrigger, 91, 128);
    }

    public void setupSystemFunctions(DatabaseConnection connection, String admin_user) throws DatabaseException {
        String GRANTER = INTERNAL_SECURE_USERNAME;
        ProcedureManager manager = connection.getProcedureManager();
        Class c = class$com$mckoi$database$procedure$SystemBackup == null ? (class$com$mckoi$database$procedure$SystemBackup = Database.class$("com.mckoi.database.procedure.SystemBackup")) : class$com$mckoi$database$procedure$SystemBackup;
        manager.defineJavaProcedure(new ProcedureName(SYSTEM_SCHEMA, "SYSTEM_MAKE_BACKUP"), "com.mckoi.database.procedure.SystemBackup.invoke(ProcedureConnection, String)", TType.STRING_TYPE, new TType[]{TType.STRING_TYPE}, admin_user);
        GrantManager grants = connection.getGrantManager();
        grants.revokeAllGrantsOnObject(1, "SYS_INFO.SYSTEM_MAKE_BACKUP");
        grants.addGrant(Privileges.PROCEDURE_EXECUTE_PRIVS, 1, "SYS_INFO.SYSTEM_MAKE_BACKUP", admin_user, true, INTERNAL_SECURE_USERNAME);
    }

    private void clearAllGrants(DatabaseConnection connection) throws DatabaseException {
        DataTable grant_table = connection.getTable(SYS_GRANTS);
        grant_table.delete(grant_table);
    }

    private void setSystemGrants(DatabaseConnection connection, String grantee) throws DatabaseException {
        String GRANTER = INTERNAL_SECURE_USERNAME;
        GrantManager manager = connection.getGrantManager();
        manager.addGrant(Privileges.SCHEMA_ALL_PRIVS, 65, DEFAULT_SCHEMA, grantee, true, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.SCHEMA_READ_PRIVS, 65, SYSTEM_SCHEMA, "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.SCHEMA_READ_PRIVS, 65, JDBC_SCHEMA, "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrantToAllTablesInSchema(SYSTEM_SCHEMA, Privileges.TABLE_ALL_PRIVS, grantee, false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_INFO.sUSRConnectionInfo", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_INFO.sUSRCurrentConnections", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_INFO.sUSRDatabaseStatistics", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_INFO.sUSRDatabaseVars", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_INFO.sUSRProductInfo", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_INFO.sUSRSQLTypeInfo", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ThisUserGrant", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ThisUserSimpleGrant", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ThisUserSchemaInfo", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ThisUserTableColumns", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ThisUserTableInfo", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.Tables", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.Schemas", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.Catalogs", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.Columns", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ColumnPrivileges", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.TablePrivileges", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.PrimaryKeys", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ImportedKeys", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.ExportedKeys", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
        manager.addGrant(Privileges.TABLE_READ_PRIVS, 1, "SYS_JDBC.CrossReference", "@PUBLIC", false, INTERNAL_SECURE_USERNAME);
    }

    private void setSystemTableListeners() {
    }

    private void convertPreGrant(DatabaseConnection connection, String grantee) throws DatabaseException {
        String GRANTER = INTERNAL_SECURE_USERNAME;
        GrantManager manager = connection.getGrantManager();
        SchemaDef[] all_schema = connection.getSchemaList();
        for (int i = 0; i < all_schema.length; ++i) {
            SchemaDef schema = all_schema[i];
            if (!schema.getType().equals("USER") && !schema.getType().equals("DEFAULT")) continue;
            if (!schema.getType().equals("DEFAULT")) {
                manager.addGrant(Privileges.TABLE_ALL_PRIVS, 65, schema.getName(), grantee, true, GRANTER);
            }
            manager.addGrantToAllTablesInSchema(schema.getName(), Privileges.TABLE_ALL_PRIVS, grantee, true, GRANTER);
        }
    }

    private void convertPreSchema(DatabaseConnection connection) throws DatabaseException {
        throw new DatabaseException("Converting from pre-schema no longer supported.");
    }

    public void create(String username, String password) {
        if (this.isReadOnly()) {
            throw new RuntimeException("Can not create database in read only mode.");
        }
        if (username == null || username.length() == 0 || password == null || password.length() == 0) {
            throw new RuntimeException("Must have valid username and password String");
        }
        try {
            this.conglomerate.create(this.getName());
            DatabaseConnection connection = this.createNewConnection(null, null);
            DatabaseQueryContext context = new DatabaseQueryContext(connection);
            connection.getLockingMechanism().setMode(2);
            connection.setCurrentSchema(SYSTEM_SCHEMA);
            this.createSchemaInfoTables(connection);
            this.createSystemTables(connection);
            this.createSystemViews(connection);
            this.createUser(context, username, password);
            this.addUserToGroup(context, username, SECURE_GROUP);
            this.grantHostAccessToUser(context, username, "TCP", "%");
            this.grantHostAccessToUser(context, username, "Local", "%");
            this.setSystemGrants(connection, username);
            this.setupSystemFunctions(connection, username);
            try {
                connection.commit();
            }
            catch (TransactionException e) {
                this.Debug().writeException(e);
                throw new Error("Transaction Error: " + e.getMessage());
            }
            connection.getLockingMechanism().finishMode(2);
            connection.close();
            this.conglomerate.close();
        }
        catch (DatabaseException e) {
            this.Debug().writeException(e);
            throw new Error("Database Exception: " + e.getMessage());
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new Error("IO Error: " + e.getMessage());
        }
    }

    public void init() throws DatabaseException {
        if (this.initialised) {
            throw new RuntimeException("Init() method can only be called once.");
        }
        this.stats().resetSession();
        try {
            File log_path = this.system.getLogDirectory();
            this.commands_log = log_path != null && this.system.logQueries() ? new Log(new File(log_path.getPath(), "commands.log"), 262144, 5) : Log.nullLog();
            if (!this.storeSystem().storeExists(this.getName() + "_sf")) {
                if (this.system.getDatabasePath() != null && new File(this.system.getDatabasePath(), this.getName() + ".sf").exists()) {
                    throw new DatabaseException("The state store for this database doesn't exist.  This means the database version is pre version 1.0.  Please see the README for the details for converting this database.");
                }
                throw new DatabaseException("The database does not exist.");
            }
            this.conglomerate.open(this.getName());
            DatabaseConnection connection = this.createNewConnection(null, null);
            DatabaseQueryContext context = new DatabaseQueryContext(connection);
            connection.getLockingMechanism().setMode(2);
            if (!connection.tableExists(TableDataConglomerate.PERSISTENT_VAR_TABLE)) {
                throw new DatabaseException("The sUSRDatabaseVars table doesn't exist.  This means the database is pre-schema version 1 or the table has been deleted.If you are converting an old version of the database, please convert the database using an older release.");
            }
            DataTable database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
            Map vars = database_vars.toMap();
            String db_version = vars.get("database.version").toString();
            if (!db_version.equals("1.4")) {
                throw new DatabaseException("Incorrect data file version '" + db_version + "'.  Please see " + "the README on how to convert the data files to the current " + "version.");
            }
            connection.commit();
            connection.getLockingMechanism().finishMode(2);
            connection.close();
        }
        catch (TransactionException e) {
            throw new Error("Transaction Error: " + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new Error("IO Error: " + e.getMessage());
        }
        this.setSystemTableListeners();
        this.initialised = true;
    }

    public void shutdown() throws DatabaseException {
        if (!this.initialised) {
            throw new Error("The database is not initialized.");
        }
        try {
            if (this.delete_on_shutdown) {
                this.conglomerate.delete();
            } else {
                this.conglomerate.close();
            }
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new Error("IO Error: " + e.getMessage());
        }
        if (this.commands_log != null) {
            this.commands_log.close();
        }
        this.initialised = false;
    }

    public boolean exists() {
        if (this.initialised) {
            throw new RuntimeException("The database is initialised, so no point testing it's existance.");
        }
        try {
            if (this.conglomerate.exists(this.getName())) {
                return true;
            }
            boolean is_file_s_system = this.system.storeSystem() instanceof V1FileStoreSystem;
            return is_file_s_system && new File(this.system.getDatabasePath(), this.getName() + ".sf").exists();
        }
        catch (IOException e) {
            this.Debug().writeException(e);
            throw new RuntimeException("IO Error: " + e.getMessage());
        }
    }

    public final void setDeleteOnShutdown(boolean status) {
        this.delete_on_shutdown = status;
    }

    public boolean isInitialized() {
        return this.initialised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void liveCopyTo(File path) throws IOException {
        if (!this.initialised) {
            throw new Error("The database is not initialized.");
        }
        TransactionSystem copy_system = new TransactionSystem();
        DefaultDBConfig config = new DefaultDBConfig();
        config.setDatabasePath(path.getAbsolutePath());
        config.setLogPath("");
        config.setMinimumDebugLevel(50000);
        config.setValue("data_cache_size", "1048576");
        config.setValue("io_safety_level", "1");
        StringWriter debug_output = new StringWriter();
        copy_system.setDebugOutput(debug_output);
        copy_system.init(config);
        TableDataConglomerate dest_conglomerate = new TableDataConglomerate(copy_system, copy_system.storeSystem());
        dest_conglomerate.minimalCreate("DefaultDatabase");
        try {
            this.conglomerate.liveCopyTo(dest_conglomerate);
        }
        finally {
            dest_conglomerate.close();
            copy_system.dispose();
        }
    }

    private void convertAllUserTables(DatabaseConnection connection, PrintStream out) throws TransactionException {
        out.println("Converting user table format to latest version.");
        TableName[] all_tables = connection.getTableList();
        for (int i = 0; i < all_tables.length; ++i) {
            TableName table_name = all_tables[i];
            String schema_name = table_name.getSchema();
            if (schema_name.equals(SYSTEM_SCHEMA) || !connection.getTableType(table_name).equals("TABLE")) continue;
            out.println("Converting: " + table_name);
            connection.compactTable(table_name);
            connection.commit();
        }
    }

    private static boolean largeObjectTest(int sql_type) {
        return sql_type == 1 || sql_type == 12 || sql_type == -1 || sql_type == -2 || sql_type == -3 || sql_type == -4 || sql_type == 2004 || sql_type == 2005;
    }

    private void moveLargeObjectsToBlobStore(DatabaseConnection connection, PrintStream out) throws TransactionException, IOException, DatabaseException {
        out.println("Scanning user tables for large objects.");
        DatabaseQueryContext context = new DatabaseQueryContext(connection);
        BlobStore blob_store = this.conglomerate.getBlobStore();
        TableName[] all_tables = connection.getTableList();
        for (int i = 0; i < all_tables.length; ++i) {
            TableName table_name = all_tables[i];
            String schema_name = table_name.getSchema();
            boolean table_changed = false;
            if (schema_name.equals(SYSTEM_SCHEMA) || !connection.getTableType(table_name).equals("TABLE")) continue;
            out.println("Processing: " + table_name);
            DataTable table = connection.getTable(table_name);
            DataTableDef table_def = table.getDataTableDef();
            boolean possibly_has_large_objects = false;
            int column_count = table_def.columnCount();
            for (int n = 0; n < column_count; ++n) {
                int sql_type = table_def.columnAt(n).getSQLType();
                if (!Database.largeObjectTest(sql_type)) continue;
                possibly_has_large_objects = true;
            }
            if (!possibly_has_large_objects) continue;
            RowEnumeration e = table.rowEnumeration();
            while (e.hasMoreRows()) {
                int row_index = e.nextRowIndex();
                ArrayList<Assignment> changes = new ArrayList<Assignment>(4);
                for (int p = 0; p < column_count; ++p) {
                    ByteLongObject b_object;
                    Ref ref;
                    StringObject s_object;
                    TObject tob;
                    Object ob;
                    DataTableColumnDef col_def = table_def.columnAt(p);
                    int sql_type = col_def.getSQLType();
                    if (!Database.largeObjectTest(sql_type) || (ob = (tob = table.getCellContents(p, row_index)).getObject()) == null) continue;
                    if (ob instanceof StringObject && (s_object = (StringObject)ob).length() > 4096) {
                        ref = blob_store.putStringInBlobStore(s_object.toString());
                        changes.add(new Assignment(new Variable(table_name, col_def.getName()), new Expression(new TObject(tob.getTType(), ref))));
                    }
                    if (!(ob instanceof ByteLongObject) || (b_object = (ByteLongObject)ob).length() <= 8192) continue;
                    ref = blob_store.putByteLongObjectInBlobStore(b_object);
                    changes.add(new Assignment(new Variable(table_name, col_def.getName()), new Expression(new TObject(tob.getTType(), ref))));
                }
                if (changes.size() <= 0) continue;
                Assignment[] assignments = changes.toArray(new Assignment[changes.size()]);
                Table st = table.singleRowSelect(row_index);
                table.update(context, st, assignments, -1);
                table_changed = true;
            }
            if (table_changed) {
                connection.commit();
                connection.compactTable(table_name);
            }
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean convertToCurrent(PrintStream out, String admin_username) throws IOException {
        this.stats().resetSession();
        try {
            this.commands_log = Log.nullLog();
            File legacy_state_file = new File(this.system.getDatabasePath(), this.getName() + ".sf");
            if (legacy_state_file.exists()) {
                String state_store_fn = this.getName() + "_sf";
                if (this.storeSystem().storeExists(state_store_fn)) {
                    throw new IOException("Both legacy and version 1 state file exist.  Please remove one.");
                }
                out.println("Converting state file to current version.");
                Store new_ss = this.storeSystem().createStore(state_store_fn);
                StateStore ss = new StateStore(new_ss);
                long new_p = ss.convert(legacy_state_file, this.Debug());
                MutableArea fixed_area = new_ss.getMutableArea(-1L);
                fixed_area.putLong(new_p);
                fixed_area.checkOut();
                this.storeSystem().closeStore(new_ss);
                legacy_state_file.delete();
                out.println("State store written.");
            }
            out.println("Opening conglomerate.");
            this.conglomerate.open(this.getName());
            DatabaseConnection connection = this.createNewConnection(null, null);
            DatabaseQueryContext context = new DatabaseQueryContext(connection);
            connection.getLockingMechanism().setMode(2);
            if (!connection.tableExists(TableDataConglomerate.PERSISTENT_VAR_TABLE)) {
                out.println("The sUSRDatabaseVars table doesn't exist.  This means the database is pre-schema version 1 or the table has been deleted.If you are converting an old version of the database, please convert the database using an older release.");
                boolean ss = false;
                return ss;
            }
            if (!this.userExists(context, admin_username)) {
                out.println("The admin username given (" + admin_username + ") does not exist in this database so I am unable to convert the " + "database.");
                boolean ss = false;
                return ss;
            }
            DataTable database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
            Map vars = database_vars.toMap();
            String db_version = vars.get("database.version").toString();
            if (db_version.equals("1.0")) {
                out.println("Version 1.0 found.");
                out.println("Converting database to version 1.4 schema...");
                try {
                    connection.dropTable(new TableName(SYSTEM_SCHEMA, "sUSRPrivAdd"));
                    connection.dropTable(new TableName(SYSTEM_SCHEMA, "sUSRPrivAlter"));
                    connection.dropTable(new TableName(SYSTEM_SCHEMA, "sUSRPrivRead"));
                }
                catch (Error e) {
                    // empty catch block
                }
                this.conglomerate.resetAllSystemTableID();
                this.conglomerate.updateSystemTableSchema();
                connection.commit();
                this.createSystemTables(connection);
                connection.commit();
                connection.createSchema(JDBC_SCHEMA, "SYSTEM");
                this.createSystemViews(connection);
                this.setSystemGrants(connection, admin_username);
                this.convertPreGrant(connection, admin_username);
                this.grantHostAccessToUser(context, admin_username, "TCP", "%");
                this.grantHostAccessToUser(context, admin_username, "Local", "%");
                this.convertAllUserTables(connection, out);
                this.moveLargeObjectsToBlobStore(connection, out);
                this.setupSystemFunctions(connection, admin_username);
                connection.commit();
                database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
                Database.updateDatabaseVars(context, database_vars, "database.version", "1.4");
                db_version = "1.4";
            } else if (db_version.equals("1.1")) {
                out.println("Version 1.1 found.");
                out.println("Converting database to version 1.4 schema...");
                this.conglomerate.resetAllSystemTableID();
                this.conglomerate.updateSystemTableSchema();
                connection.commit();
                this.createSystemTables(connection);
                connection.commit();
                database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
                connection.createSchema(JDBC_SCHEMA, "SYSTEM");
                this.createSystemViews(connection);
                this.clearAllGrants(connection);
                this.setSystemGrants(connection, admin_username);
                this.convertPreGrant(connection, admin_username);
                this.convertAllUserTables(connection, out);
                this.moveLargeObjectsToBlobStore(connection, out);
                this.setupSystemFunctions(connection, admin_username);
                connection.commit();
                database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
                Database.updateDatabaseVars(context, database_vars, "database.version", "1.4");
                db_version = "1.4";
            } else if (db_version.equals("1.2")) {
                out.println("Version 1.2 found.");
                out.println("Converting database to version 1.4 schema...");
                this.conglomerate.updateSystemTableSchema();
                connection.commit();
                this.createSystemTables(connection);
                connection.commit();
                this.convertAllUserTables(connection, out);
                this.moveLargeObjectsToBlobStore(connection, out);
                connection.commit();
                this.setupSystemFunctions(connection, admin_username);
                connection.commit();
                database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
                Database.updateDatabaseVars(context, database_vars, "database.version", "1.4");
                db_version = "1.4";
            } else if (db_version.equals("1.3")) {
                out.println("Version 1.3 found.");
                out.println("Converting database to version 1.4 schema...");
                this.conglomerate.updateSystemTableSchema();
                connection.commit();
                this.createSystemTables(connection);
                connection.commit();
                try {
                    connection.dropTable(new TableName(SYSTEM_SCHEMA, "sUSRSystemTrigger"));
                }
                catch (Error e) {
                    // empty catch block
                }
                this.setupSystemFunctions(connection, admin_username);
                connection.commit();
                database_vars = connection.getTable(TableDataConglomerate.PERSISTENT_VAR_TABLE);
                Database.updateDatabaseVars(context, database_vars, "database.version", "1.4");
                db_version = "1.4";
            } else if (db_version.equals("1.4")) {
                out.println("Version 1.4 found.");
                out.println("Version of data files is current.");
            } else if (!db_version.equals("1.4")) {
                out.println("Version " + db_version + " found.");
                out.println("This is not a recognized version number and can not be converted.  Perhaps this is a future version?  I can not convert backwards from a future version.");
                boolean bl = false;
                return bl;
            }
            connection.commit();
            connection.getLockingMechanism().finishMode(2);
            connection.close();
            boolean bl = true;
            return bl;
        }
        catch (TransactionException e) {
            out.println("Transaction Error: " + e.getMessage());
            e.printStackTrace(out);
            boolean bl = false;
            return bl;
        }
        catch (DatabaseException e) {
            out.println("Database Error: " + e.getMessage());
            e.printStackTrace(out);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                this.conglomerate.close();
            }
            catch (Throwable e) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    public DatabaseProcedure getDBProcedure(String procedure_name, DatabaseConnection connection) throws DatabaseException {
        void var3_5;
        DatabaseProcedure procedure_instance;
        String p = "/" + procedure_name.replace('.', '/');
        if (!p.startsWith("/com/mckoi/procedure/")) {
            p = "/com/mckoi/procedure/" + p;
        }
        p = p + ".js";
        URL url = this.getClass().getResource(p);
        if (url != null) {
            procedure_instance = null;
        } else {
            try {
                Class<?> proc = Class.forName("com.mckoi.procedure." + procedure_name);
                procedure_instance = (DatabaseProcedure)proc.newInstance();
                this.Debug().write(10, this, "Getting raw Java class file: " + procedure_name);
            }
            catch (IllegalAccessException e) {
                this.Debug().writeException(e);
                throw new DatabaseException("Illegal Access: " + e.getMessage());
            }
            catch (InstantiationException e) {
                this.Debug().writeException(e);
                throw new DatabaseException("Instantiation Error: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                this.Debug().writeException(e);
                throw new DatabaseException("Class Not Found: " + e.getMessage());
            }
        }
        return var3_5;
    }

    public final DatabaseSystem getSystem() {
        return this.system;
    }

    public final StoreSystem storeSystem() {
        return this.system.storeSystem();
    }

    public final Stats stats() {
        return this.getSystem().stats();
    }

    public final DebugLogger Debug() {
        return this.getSystem().Debug();
    }

    public final TriggerManager getTriggerManager() {
        return this.trigger_manager;
    }

    public final UserManager getUserManager() {
        return this.getSystem().getUserManager();
    }

    public final Object createEvent(Runnable runner) {
        return this.getSystem().createEvent(runner);
    }

    public final void postEvent(int time, Object event) {
        this.getSystem().postEvent(time, event);
    }

    public final DataCellCache getDataCellCache() {
        return this.getSystem().getDataCellCache();
    }

    public final boolean hasShutDown() {
        return this.getSystem().hasShutDown();
    }

    public final void startShutDownThread() {
        this.getSystem().startShutDownThread();
    }

    public final void waitUntilShutdown() {
        this.getSystem().waitUntilShutdown();
    }

    public final void execute(User user, DatabaseConnection database, Runnable runner) {
        this.getSystem().execute(user, database, runner);
    }

    public final void registerShutDownDelegate(Runnable delegate) {
        this.getSystem().registerShutDownDelegate(delegate);
    }

    public final void setIsExecutingCommands(boolean status) {
        this.getSystem().setIsExecutingCommands(status);
    }

    public final Table getSingleRowTable() {
        return this.SINGLE_ROW_TABLE;
    }

    private static void updateDatabaseVars(QueryContext context, DataTable database_vars, String key, String value) throws DatabaseException {
        Variable c1 = database_vars.getResolvedVariable(0);
        Variable c2 = database_vars.getResolvedVariable(1);
        Assignment assignment = new Assignment(c2, new Expression(TObject.stringVal(value)));
        Table t1 = database_vars.simpleSelect(context, c1, Operator.get("="), new Expression(TObject.stringVal(key)));
        database_vars.update(context, t1, new Assignment[]{assignment}, -1);
    }

    public void finalize() throws Throwable {
        super.finalize();
        if (this.isInitialized()) {
            System.err.println("Database object was finalized and is initialized!");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

