/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.Expression;
import com.mckoi.database.TBinaryType;
import com.mckoi.database.TBooleanType;
import com.mckoi.database.TDateType;
import com.mckoi.database.TJavaObjectType;
import com.mckoi.database.TNullType;
import com.mckoi.database.TNumericType;
import com.mckoi.database.TStringType;
import com.mckoi.database.TType;
import com.mckoi.database.TransactionSystem;
import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.TypeUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Array;

public class DataTableColumnDef {
    private byte[] constraints_format = new byte[16];
    private String name;
    private int sql_type;
    private int db_type;
    private int size;
    private int scale;
    private String locale_str = "";
    private int str_strength;
    private int str_decomposition;
    private String default_expression_string;
    private String foreign_key = "";
    private String index_desc = "";
    private String class_constraint = "";
    private Class constraining_class;
    public TType type;

    public DataTableColumnDef() {
    }

    public DataTableColumnDef(DataTableColumnDef column_def) {
        System.arraycopy(column_def.constraints_format, 0, this.constraints_format, 0, this.constraints_format.length);
        this.name = column_def.name;
        this.sql_type = column_def.sql_type;
        this.db_type = column_def.db_type;
        this.size = column_def.size;
        this.scale = column_def.scale;
        this.locale_str = column_def.locale_str;
        this.str_strength = column_def.str_strength;
        this.str_decomposition = column_def.str_decomposition;
        if (column_def.default_expression_string != null) {
            this.default_expression_string = column_def.default_expression_string;
        }
        this.foreign_key = column_def.foreign_key;
        this.index_desc = column_def.index_desc;
        this.class_constraint = column_def.class_constraint;
        this.type = column_def.type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNotNull(boolean status) {
        this.constraints_format[0] = (byte)(status ? 1 : 0);
    }

    public void setSQLType(int sql_type) {
        this.sql_type = sql_type;
        this.db_type = sql_type == -7 || sql_type == 16 ? 5 : (sql_type == -6 || sql_type == 5 || sql_type == 4 || sql_type == -5 || sql_type == 6 || sql_type == 7 || sql_type == 8 || sql_type == 2 || sql_type == 3 ? 2 : (sql_type == 1 || sql_type == 12 || sql_type == -1 ? 1 : (sql_type == 91 || sql_type == 92 || sql_type == 93 ? 3 : (sql_type == -2 || sql_type == -3 || sql_type == -4 ? 6 : (sql_type == 2000 ? 7 : -1)))));
    }

    public void setDBType(int db_type) {
        this.db_type = db_type;
        if (db_type == 2) {
            this.sql_type = 2;
        } else if (db_type == 1) {
            this.sql_type = -1;
        } else if (db_type == 5) {
            this.sql_type = -7;
        } else if (db_type == 3) {
            this.sql_type = 93;
        } else if (db_type == 6) {
            this.sql_type = -4;
        } else if (db_type == 7) {
            this.sql_type = 2000;
        } else {
            throw new Error("Unrecognised internal type.");
        }
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setStringLocale(String locale_str, int strength, int decomposition) {
        if (locale_str == null) {
            this.locale_str = "";
        } else {
            this.locale_str = locale_str;
            this.str_strength = strength;
            this.str_decomposition = decomposition;
        }
    }

    public void setDefaultExpression(Expression expression) {
        this.default_expression_string = new String(expression.text().toString());
    }

    public void setForeignKey(String foreign_key) {
        this.foreign_key = foreign_key;
    }

    public void setIndexScheme(String index_scheme) {
        this.index_desc = index_scheme;
    }

    public void setClassConstraint(String class_constraint) {
        this.class_constraint = class_constraint;
        try {
            if (class_constraint.endsWith("[]")) {
                String array_class = class_constraint.substring(0, class_constraint.length() - 2);
                Class<Serializable> ac = array_class.equals("boolean") ? Boolean.TYPE : (array_class.equals("byte") ? Byte.TYPE : (array_class.equals("char") ? Character.TYPE : (array_class.equals("short") ? Short.TYPE : (array_class.equals("int") ? Integer.TYPE : (array_class.equals("long") ? Long.TYPE : (array_class.equals("float") ? Float.TYPE : (array_class.equals("double") ? Double.TYPE : Class.forName(array_class))))))));
                this.constraining_class = Array.newInstance(ac, 0).getClass();
            } else {
                this.constraining_class = Class.forName(class_constraint);
            }
        }
        catch (ClassNotFoundException e) {
            throw new Error("Unable to resolve class: " + class_constraint);
        }
    }

    public void setFromTType(TType type) {
        this.setSQLType(type.getSQLType());
        if (type instanceof TStringType) {
            TStringType str_type = (TStringType)type;
            this.setSize(str_type.getMaximumSize());
            this.setStringLocale(str_type.getLocaleString(), str_type.getStrength(), str_type.getDecomposition());
        } else if (type instanceof TNumericType) {
            TNumericType num_type = (TNumericType)type;
            this.setSize(num_type.getSize());
            this.setScale(num_type.getScale());
        } else if (!(type instanceof TBooleanType || type instanceof TDateType || type instanceof TNullType)) {
            if (type instanceof TBinaryType) {
                TBinaryType binary_type = (TBinaryType)type;
                this.setSize(binary_type.getMaximumSize());
            } else if (type instanceof TJavaObjectType) {
                TJavaObjectType java_object_type = (TJavaObjectType)type;
                this.setClassConstraint(java_object_type.getJavaClassTypeString());
            } else {
                throw new Error("Don't know how to handle this type: " + type.getClass());
            }
        }
        this.type = type;
    }

    public void initTTypeInfo() {
        if (this.type == null) {
            this.type = DataTableColumnDef.createTTypeFor(this.getSQLType(), this.getSize(), this.getScale(), this.getLocaleString(), this.getStrength(), this.getDecomposition(), this.getClassConstraint());
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isNotNull() {
        return this.constraints_format[0] != 0;
    }

    public int getSQLType() {
        return this.sql_type;
    }

    public String getSQLTypeString() {
        return DataTableColumnDef.sqlTypeToString(this.getSQLType());
    }

    public String getDBTypeString() {
        switch (this.getDBType()) {
            case 2: {
                return "DB_NUMERIC";
            }
            case 1: {
                return "DB_STRING";
            }
            case 5: {
                return "DB_BOOLEAN";
            }
            case 3: {
                return "DB_TIME";
            }
            case 6: {
                return "DB_BLOB";
            }
            case 7: {
                return "DB_OBJECT";
            }
        }
        return "UNKNOWN(" + this.getDBType() + ")";
    }

    public Class classType() {
        return TypeUtil.toClass(this.getDBType());
    }

    public int getDBType() {
        return this.db_type;
    }

    public int getSize() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public String getLocaleString() {
        return this.locale_str;
    }

    public int getStrength() {
        return this.str_strength;
    }

    public int getDecomposition() {
        return this.str_decomposition;
    }

    public Expression getDefaultExpression(TransactionSystem system) {
        if (this.default_expression_string == null) {
            return null;
        }
        Expression exp = Expression.parse(this.default_expression_string);
        return exp;
    }

    public String getDefaultExpressionString() {
        return this.default_expression_string;
    }

    public String getForeignKey() {
        return this.foreign_key;
    }

    public String getIndexScheme() {
        if (this.index_desc.equals("")) {
            return "InsertSearch";
        }
        return this.index_desc;
    }

    public boolean isIndexableType() {
        return this.getDBType() != 6 && this.getDBType() != 7;
    }

    public String getClassConstraint() {
        return this.class_constraint;
    }

    public Class getClassConstraintAsClass() {
        return this.constraining_class;
    }

    public TType getTType() {
        if (this.type == null) {
            throw new Error("'type' variable was not set.");
        }
        return this.type;
    }

    public ColumnDescription columnDescriptionValue(String column_name) {
        ColumnDescription field = new ColumnDescription(column_name, this.getDBType(), this.getSize(), this.isNotNull());
        field.setScale(this.getScale());
        field.setSQLType(this.getSQLType());
        return field;
    }

    public void dump(PrintStream out) {
        out.print(this.getName());
        out.print("(");
        out.print(this.getSQLTypeString());
        out.print(")");
    }

    boolean compatIsUnique() {
        return this.constraints_format[1] != 0;
    }

    boolean compatIsPrimaryKey() {
        return this.constraints_format[2] != 0;
    }

    public static String sqlTypeToString(int sql_type) {
        switch (sql_type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 0: {
                return "NULL";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        return "UNKNOWN(" + sql_type + ")";
    }

    static TType createTTypeFor(int sql_type, int size, int scale, String locale, int str_strength, int str_decomposition, String java_class) {
        switch (sql_type) {
            case -7: 
            case 16: {
                return TType.BOOLEAN_TYPE;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new TNumericType(sql_type, size, scale);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return new TStringType(sql_type, size, locale, str_strength, str_decomposition);
            }
            case 91: 
            case 92: 
            case 93: {
                return new TDateType(sql_type);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new TBinaryType(sql_type, size);
            }
            case 2000: {
                return new TJavaObjectType(java_class);
            }
            case 2003: {
                return TType.ARRAY_TYPE;
            }
            case 0: {
                return TType.NULL_TYPE;
            }
        }
        throw new Error("SQL type not recognized.");
    }

    public static DataTableColumnDef createNumericColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setSQLType(2);
        column.initTTypeInfo();
        return column;
    }

    public static DataTableColumnDef createBooleanColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setSQLType(-7);
        column.initTTypeInfo();
        return column;
    }

    public static DataTableColumnDef createStringColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setSQLType(12);
        column.setSize(Integer.MAX_VALUE);
        column.initTTypeInfo();
        return column;
    }

    public static DataTableColumnDef createBinaryColumn(String name) {
        DataTableColumnDef column = new DataTableColumnDef();
        column.setName(name);
        column.setSQLType(-4);
        column.setSize(Integer.MAX_VALUE);
        column.setIndexScheme("BlindSearch");
        column.initTTypeInfo();
        return column;
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(2);
        out.writeUTF(this.name);
        out.writeInt(this.constraints_format.length);
        out.write(this.constraints_format);
        out.writeInt(this.sql_type);
        out.writeInt(this.db_type);
        out.writeInt(this.size);
        out.writeInt(this.scale);
        if (this.default_expression_string != null) {
            out.writeBoolean(true);
            out.writeUTF(this.default_expression_string);
        } else {
            out.writeBoolean(false);
        }
        out.writeUTF(this.foreign_key);
        out.writeUTF(this.index_desc);
        out.writeUTF(this.class_constraint);
        StringBuffer other = new StringBuffer();
        other.append("|");
        other.append(this.locale_str);
        other.append("|");
        other.append(this.str_strength);
        other.append("|");
        other.append(this.str_decomposition);
        other.append("|");
        out.writeUTF(new String(other));
    }

    static DataTableColumnDef read(DataInput in) throws IOException {
        int ver = in.readInt();
        DataTableColumnDef cd = new DataTableColumnDef();
        cd.name = in.readUTF();
        int len = in.readInt();
        in.readFully(cd.constraints_format, 0, len);
        cd.sql_type = in.readInt();
        cd.db_type = in.readInt();
        cd.size = in.readInt();
        cd.scale = in.readInt();
        boolean b = in.readBoolean();
        if (b) {
            cd.default_expression_string = in.readUTF();
        }
        cd.foreign_key = in.readUTF();
        cd.index_desc = in.readUTF();
        if (ver > 1) {
            String cc = in.readUTF();
            if (!cc.equals("")) {
                cd.setClassConstraint(cc);
            }
        } else {
            cd.class_constraint = "";
        }
        String other = in.readUTF();
        if (other.length() > 0) {
            if (other.startsWith("|")) {
                int cur_i = 1;
                int next_break = other.indexOf("|", cur_i);
                cd.locale_str = other.substring(cur_i, next_break);
                cur_i = next_break + 1;
                next_break = other.indexOf("|", cur_i);
                cd.str_strength = Integer.parseInt(other.substring(cur_i, next_break));
                cur_i = next_break + 1;
                next_break = other.indexOf("|", cur_i);
                cd.str_decomposition = Integer.parseInt(other.substring(cur_i, next_break));
            } else {
                throw new Error("Incorrectly formatted DataTableColumnDef data.");
            }
        }
        cd.initTTypeInfo();
        return cd;
    }
}

