/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DataIndexDef {
    private String index_name;
    private String[] column_names;
    private int index_pointer;
    private String index_type;
    private boolean unique;

    public DataIndexDef(String index_name, String[] column_names, int index_pointer, String index_type, boolean unique) {
        this.index_name = index_name;
        this.column_names = (String[])column_names.clone();
        this.index_pointer = index_pointer;
        this.index_type = index_type;
        this.unique = unique;
    }

    public DataIndexDef(DataIndexDef def) {
        this(def.index_name, def.column_names, def.index_pointer, def.index_type, def.unique);
    }

    public String getName() {
        return this.index_name;
    }

    public String[] getColumnNames() {
        return this.column_names;
    }

    public int getPointer() {
        return this.index_pointer;
    }

    public String getType() {
        return this.index_type;
    }

    public boolean isUniqueIndex() {
        return this.unique;
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeInt(1);
        dout.writeUTF(this.index_name);
        dout.writeInt(this.column_names.length);
        for (int i = 0; i < this.column_names.length; ++i) {
            dout.writeUTF(this.column_names[i]);
        }
        dout.writeInt(this.index_pointer);
        dout.writeUTF(this.index_type);
        dout.writeBoolean(this.unique);
    }

    public static DataIndexDef read(DataInput din) throws IOException {
        int version = din.readInt();
        if (version != 1) {
            throw new IOException("Don't understand version.");
        }
        String index_name = din.readUTF();
        int sz = din.readInt();
        String[] cols = new String[sz];
        for (int i = 0; i < sz; ++i) {
            cols[i] = din.readUTF();
        }
        int index_pointer = din.readInt();
        String index_type = din.readUTF();
        boolean unique = din.readBoolean();
        return new DataIndexDef(index_name, cols, index_pointer, index_type, unique);
    }
}

