/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.AbstractInternalTableInfo2;
import com.mckoi.database.DataTable;
import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.DataTableDef;
import com.mckoi.database.Database;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.DatabaseQueryContext;
import com.mckoi.database.Expression;
import com.mckoi.database.GTDataSource;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.MutableTableDataSource;
import com.mckoi.database.Operator;
import com.mckoi.database.ProcedureName;
import com.mckoi.database.QueryContext;
import com.mckoi.database.RowData;
import com.mckoi.database.RowEnumeration;
import com.mckoi.database.StatementException;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TableBackedCache;
import com.mckoi.database.TableModificationEvent;
import com.mckoi.database.TableName;
import com.mckoi.database.Transaction;
import com.mckoi.database.Variable;
import com.mckoi.util.IntegerVector;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public final class ConnectionTriggerManager {
    private DatabaseConnection connection;
    private ArrayList triggers_active;
    private boolean list_validated;
    private boolean trigger_modified;

    ConnectionTriggerManager(DatabaseConnection connection) {
        this.connection = connection;
        this.triggers_active = new ArrayList();
        this.list_validated = false;
        this.trigger_modified = false;
        connection.attachTableBackedCache(new CTMBackedCache());
    }

    private Table findTrigger(QueryContext context, DataTable table, String schema, String name) {
        Operator EQUALS = Operator.get("=");
        Variable schemav = table.getResolvedVariable(0);
        Variable namev = table.getResolvedVariable(1);
        Table t = table.simpleSelect(context, namev, EQUALS, new Expression(TObject.stringVal(name)));
        return t.exhaustiveSelect(context, Expression.simple(schemav, EQUALS, TObject.stringVal(schema)));
    }

    public void createTableTrigger(String schema, String name, int type, TableName on_table, String procedure_name, TObject[] params) throws DatabaseException {
        ByteArrayOutputStream bout;
        TableName trigger_table_name = new TableName(schema, name);
        DatabaseConnection.checkAllowCreate(trigger_table_name);
        if (!this.connection.tableExists(trigger_table_name)) {
            bout = new ByteArrayOutputStream();
            try {
                ObjectOutputStream ob_out = new ObjectOutputStream(bout);
                ob_out.writeInt(1);
                ob_out.writeObject(params);
                ob_out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException("IO Error: " + e.getMessage());
            }
        } else {
            throw new RuntimeException("Trigger name '" + schema + "." + name + "' already in use.");
        }
        byte[] encoded_params = bout.toByteArray();
        DataTable table = this.connection.getTable(Database.SYS_DATA_TRIGGER);
        RowData row = new RowData(table);
        row.setColumnDataFromTObject(0, TObject.stringVal(schema));
        row.setColumnDataFromTObject(1, TObject.stringVal(name));
        row.setColumnDataFromTObject(2, TObject.intVal(type));
        row.setColumnDataFromTObject(3, TObject.stringVal("T:" + on_table.toString()));
        row.setColumnDataFromTObject(4, TObject.stringVal(procedure_name));
        row.setColumnDataFromTObject(5, TObject.objectVal(encoded_params));
        row.setColumnDataFromTObject(6, TObject.stringVal(this.connection.getUser().getUserName()));
        table.add(row);
        this.invalidateTriggerList();
        this.connection.databaseObjectCreated(trigger_table_name);
        this.trigger_modified = true;
    }

    public void dropTrigger(String schema, String name) throws DatabaseException {
        DatabaseQueryContext context = new DatabaseQueryContext(this.connection);
        DataTable table = this.connection.getTable(Database.SYS_DATA_TRIGGER);
        Table t = this.findTrigger(context, table, schema, name);
        if (t.getRowCount() == 0) {
            throw new StatementException("Trigger '" + schema + "." + name + "' not found.");
        }
        if (t.getRowCount() > 1) {
            throw new RuntimeException("Assertion failed: multiple entries for the same trigger name.");
        }
        table.delete(t);
        this.connection.databaseObjectDropped(new TableName(schema, name));
        this.trigger_modified = true;
    }

    public boolean triggerExists(String schema, String name) {
        DatabaseQueryContext context = new DatabaseQueryContext(this.connection);
        DataTable table = this.connection.getTable(Database.SYS_DATA_TRIGGER);
        Table t = this.findTrigger(context, table, schema, name);
        if (t.getRowCount() == 0) {
            return false;
        }
        if (t.getRowCount() > 1) {
            throw new RuntimeException("Assertion failed: multiple entries for the same trigger name.");
        }
        return true;
    }

    private void invalidateTriggerList() {
        this.list_validated = false;
        this.triggers_active.clear();
    }

    private void buildTriggerList() {
        if (!this.list_validated) {
            DataTable table = this.connection.getTable(Database.SYS_DATA_TRIGGER);
            RowEnumeration e = table.rowEnumeration();
            while (e.hasMoreRows()) {
                int row_index = e.nextRowIndex();
                TObject trig_schem = table.getCellContents(0, row_index);
                TObject trig_name = table.getCellContents(1, row_index);
                TObject type = table.getCellContents(2, row_index);
                TObject on_object = table.getCellContents(3, row_index);
                TObject action = table.getCellContents(4, row_index);
                TObject misc = table.getCellContents(5, row_index);
                TriggerInfo trigger_info = new TriggerInfo();
                trigger_info.schema = trig_schem.getObject().toString();
                trigger_info.name = trig_name.getObject().toString();
                trigger_info.type = type.toBigNumber().intValue();
                trigger_info.on_object = on_object.getObject().toString();
                trigger_info.action = action.getObject().toString();
                trigger_info.misc = misc;
                this.triggers_active.add(trigger_info);
            }
            this.list_validated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performTriggerAction(TableModificationEvent evt) {
        if (this.connection.tableExists(Database.SYS_DATA_TRIGGER)) {
            this.buildTriggerList();
            TableName table_name = evt.getTableName();
            String on_ob_test = "T:" + table_name.toString();
            int sz = this.triggers_active.size();
            for (int i = 0; i < sz; ++i) {
                TriggerInfo t_info = (TriggerInfo)this.triggers_active.get(i);
                if (!t_info.on_object.equals(on_ob_test) || !evt.listenedBy(t_info.type)) continue;
                String action = t_info.action;
                ProcedureName procedure_name = ProcedureName.qualify(table_name.getSchema(), action);
                DatabaseConnection.OldNewTableState current_state = this.connection.getOldNewTableState();
                this.connection.setOldNewTableState(new DatabaseConnection.OldNewTableState(table_name, evt.getRowIndex(), evt.getRowData(), evt.isBefore()));
                try {
                    this.connection.getProcedureManager().invokeProcedure(procedure_name, new TObject[0]);
                    continue;
                }
                finally {
                    this.connection.setOldNewTableState(current_state);
                }
            }
        }
    }

    static InternalTableInfo createInternalTableInfo(Transaction transaction) {
        return new TriggerInternalTableInfo(transaction);
    }

    private static class TriggerInternalTableInfo
    extends AbstractInternalTableInfo2 {
        TriggerInternalTableInfo(Transaction transaction) {
            super(transaction, Database.SYS_DATA_TRIGGER);
        }

        private static DataTableDef createDataTableDef(String schema, String name) {
            DataTableDef def = new DataTableDef();
            def.setTableName(new TableName(schema, name));
            def.addColumn(DataTableColumnDef.createNumericColumn("type"));
            def.addColumn(DataTableColumnDef.createStringColumn("on_object"));
            def.addColumn(DataTableColumnDef.createStringColumn("procedure_name"));
            def.addColumn(DataTableColumnDef.createStringColumn("param_args"));
            def.addColumn(DataTableColumnDef.createStringColumn("owner"));
            def.setImmutable();
            return def;
        }

        public String getTableType(int i) {
            return "TRIGGER";
        }

        public DataTableDef getDataTableDef(int i) {
            TableName table_name = this.getTableName(i);
            return TriggerInternalTableInfo.createDataTableDef(table_name.getSchema(), table_name.getName());
        }

        public MutableTableDataSource createInternalTable(int index) {
            MutableTableDataSource table = this.transaction.getTable(Database.SYS_DATA_TRIGGER);
            RowEnumeration row_e = table.rowEnumeration();
            int p = 0;
            int row_i = -1;
            while (row_e.hasMoreRows()) {
                int i = row_e.nextRowIndex();
                if (p == index) {
                    row_i = i;
                    continue;
                }
                ++p;
            }
            if (p == index) {
                String schema = table.getCellContents(0, row_i).getObject().toString();
                String name = table.getCellContents(1, row_i).getObject().toString();
                final DataTableDef table_def = TriggerInternalTableInfo.createDataTableDef(schema, name);
                final TObject type = table.getCellContents(2, row_i);
                final TObject on_object = table.getCellContents(3, row_i);
                final TObject procedure_name = table.getCellContents(4, row_i);
                final TObject param_args = table.getCellContents(5, row_i);
                final TObject owner = table.getCellContents(6, row_i);
                return new GTDataSource(this.transaction.getSystem()){

                    public DataTableDef getDataTableDef() {
                        return table_def;
                    }

                    public int getRowCount() {
                        return 1;
                    }

                    public TObject getCellContents(int col, int row) {
                        switch (col) {
                            case 0: {
                                return type;
                            }
                            case 1: {
                                return on_object;
                            }
                            case 2: {
                                return procedure_name;
                            }
                            case 3: {
                                return param_args;
                            }
                            case 4: {
                                return owner;
                            }
                        }
                        throw new RuntimeException("Column out of bounds.");
                    }
                };
            }
            throw new RuntimeException("Index out of bounds.");
        }
    }

    private class TriggerInfo {
        String schema;
        String name;
        int type;
        String on_object;
        String action;
        TObject misc;

        private TriggerInfo() {
        }
    }

    private class CTMBackedCache
    extends TableBackedCache {
        public CTMBackedCache() {
            super(Database.SYS_DATA_TRIGGER);
        }

        public void purgeCacheOfInvalidatedEntries(IntegerVector added_rows, IntegerVector removed_rows) {
            if (ConnectionTriggerManager.this.trigger_modified) {
                ConnectionTriggerManager.this.invalidateTriggerList();
                ConnectionTriggerManager.this.trigger_modified = false;
            } else if (removed_rows != null && removed_rows.size() > 0 || added_rows != null && added_rows.size() > 0) {
                ConnectionTriggerManager.this.invalidateTriggerList();
            }
        }
    }
}

