/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableColumnDef;
import com.mckoi.database.TObject;
import com.mckoi.database.global.ByteLongObject;
import com.mckoi.database.global.ObjectTranslator;
import com.mckoi.database.global.StringObject;
import com.mckoi.util.BigNumber;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class Caster {
    public static final int PRIMITIVE_COST = 100;
    public static final int OBJECT_COST = 200;
    private static final BigNumber maxBigNumByte = BigNumber.fromInt(127);
    private static final BigNumber minBigNumByte = BigNumber.fromInt(-128);
    private static final BigNumber maxBigNumShort = BigNumber.fromInt(Short.MAX_VALUE);
    private static final BigNumber minBigNumShort = BigNumber.fromInt(Short.MIN_VALUE);
    private static final BigNumber maxBigNumInt = BigNumber.fromInt(Integer.MAX_VALUE);
    private static final BigNumber minBigNumInt = BigNumber.fromInt(Integer.MIN_VALUE);
    private static final BigNumber maxBigNumLong = BigNumber.fromLong(Long.MAX_VALUE);
    private static final BigNumber minBigNumLong = BigNumber.fromLong(Long.MIN_VALUE);
    private static final BigNumber maxBigNumFloat = BigNumber.fromDouble(3.4028234663852886E38);
    private static BigNumber minBigNumFloat = BigNumber.fromDouble(1.4E-45f);
    private static BigNumber maxBigNumDouble = BigNumber.fromDouble(Double.MAX_VALUE);
    private static String[] bitPrims = new String[]{"boolean"};
    private static Class[] bitClasses = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = Caster.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    private static String[] tinyPrims = new String[]{"byte", "short", "int", "long"};
    private static Class[] tinyClasses = new Class[]{class$java$lang$Byte == null ? (class$java$lang$Byte = Caster.class$("java.lang.Byte")) : class$java$lang$Byte, class$java$lang$Short == null ? (class$java$lang$Short = Caster.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Caster.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Caster.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Number == null ? (class$java$lang$Number = Caster.class$("java.lang.Number")) : class$java$lang$Number};
    private static String[] smallPrims = new String[]{"short", "int", "long"};
    private static Class[] smallClasses = new Class[]{class$java$lang$Short == null ? (class$java$lang$Short = Caster.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Integer == null ? (class$java$lang$Integer = Caster.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Caster.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Number == null ? (class$java$lang$Number = Caster.class$("java.lang.Number")) : class$java$lang$Number};
    private static String[] intPrims = new String[]{"int", "long"};
    private static Class[] intClasses = new Class[]{class$java$lang$Integer == null ? (class$java$lang$Integer = Caster.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = Caster.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Number == null ? (class$java$lang$Number = Caster.class$("java.lang.Number")) : class$java$lang$Number};
    private static String[] bigPrims = new String[]{"long"};
    private static Class[] bigClasses = new Class[]{class$java$lang$Long == null ? (class$java$lang$Long = Caster.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Number == null ? (class$java$lang$Number = Caster.class$("java.lang.Number")) : class$java$lang$Number};
    private static String[] floatPrims = new String[]{"float", "double"};
    private static Class[] floatClasses = new Class[]{class$java$lang$Float == null ? (class$java$lang$Float = Caster.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Double == null ? (class$java$lang$Double = Caster.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Number == null ? (class$java$lang$Number = Caster.class$("java.lang.Number")) : class$java$lang$Number};
    private static String[] doublePrims = new String[]{"double"};
    private static Class[] doubleClasses = new Class[]{class$java$lang$Double == null ? (class$java$lang$Double = Caster.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Number == null ? (class$java$lang$Number = Caster.class$("java.lang.Number")) : class$java$lang$Number};
    private static String[] stringPrims = new String[0];
    private static Class[] stringClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Caster.class$("java.lang.String")) : class$java$lang$String};
    private static String[] datePrims = new String[0];
    private static Class[] dateClasses = new Class[]{class$java$sql$Date == null ? (class$java$sql$Date = Caster.class$("java.sql.Date")) : class$java$sql$Date, class$java$util$Date == null ? (class$java$util$Date = Caster.class$("java.util.Date")) : class$java$util$Date};
    private static String[] timePrims = new String[0];
    private static Class[] timeClasses = new Class[]{class$java$sql$Time == null ? (class$java$sql$Time = Caster.class$("java.sql.Time")) : class$java$sql$Time, class$java$util$Date == null ? (class$java$util$Date = Caster.class$("java.util.Date")) : class$java$util$Date};
    private static String[] timestampPrims = new String[0];
    private static Class[] timestampClasses = new Class[]{class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Caster.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, class$java$util$Date == null ? (class$java$util$Date = Caster.class$("java.util.Date")) : class$java$util$Date};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$com$mckoi$database$TObject;

    public static void deserializeJavaObjects(TObject[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object argVal;
            int sqlType = args[i].getTType().getSQLType();
            if (sqlType != 2000 || !((argVal = args[i].getObject()) instanceof ByteLongObject)) continue;
            Object javaObj = ObjectTranslator.deserialize((ByteLongObject)argVal);
            args[i] = new TObject(args[i].getTType(), javaObj);
        }
    }

    public static Constructor findBestConstructor(Constructor[] constructs, TObject[] args) {
        int bestCost = 0;
        Constructor bestConstructor = null;
        int[] argSqlTypes = Caster.getSqlTypes(args);
        for (int i = 0; i < constructs.length; ++i) {
            Class[] targets = constructs[i].getParameterTypes();
            int cost = Caster.getCastingCost(args, argSqlTypes, targets);
            if (cost < 0 || bestConstructor != null && cost >= bestCost) continue;
            bestCost = cost;
            bestConstructor = constructs[i];
        }
        return bestConstructor;
    }

    public static int[] getSqlTypes(TObject[] args) {
        int[] sqlTypes = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            sqlTypes[i] = Caster.getSqlType(args[i]);
        }
        return sqlTypes;
    }

    public static int getSqlType(TObject arg) {
        int sqlType = arg.getTType().getSQLType();
        Object argVal = arg.getObject();
        if (!(argVal instanceof BigNumber)) {
            return sqlType;
        }
        BigNumber b = (BigNumber)argVal;
        switch (sqlType) {
            case 2: 
            case 3: {
                if (b.canBeRepresentedAsInt()) {
                    sqlType = 4;
                    break;
                }
                if (b.canBeRepresentedAsLong()) {
                    sqlType = -5;
                    break;
                }
                BigNumber bAbs = b.abs();
                if (b.getScale() == 0) {
                    if (bAbs.compareTo(maxBigNumInt) <= 0) {
                        sqlType = 4;
                        break;
                    }
                    if (bAbs.compareTo(maxBigNumLong) > 0) break;
                    sqlType = -5;
                    break;
                }
                if (bAbs.compareTo(maxBigNumDouble) > 0) break;
                sqlType = 8;
                break;
            }
            case -7: {
                int n;
                if (b.canBeRepresentedAsInt() && ((n = b.intValue()) == 0 || n == 1)) {
                    return sqlType;
                }
                sqlType = -6;
            }
            case -6: {
                if (b.compareTo(maxBigNumByte) <= 0 && b.compareTo(minBigNumByte) >= 0) {
                    return sqlType;
                }
                sqlType = 5;
            }
            case 5: {
                if (b.compareTo(maxBigNumShort) <= 0 && b.compareTo(minBigNumShort) >= 0) {
                    return sqlType;
                }
                sqlType = 4;
            }
            case 4: {
                if (b.compareTo(maxBigNumInt) <= 0 && b.compareTo(minBigNumInt) >= 0) {
                    return sqlType;
                }
                sqlType = -5;
                break;
            }
            case 7: {
                BigNumber bAbs = b.abs();
                if (bAbs.compareTo(maxBigNumFloat) <= 0 && (bAbs.compareTo(minBigNumFloat) >= 0 || b.doubleValue() == 0.0)) {
                    return sqlType;
                }
                sqlType = 8;
                break;
            }
        }
        return sqlType;
    }

    public static String getArgTypesString(TObject[] args) {
        StringBuffer sb = new StringBuffer();
        for (int n = 0; n < args.length; ++n) {
            Object argObj;
            if (n > 0) {
                sb.append(",");
            }
            if (args[n] == null) {
                sb.append("null");
                continue;
            }
            int sqlType = Caster.getSqlType(args[n]);
            String typeName = sqlType == 2000 ? ((argObj = args[n].getObject()) == null ? "null" : argObj.getClass().getName()) : DataTableColumnDef.sqlTypeToString(sqlType);
            sb.append(typeName);
        }
        return sb.toString();
    }

    static int getCastingCost(TObject[] args, int[] argSqlTypes, Class[] targets) {
        if (targets.length != argSqlTypes.length) {
            return -1;
        }
        int totalCost = 0;
        for (int n = 0; n < argSqlTypes.length; ++n) {
            int argCost = Caster.getCastingCost(args[n], argSqlTypes[n], targets[n]);
            if (argCost < 0) {
                return -1;
            }
            int positionalCost = argCost * n / 10000;
            totalCost += argCost + positionalCost;
        }
        return totalCost;
    }

    static int getCastingCost(TObject arg, int argSqlType, Class target) {
        if (target == (class$com$mckoi$database$TObject == null ? (class$com$mckoi$database$TObject = Caster.class$("com.mckoi.database.TObject")) : class$com$mckoi$database$TObject)) {
            return 0;
        }
        switch (argSqlType) {
            case -7: {
                return Caster.getCastingCost(arg, bitPrims, bitClasses, target);
            }
            case -6: {
                return Caster.getCastingCost(arg, tinyPrims, tinyClasses, target);
            }
            case 5: {
                return Caster.getCastingCost(arg, smallPrims, smallClasses, target);
            }
            case 4: {
                return Caster.getCastingCost(arg, intPrims, intClasses, target);
            }
            case -5: {
                return Caster.getCastingCost(arg, bigPrims, bigClasses, target);
            }
            case 7: {
                return Caster.getCastingCost(arg, floatPrims, floatClasses, target);
            }
            case 6: 
            case 8: {
                return Caster.getCastingCost(arg, doublePrims, doubleClasses, target);
            }
            case 2: 
            case 3: {
                return -1;
            }
            case -1: 
            case 1: 
            case 12: {
                return Caster.getCastingCost(arg, stringPrims, stringClasses, target);
            }
            case 91: {
                return Caster.getCastingCost(arg, datePrims, dateClasses, target);
            }
            case 92: {
                return Caster.getCastingCost(arg, timePrims, timeClasses, target);
            }
            case 93: {
                return Caster.getCastingCost(arg, timestampPrims, timestampClasses, target);
            }
            case -4: 
            case -3: 
            case -2: {
                return -1;
            }
            case 2000: {
                Object argVal = arg.getObject();
                if (argVal == null || target.isAssignableFrom(argVal.getClass())) {
                    return 200;
                }
                return -1;
            }
            case 0: {
                return -1;
            }
        }
        return -1;
    }

    static int getCastingCost(TObject arg, String[] prims, Class[] objects, Class target) {
        if (target.isPrimitive()) {
            Object argVal = arg.getObject();
            if (argVal == null) {
                return -1;
            }
            String targetName = target.getName();
            for (int i = 0; i < prims.length; ++i) {
                if (!targetName.equals(prims[i])) continue;
                return 100 + i;
            }
        } else {
            for (int i = 0; i < objects.length; ++i) {
                if (!objects[i].isAssignableFrom(target)) continue;
                return 200 + i;
            }
        }
        return -1;
    }

    public static Object[] castArgsToConstructor(TObject[] args, Constructor constructor) {
        Class[] targets = constructor.getParameterTypes();
        return Caster.castArgs(args, targets);
    }

    static Object[] castArgs(TObject[] args, Class[] targets) {
        if (targets.length != args.length) {
            throw new RuntimeException("array length mismatch: arg=" + args.length + ", targets=" + targets.length);
        }
        Object[] castedArgs = new Object[args.length];
        for (int n = 0; n < args.length; ++n) {
            castedArgs[n] = Caster.castArg(args[n], targets[n]);
        }
        return castedArgs;
    }

    static Object castArg(TObject arg, Class target) {
        if (target == (class$com$mckoi$database$TObject == null ? (class$com$mckoi$database$TObject = Caster.class$("com.mckoi.database.TObject")) : class$com$mckoi$database$TObject)) {
            return arg;
        }
        Object argVal = arg.getObject();
        if (argVal == null) {
            return null;
        }
        String targetName = target.getName();
        if (argVal instanceof Boolean) {
            if (targetName.equals("boolean") || (class$java$lang$Boolean == null ? (class$java$lang$Boolean = Caster.class$("java.lang.Boolean")) : class$java$lang$Boolean).isAssignableFrom(target)) {
                return argVal;
            }
        } else if (argVal instanceof Number) {
            Number num = (Number)argVal;
            if (targetName.equals("byte") || (class$java$lang$Byte == null ? (class$java$lang$Byte = Caster.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(target)) {
                return new Byte(num.byteValue());
            }
            if (targetName.equals("short") || (class$java$lang$Short == null ? (class$java$lang$Short = Caster.class$("java.lang.Short")) : class$java$lang$Short).isAssignableFrom(target)) {
                return new Short(num.shortValue());
            }
            if (targetName.equals("int") || (class$java$lang$Integer == null ? (class$java$lang$Integer = Caster.class$("java.lang.Integer")) : class$java$lang$Integer).isAssignableFrom(target)) {
                return new Integer(num.intValue());
            }
            if (targetName.equals("long") || (class$java$lang$Long == null ? (class$java$lang$Long = Caster.class$("java.lang.Long")) : class$java$lang$Long).isAssignableFrom(target)) {
                return new Long(num.longValue());
            }
            if (targetName.equals("float") || (class$java$lang$Float == null ? (class$java$lang$Float = Caster.class$("java.lang.Float")) : class$java$lang$Float).isAssignableFrom(target)) {
                return new Float(num.floatValue());
            }
            if (targetName.equals("double") || (class$java$lang$Double == null ? (class$java$lang$Double = Caster.class$("java.lang.Double")) : class$java$lang$Double).isAssignableFrom(target)) {
                return new Float(num.doubleValue());
            }
        } else if (argVal instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)argVal;
            if ((class$java$sql$Date == null ? (class$java$sql$Date = Caster.class$("java.sql.Date")) : class$java$sql$Date).isAssignableFrom(target)) {
                return new Date(date.getTime());
            }
            if ((class$java$sql$Time == null ? (class$java$sql$Time = Caster.class$("java.sql.Time")) : class$java$sql$Time).isAssignableFrom(target)) {
                return new Time(date.getTime());
            }
            if ((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = Caster.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).isAssignableFrom(target)) {
                return new Timestamp(date.getTime());
            }
            if ((class$java$util$Date == null ? (class$java$util$Date = Caster.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(target)) {
                return date;
            }
        } else if (argVal instanceof String || argVal instanceof StringObject) {
            String s = argVal.toString();
            if ((class$java$lang$String == null ? (class$java$lang$String = Caster.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(target)) {
                return s;
            }
        } else if (Caster.getSqlType(arg) == 2000 && target.isAssignableFrom(argVal.getClass())) {
            return argVal;
        }
        throw new RuntimeException("Programming error: Can't cast from " + argVal.getClass().getName() + " to " + target.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

