/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database;

import com.mckoi.database.DataTableDef;
import com.mckoi.database.InternalTableInfo;
import com.mckoi.database.TableName;

abstract class AbstractInternalTableInfo
implements InternalTableInfo {
    private TableName[] table_list;
    private DataTableDef[] table_def_list;
    private String table_type;

    AbstractInternalTableInfo(String type, DataTableDef[] table_def_list) {
        this.table_def_list = table_def_list;
        this.table_type = type;
        this.table_list = new TableName[table_def_list.length];
        for (int i = 0; i < this.table_list.length; ++i) {
            this.table_list[i] = table_def_list[i].getTableName();
        }
    }

    public int getTableCount() {
        return this.table_list.length;
    }

    public int findTableName(TableName name) {
        for (int i = 0; i < this.table_list.length; ++i) {
            if (!this.table_list[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    public TableName getTableName(int i) {
        return this.table_list[i];
    }

    public DataTableDef getDataTableDef(int i) {
        return this.table_def_list[i];
    }

    public boolean containsTableName(TableName name) {
        return this.findTableName(name) != -1;
    }

    public String getTableType(int i) {
        return this.table_type;
    }
}

