/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import java.io.IOException;
import java.io.InputStream;

public abstract class PagedInputStream
extends InputStream {
    private final int BUFFER_SIZE;
    private long position;
    private long size;
    private long buffer_pos;
    private final byte[] buf;
    private long mark_position;

    public PagedInputStream(int page_size, long total_size) {
        this.BUFFER_SIZE = page_size;
        this.position = 0L;
        this.size = total_size;
        this.mark_position = 0L;
        this.buf = new byte[this.BUFFER_SIZE];
        this.buffer_pos = -1L;
    }

    protected abstract void readPageContent(byte[] var1, long var2, int var4) throws IOException;

    private void fillBuffer(long pos) throws IOException {
        long read_pos = pos / (long)this.BUFFER_SIZE * (long)this.BUFFER_SIZE;
        int to_read = (int)Math.min((long)this.BUFFER_SIZE, this.size - read_pos);
        if (to_read > 0) {
            this.readPageContent(this.buf, read_pos, to_read);
            this.buffer_pos = read_pos;
        }
    }

    public int read() throws IOException {
        if (this.position >= this.size) {
            return -1;
        }
        if (this.buffer_pos == -1L) {
            this.fillBuffer(this.position);
        }
        int p = (int)(this.position - this.buffer_pos);
        int v = this.buf[p] & 0xFF;
        ++this.position;
        if (p + 1 >= this.BUFFER_SIZE) {
            this.fillBuffer(this.buffer_pos + (long)this.BUFFER_SIZE);
        }
        return v;
    }

    public int read(byte[] read_buf, int off, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        if (this.buffer_pos == -1L) {
            this.fillBuffer(this.position);
        }
        int p = (int)(this.position - this.buffer_pos);
        long buffer_end = Math.min(this.buffer_pos + (long)this.BUFFER_SIZE, this.size);
        int to_read = (int)Math.min((long)len, buffer_end - this.position);
        if (to_read <= 0) {
            return -1;
        }
        int has_read = 0;
        while (to_read > 0) {
            System.arraycopy(this.buf, p, read_buf, off, to_read);
            has_read += to_read;
            off += to_read;
            len -= to_read;
            this.position += (long)to_read;
            if ((p += to_read) >= this.BUFFER_SIZE) {
                this.fillBuffer(this.buffer_pos + (long)this.BUFFER_SIZE);
                p -= this.BUFFER_SIZE;
            }
            buffer_end = Math.min(this.buffer_pos + (long)this.BUFFER_SIZE, this.size);
            to_read = (int)Math.min((long)len, buffer_end - this.position);
        }
        return has_read;
    }

    public long skip(long n) throws IOException {
        long act_skip = Math.min(n, this.size - this.position);
        if (n < 0L) {
            throw new IOException("Negative skip");
        }
        this.position += act_skip;
        if (this.buffer_pos == -1L || this.position - this.buffer_pos > (long)this.BUFFER_SIZE) {
            this.fillBuffer(this.position / (long)this.BUFFER_SIZE * (long)this.BUFFER_SIZE);
        }
        return act_skip;
    }

    public int available() throws IOException {
        return (int)Math.min(Integer.MAX_VALUE, this.size - this.position);
    }

    public void close() throws IOException {
    }

    public void mark(int limit) {
        this.mark_position = this.position;
    }

    public void reset() {
        this.position = this.mark_position;
        long fill_pos = this.position / (long)this.BUFFER_SIZE * (long)this.BUFFER_SIZE;
        if (fill_pos != this.buffer_pos) {
            try {
                this.fillBuffer(fill_pos);
            }
            catch (IOException e) {
                throw new Error(e.getMessage());
            }
        }
    }

    public boolean markSupported() {
        return true;
    }
}

