/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.RemoteDatabaseInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class StreamDatabaseInterface
extends RemoteDatabaseInterface {
    protected DataOutputStream out;
    protected DataInputStream in;
    private boolean closed = false;

    StreamDatabaseInterface() {
    }

    void setup(InputStream rawin, OutputStream rawout) throws IOException {
        if (rawin == null || rawout == null) {
            throw new IOException("rawin or rawin is null");
        }
        this.in = new DataInputStream(new BufferedInputStream(rawin, 32768));
        this.out = new DataOutputStream(new BufferedOutputStream(rawout, 32768));
    }

    void writeCommandToServer(byte[] command, int offset, int size) throws IOException {
        this.out.writeInt(size);
        this.out.write(command, 0, size);
        this.out.flush();
    }

    byte[] nextCommandFromServer(int timeout) throws IOException {
        if (this.closed) {
            throw new IOException("DatabaseInterface is closed!");
        }
        try {
            int command_length = this.in.readInt();
            byte[] buf = new byte[command_length];
            this.in.readFully(buf, 0, command_length);
            return buf;
        }
        catch (NullPointerException e) {
            System.out.println("Throwable generated at: " + this);
            throw e;
        }
    }

    void closeConnection() throws IOException {
        this.closed = true;
        try {
            this.out.close();
        }
        catch (IOException e) {
            this.in.close();
            throw e;
        }
        this.in.close();
    }
}

