/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.AbstractStreamableObject;
import com.mckoi.database.jdbc.AsciiInputStream;
import com.mckoi.database.jdbc.AsciiReader;
import com.mckoi.database.jdbc.BinaryToUnicodeReader;
import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.MSQLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

class MStreamableClob
extends AbstractStreamableObject
implements Clob {
    MStreamableClob(MConnection connection, int result_set_id, byte type, long streamable_object_id, long size) {
        super(connection, result_set_id, type, streamable_object_id, size);
    }

    public long length() throws SQLException {
        if (this.getType() == 4) {
            return this.rawSize() / 2L;
        }
        return this.rawSize();
    }

    public String getSubString(long pos, int length) throws SQLException {
        int p = (int)(pos - 1L);
        Reader reader = this.getCharacterStream();
        try {
            reader.skip(p);
            StringBuffer buf = new StringBuffer(length);
            for (int i = 0; i < length; ++i) {
                int c = reader.read();
                buf.append((char)c);
            }
            return new String(buf);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new SQLException("IO Error: " + e.getMessage());
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.getType() == 3) {
            return new AsciiReader(new AbstractStreamableObject.StreamableObjectInputStream(this.rawSize()));
        }
        if (this.getType() == 4) {
            return new BinaryToUnicodeReader(new AbstractStreamableObject.StreamableObjectInputStream(this.rawSize()));
        }
        throw new SQLException("Unknown type.");
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.getType() == 3) {
            return new AbstractStreamableObject.StreamableObjectInputStream(this.rawSize());
        }
        if (this.getType() == 4) {
            return new AsciiInputStream(this.getCharacterStream());
        }
        throw new SQLException("Unknown type.");
    }

    public long position(String searchstr, long start) throws SQLException {
        throw MSQLException.unsupported();
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int setString(long pos, String str) throws SQLException {
        throw MSQLException.unsupported();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw MSQLException.unsupported();
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void truncate(long len) throws SQLException {
        throw MSQLException.unsupported();
    }
}

