/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.global.ColumnDescription;
import com.mckoi.database.global.StreamableObject;
import com.mckoi.database.jdbc.DatabaseCallBack;
import com.mckoi.database.jdbc.DatabaseInterface;
import com.mckoi.database.jdbc.MDatabaseMetaData;
import com.mckoi.database.jdbc.MPreparedStatement;
import com.mckoi.database.jdbc.MResultSet;
import com.mckoi.database.jdbc.MSQLException;
import com.mckoi.database.jdbc.MStatement;
import com.mckoi.database.jdbc.MckoiConnection;
import com.mckoi.database.jdbc.QueryResponse;
import com.mckoi.database.jdbc.ResultPart;
import com.mckoi.database.jdbc.RowCache;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.jdbc.StreamableObjectPart;
import com.mckoi.database.jdbc.TriggerListener;
import java.io.IOException;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class MConnection
implements Connection,
DatabaseCallBack {
    private RowCache row_cache;
    private String url;
    private SQLWarning head_warning;
    private boolean is_closed;
    private boolean auto_commit;
    private DatabaseInterface db_interface;
    private Vector trigger_list;
    private TriggerDispatchThread trigger_thread;
    private boolean strict_get_object;
    private boolean verbose_column_names;
    private boolean case_insensitive_identifiers;
    private Hashtable s_object_hold;
    private long s_object_id;
    private Object lock = new Object();

    public MConnection(String url, DatabaseInterface db_interface, int cache_size, int max_size) {
        this.url = url;
        this.db_interface = db_interface;
        this.is_closed = true;
        this.auto_commit = true;
        this.trigger_list = new Vector();
        this.strict_get_object = true;
        this.verbose_column_names = false;
        this.case_insensitive_identifiers = false;
        this.row_cache = new RowCache(cache_size, max_size);
        this.s_object_hold = new Hashtable();
        this.s_object_id = 0L;
    }

    public void setStrictGetObject(boolean status) {
        this.strict_get_object = status;
    }

    public boolean isStrictGetObject() {
        return this.strict_get_object;
    }

    public void setVerboseColumnNames(boolean status) {
        this.verbose_column_names = status;
    }

    public boolean verboseColumnNames() {
        return this.verbose_column_names;
    }

    public void setCaseInsensitiveIdentifiers(boolean status) {
        this.case_insensitive_identifiers = status;
    }

    public boolean isCaseInsensitiveIdentifiers() {
        return this.case_insensitive_identifiers;
    }

    protected final RowCache getRowCache() {
        return this.row_cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addSQLWarning(SQLWarning warning) {
        Object object = this.lock;
        synchronized (object) {
            if (this.head_warning == null) {
                this.head_warning = warning;
            } else {
                this.head_warning.setNextWarning(warning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void internalClose() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                try {
                    this.db_interface.dispose();
                }
                finally {
                    this.is_closed = true;
                }
            }
        }
    }

    MckoiConnection getMckoiConnection() {
        return new MckoiConnection(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(String default_schema, String username, String password) throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.is_closed) {
                throw new SQLException("Unable to login to connection because it is open.");
            }
        }
        if (username == null || username.equals("") || password == null || password.equals("")) {
            throw new SQLException("username or password have not been set.");
        }
        if (default_schema == null) {
            default_schema = username;
        }
        boolean li = this.db_interface.login(default_schema, username, password, this);
        Object object2 = this.lock;
        synchronized (object2) {
            this.is_closed = !li;
        }
        if (!li) {
            throw new SQLException("User authentication failed for: " + username);
        }
        this.setCaseInsensitiveIdentifiers(false);
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("SHOW CONNECTION_INFO");
        while (rs.next()) {
            String val;
            String key = rs.getString(1);
            if (key.equals("case_insensitive_identifiers")) {
                val = rs.getString(2);
                this.setCaseInsensitiveIdentifiers(val.equals("true"));
                continue;
            }
            if (!key.equals("auto_commit")) continue;
            val = rs.getString(2);
            this.auto_commit = val.equals("true");
        }
        rs.close();
        stmt.close();
    }

    String getURL() {
        return this.url;
    }

    void login(Properties info, String default_schema) throws SQLException {
        String username = info.getProperty("user", "");
        String password = info.getProperty("password", "");
        this.login(default_schema, username, password);
    }

    private void uploadStreamableObjects(SQLQuery sql) throws SQLException {
        Object[] vars = sql.getVars();
        try {
            for (int i = 0; i < vars.length; ++i) {
                int block_read;
                if (vars[i] == null || !(vars[i] instanceof StreamableObject)) continue;
                int BUF_SIZE = 65536;
                StreamableObject s_object = (StreamableObject)vars[i];
                byte type = s_object.getType();
                long total_len = s_object.getSize();
                long id = s_object.getIdentifier();
                byte[] buf = new byte[65536];
                Long sob_id = new Long(id);
                InputStream i_stream = (InputStream)this.s_object_hold.get(sob_id);
                if (i_stream == null) {
                    throw new RuntimeException("Assertion failed: Streamable object InputStream is not available.");
                }
                for (long offset = 0L; offset < total_len; offset += (long)block_read) {
                    int count;
                    int index = 0;
                    for (int to_read = block_read = (int)Math.min(65536L, total_len - offset); to_read > 0; to_read -= count) {
                        count = i_stream.read(buf, index, to_read);
                        if (count == -1) {
                            throw new IOException("Premature end of stream.");
                        }
                        index += count;
                    }
                    this.db_interface.pushStreamableObjectPart(type, id, total_len, buf, offset, block_read);
                }
                this.s_object_hold.remove(sob_id);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            throw new SQLException("IO Error pushing large object to server: " + e.getMessage());
        }
    }

    void executeQueries(SQLQuery[] queries, MResultSet[] results) throws SQLException {
        for (int i = 0; i < queries.length; ++i) {
            this.executeQuery(queries[i], results[i]);
        }
    }

    void executeQuery(SQLQuery sql, MResultSet result_set) throws SQLException {
        this.uploadStreamableObjects(sql);
        QueryResponse resp = this.db_interface.execQuery(sql);
        ColumnDescription[] col_list = new ColumnDescription[resp.getColumnCount()];
        for (int i = 0; i < col_list.length; ++i) {
            col_list[i] = resp.getColumnDescription(i);
        }
        result_set.connSetup(resp.getResultID(), col_list, resp.getRowCount());
        result_set.setQueryTime(resp.getQueryTimeMillis());
    }

    ResultPart requestResultPart(int result_id, int start_row, int count_rows) throws SQLException {
        return this.db_interface.getResultPart(result_id, start_row, count_rows);
    }

    StreamableObjectPart requestStreamableObjectPart(int result_id, long streamable_object_id, long offset, int len) throws SQLException {
        return this.db_interface.getStreamableObjectPart(result_id, streamable_object_id, offset, len);
    }

    void disposeResult(int result_id) throws SQLException {
        if (!this.is_closed) {
            this.db_interface.disposeResult(result_id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTriggerListener(String trigger_name, TriggerListener listener) {
        Vector vector = this.trigger_list;
        synchronized (vector) {
            this.trigger_list.addElement(trigger_name);
            this.trigger_list.addElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTriggerListener(String trigger_name, TriggerListener listener) {
        Vector vector = this.trigger_list;
        synchronized (vector) {
            for (int i = this.trigger_list.size() - 2; i >= 0; i -= 2) {
                if (!this.trigger_list.elementAt(i).equals(trigger_name) || !this.trigger_list.elementAt(i + 1).equals(listener)) continue;
                this.trigger_list.removeElementAt(i);
                this.trigger_list.removeElementAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StreamableObject createStreamableObject(InputStream x, int length, byte type) {
        long ob_id;
        Hashtable hashtable = this.s_object_hold;
        synchronized (hashtable) {
            ob_id = this.s_object_id++;
            this.s_object_hold.put(new Long(ob_id), x);
        }
        return new StreamableObject(type, length, ob_id);
    }

    void removeStreamableObject(StreamableObject s_object) {
        this.s_object_hold.remove(new Long(s_object.getIdentifier()));
    }

    public void databaseEvent(int event_type, String event_message) {
        if (event_type == 99) {
            if (this.trigger_thread == null) {
                this.trigger_thread = new TriggerDispatchThread();
                this.trigger_thread.start();
            }
        } else {
            throw new Error("Unrecognised database event: " + event_type);
        }
        this.trigger_thread.dispatchTrigger(event_message);
    }

    public Statement createStatement() throws SQLException {
        return new MStatement(this);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new MPreparedStatement(this, sql);
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        throw MSQLException.unsupported();
    }

    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit) {
            ResultSet result = this.createStatement().executeQuery("SET AUTO COMMIT ON");
            this.auto_commit = true;
            result.close();
        } else {
            ResultSet result = this.createStatement().executeQuery("SET AUTO COMMIT OFF");
            this.auto_commit = false;
            result.close();
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.auto_commit;
    }

    public void commit() throws SQLException {
        ResultSet result = this.createStatement().executeQuery("COMMIT");
        result.close();
    }

    public void rollback() throws SQLException {
        ResultSet result = this.createStatement().executeQuery("ROLLBACK");
        result.close();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this.internalClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            return this.is_closed;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return new MDatabaseMetaData(this);
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public void setCatalog(String catalog) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 8) {
            throw new SQLException("Only 'TRANSACTION_SERIALIZABLE' supported.");
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLWarning getWarnings() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            return this.head_warning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.head_warning = null;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement statement = this.createStatement();
        return statement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement statement = this.prepareStatement(sql);
        return statement;
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Map getTypeMap() throws SQLException {
        throw MSQLException.unsupported();
    }

    public void setTypeMap(Map map) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void setHoldability(int holdability) throws SQLException {
        if (holdability == 2) {
            throw new SQLException("CLOSE_CURSORS_AT_COMMIT holdability is not supported.");
        }
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public Savepoint setSavepoint() throws SQLException {
        throw MSQLException.unsupported();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw MSQLException.unsupported();
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw MSQLException.unsupported();
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("CLOSE_CURSORS_AT_COMMIT holdability is not supported.");
        }
        return this.createStatement(resultSetType, resultSetConcurrency);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetHoldability == 2) {
            throw new SQLException("CLOSE_CURSORS_AT_COMMIT holdability is not supported.");
        }
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw MSQLException.unsupported();
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw MSQLException.unsupported();
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw MSQLException.unsupported();
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw MSQLException.unsupported();
    }

    private class TriggerDispatchThread
    extends Thread {
        private Vector trigger_messages_queue = new Vector();

        TriggerDispatchThread() {
            this.setDaemon(true);
            this.setName("Mckoi - Trigger Dispatcher");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchTrigger(String event_message) {
            Vector vector = this.trigger_messages_queue;
            synchronized (vector) {
                this.trigger_messages_queue.addElement(event_message);
                this.trigger_messages_queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                try {
                    block11: while (true) {
                        String message;
                        Vector vector = this.trigger_messages_queue;
                        synchronized (vector) {
                            while (this.trigger_messages_queue.size() == 0) {
                                try {
                                    this.trigger_messages_queue.wait();
                                }
                                catch (InterruptedException e) {}
                            }
                            message = (String)this.trigger_messages_queue.elementAt(0);
                            this.trigger_messages_queue.removeElementAt(0);
                        }
                        StringTokenizer tok = new StringTokenizer(message, " ");
                        String trigger_name = (String)tok.nextElement();
                        String trigger_source = (String)tok.nextElement();
                        String trigger_fire_count = (String)tok.nextElement();
                        Vector<TriggerListener> fired_triggers = new Vector<TriggerListener>();
                        Vector vector2 = MConnection.this.trigger_list;
                        synchronized (vector2) {
                            for (int i = 0; i < MConnection.this.trigger_list.size(); i += 2) {
                                String to_listen_for = (String)MConnection.this.trigger_list.elementAt(i);
                                if (!to_listen_for.equals(trigger_name)) continue;
                                TriggerListener listener = (TriggerListener)MConnection.this.trigger_list.elementAt(i + 1);
                                fired_triggers.addElement(listener);
                            }
                        }
                        int i = 0;
                        while (true) {
                            if (i >= fired_triggers.size()) continue block11;
                            TriggerListener listener = (TriggerListener)fired_triggers.elementAt(i);
                            listener.triggerFired(trigger_name);
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

