/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.jdbc;

import com.mckoi.database.jdbc.MConnection;
import com.mckoi.database.jdbc.StreamableObjectPart;
import com.mckoi.util.PagedInputStream;
import java.io.IOException;
import java.sql.SQLException;

abstract class AbstractStreamableObject {
    protected final MConnection connection;
    protected final int result_set_id;
    private final long streamable_object_id;
    private final byte type;
    private final long size;

    AbstractStreamableObject(MConnection connection, int result_set_id, byte type, long streamable_object_id, long size) {
        this.connection = connection;
        this.result_set_id = result_set_id;
        this.type = type;
        this.streamable_object_id = streamable_object_id;
        this.size = size;
    }

    protected long getStreamableId() {
        return this.streamable_object_id;
    }

    protected byte getType() {
        return this.type;
    }

    protected long rawSize() {
        return this.size;
    }

    class StreamableObjectInputStream
    extends PagedInputStream {
        private static final int B_SIZE = 65536;

        public StreamableObjectInputStream(long in_size) {
            super(65536, in_size);
        }

        protected void readPageContent(byte[] buf, long pos, int length) throws IOException {
            try {
                StreamableObjectPart part = AbstractStreamableObject.this.connection.requestStreamableObjectPart(AbstractStreamableObject.this.result_set_id, AbstractStreamableObject.this.streamable_object_id, pos, length);
                System.arraycopy(part.getContents(), 0, buf, 0, length);
            }
            catch (SQLException e) {
                throw new IOException("SQL Error: " + e.getMessage());
            }
        }
    }
}

