/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.global;

import com.mckoi.database.global.TypeUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ColumnDescription {
    private String name;
    private int type;
    private int size;
    private int scale = -1;
    private int sql_type = -9332;
    private boolean not_null;
    private boolean unique;
    private int unique_group;

    public ColumnDescription(String name, int type, int size, boolean not_null) {
        this.name = name;
        this.type = type;
        this.size = size;
        this.not_null = not_null;
        this.unique = false;
        this.unique_group = -1;
    }

    public ColumnDescription(String name, int type, boolean not_null) {
        this(name, type, -1, not_null);
    }

    public ColumnDescription(ColumnDescription cd) {
        this(cd.getName(), cd.getType(), cd.getSize(), cd.isNotNull());
        if (cd.isUnique()) {
            this.setUnique();
        }
        this.setUniqueGroup(cd.getUniqueGroup());
        this.setScale(cd.getScale());
        this.setSQLType(cd.getSQLType());
    }

    public ColumnDescription(String name, ColumnDescription cd) {
        this(name, cd.getType(), cd.getSize(), cd.isNotNull());
        if (cd.isUnique()) {
            this.setUnique();
        }
        this.setUniqueGroup(cd.getUniqueGroup());
        this.setScale(cd.getScale());
        this.setSQLType(cd.getSQLType());
    }

    public void setUnique() {
        this.unique = true;
    }

    public void setUniqueGroup(int group) {
        this.unique_group = group;
    }

    public void setSQLType(int sql_type) {
        this.sql_type = sql_type;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public boolean isNumericType() {
        return this.type == 2;
    }

    public int getSQLType() {
        if (this.sql_type == -9332) {
            if (this.type == 2) {
                return 2;
            }
            if (this.type == 1) {
                return -1;
            }
            if (this.type == 5) {
                return -7;
            }
            if (this.type == 3) {
                return 93;
            }
            if (this.type == 6) {
                return -4;
            }
            if (this.type == 7) {
                return 2000;
            }
            throw new Error("Unrecognised internal type.");
        }
        return this.sql_type;
    }

    public String getSQLTypeName() {
        int type = this.getSQLType();
        switch (type) {
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 0: {
                return "NULL";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "JAVA_OBJECT";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 2003: {
                return "ARRAY";
            }
            case 2004: {
                return "BLOB";
            }
            case 2005: {
                return "CLOB";
            }
            case 2006: {
                return "REF";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        return null;
    }

    public Class classType() {
        return TypeUtil.toClass(this.type);
    }

    public int getSize() {
        return this.size;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNotNull() {
        return this.not_null;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getUniqueGroup() {
        return this.unique_group;
    }

    public boolean isQuantifiable() {
        return this.type != 6 && this.type != 7;
    }

    public boolean equals(Object ob) {
        ColumnDescription cd = (ColumnDescription)ob;
        return this.name.equals(cd.name) && this.type == cd.type && this.size == cd.size && this.not_null == cd.not_null && this.unique == cd.unique && this.unique_group == cd.unique_group;
    }

    public void writeTo(DataOutputStream out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.type);
        out.writeInt(this.size);
        out.writeBoolean(this.not_null);
        out.writeBoolean(this.unique);
        out.writeInt(this.unique_group);
        out.writeInt(this.sql_type);
        out.writeInt(this.scale);
    }

    public static ColumnDescription readFrom(DataInputStream in) throws IOException {
        String name = in.readUTF();
        int type = in.readInt();
        int size = in.readInt();
        boolean not_null = in.readBoolean();
        boolean unique = in.readBoolean();
        int unique_group = in.readInt();
        ColumnDescription col_desc = new ColumnDescription(name, type, size, not_null);
        if (unique) {
            col_desc.setUnique();
        }
        col_desc.setUniqueGroup(unique_group);
        col_desc.setSQLType(in.readInt());
        col_desc.setScale(in.readInt());
        return col_desc;
    }
}

