/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.control;

import com.mckoi.database.control.AbstractDBConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DefaultDBConfig
extends AbstractDBConfig {
    private static Hashtable CONFIG_DEFAULTS = new Hashtable();

    public DefaultDBConfig(File current_path) {
        super(current_path);
    }

    public DefaultDBConfig() {
        this(new File("."));
    }

    protected String getDefaultValue(String property_key) {
        ConfigProperty property = (ConfigProperty)CONFIG_DEFAULTS.get(property_key);
        if (property == null) {
            return null;
        }
        return property.getDefaultValue();
    }

    public void setValue(String property_key, String value) {
        super.setValue(property_key, value);
    }

    public void loadFromStream(InputStream input) throws IOException {
        Properties config = new Properties();
        config.load(new BufferedInputStream(input));
        Enumeration<?> enumeration = config.propertyNames();
        while (enumeration.hasMoreElements()) {
            String property_key = (String)enumeration.nextElement();
            this.setValue(property_key, config.getProperty(property_key));
        }
    }

    public void loadFromFile(File configuration_file) throws IOException {
        FileInputStream file_in = new FileInputStream(configuration_file);
        this.loadFromStream(file_in);
        file_in.close();
    }

    public void loadFromURL(URL configuration_url) throws IOException {
        InputStream url_in = configuration_url.openConnection().getInputStream();
        this.loadFromStream(url_in);
        url_in.close();
    }

    public void setDatabasePath(String path) {
        this.setValue("database_path", path);
    }

    public void setLogPath(String path) {
        this.setValue("log_path", path);
    }

    public void setIgnoreIdentifierCase(boolean status) {
        this.setValue("ignore_case_for_identifiers", status ? "enabled" : "disabled");
    }

    public void setReadOnly(boolean status) {
        this.setValue("read_only", status ? "enabled" : "disabled");
    }

    public void setMinimumDebugLevel(int debug_level) {
        this.setValue("debug_level", "" + debug_level);
    }

    private static void addDefProperty(ConfigProperty property) {
        CONFIG_DEFAULTS.put(property.getKey(), property);
    }

    static {
        DefaultDBConfig.addDefProperty(new ConfigProperty("database_path", "./data", "PATH"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("root_path", "jvm", "STRING"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("jdbc_server_port", "9157", "STRING"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("ignore_case_for_identifiers", "disabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("regex_library", "gnu.regexp", "STRING"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("data_cache_size", "4194304", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("max_cache_entry_size", "8192", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("lookup_comparison_list", "enabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("maximum_worker_threads", "4", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("dont_synch_filesystem", "disabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("transaction_error_on_dirty_select", "enabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("read_only", "disabled", "BOOLEAN"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("debug_log_file", "debug.log", "FILE"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("debug_level", "20", "INT"));
        DefaultDBConfig.addDefProperty(new ConfigProperty("table_lock_check", "enabled", "BOOLEAN"));
    }

    private static class ConfigProperty {
        private String key;
        private String default_value;
        private String type;
        private String comment;

        ConfigProperty(String key, String default_value, String type, String comment) {
            this.key = key;
            this.default_value = default_value;
            this.type = type;
            this.comment = comment;
        }

        ConfigProperty(String key, String default_value, String type) {
            this(key, default_value, type, null);
        }

        String getKey() {
            return this.key;
        }

        String getDefaultValue() {
            return this.default_value;
        }

        String getType() {
            return this.type;
        }

        String getComment() {
            return this.comment;
        }
    }
}

