/*
 * Decompiled with CFR 0.152.
 */
package com.asual.lesscss;

import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.shell.Global;

public class LessEngine {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Scriptable scope;
    private ClassLoader classLoader;
    private Function compileString;
    private Function compileFile;

    public LessEngine() {
        this(new LessOptions());
    }

    public LessEngine(LessOptions options) {
        try {
            this.logger.debug((Object)"Initializing LESS Engine.");
            this.classLoader = this.getClass().getClassLoader();
            URL less = options.getLess();
            URL env = this.classLoader.getResource("META-INF/env.js");
            URL engine = this.classLoader.getResource("META-INF/engine.js");
            URL cssmin = this.classLoader.getResource("META-INF/cssmin.js");
            Context cx = Context.enter();
            this.logger.debug((Object)("Using implementation version: " + cx.getImplementationVersion()));
            cx.setOptimizationLevel(9);
            Global global = new Global();
            global.init(cx);
            this.scope = cx.initStandardObjects((ScriptableObject)global);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(env.openConnection().getInputStream()), env.getFile(), 1, null);
            cx.evaluateString(this.scope, "lessenv.charset = '" + options.getCharset() + "';", "charset", 1, null);
            cx.evaluateString(this.scope, "lessenv.css = " + options.isCss() + ";", "css", 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(less.openConnection().getInputStream()), less.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(cssmin.openConnection().getInputStream()), cssmin.getFile(), 1, null);
            cx.evaluateReader(this.scope, (Reader)new InputStreamReader(engine.openConnection().getInputStream()), engine.getFile(), 1, null);
            this.compileString = (Function)this.scope.get("compileString", this.scope);
            this.compileFile = (Function)this.scope.get("compileFile", this.scope);
            Context.exit();
        }
        catch (Exception e) {
            this.logger.error((Object)"LESS Engine intialization failed.", (Throwable)e);
        }
    }

    public String compile(String input) throws LessException {
        return this.compile(input, false);
    }

    public String compile(String input, boolean compress) throws LessException {
        try {
            long time = System.currentTimeMillis();
            String result = this.call(this.compileString, new Object[]{input, compress});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(URL input) throws LessException {
        return this.compile(input, false);
    }

    public String compile(URL input, boolean compress) throws LessException {
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)("Compiling URL: " + input.getProtocol() + ":" + input.getFile()));
            String result = this.call(this.compileFile, new Object[]{input.getProtocol() + ":" + input.getFile(), this.classLoader, compress});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public String compile(File input) throws LessException {
        return this.compile(input, false);
    }

    public String compile(File input, boolean compress) throws LessException {
        try {
            long time = System.currentTimeMillis();
            this.logger.debug((Object)("Compiling File: file:" + input.getAbsolutePath()));
            String result = this.call(this.compileFile, new Object[]{"file:" + input.getAbsolutePath(), this.classLoader, compress});
            this.logger.debug((Object)("The compilation of '" + input + "' took " + (System.currentTimeMillis() - time) + " ms."));
            return result;
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    public void compile(File input, File output) throws LessException, IOException {
        this.compile(input, output, false);
    }

    public void compile(File input, File output, boolean compress) throws LessException, IOException {
        try {
            String content = this.compile(input, compress);
            if (!output.exists()) {
                output.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(output));
            bw.write(content);
            bw.close();
        }
        catch (Exception e) {
            throw this.parseLessException(e);
        }
    }

    private synchronized String call(Function fn, Object[] args) {
        return (String)Context.call(null, (Callable)fn, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])args);
    }

    private LessException parseLessException(Exception root) throws LessException {
        this.logger.debug((Object)"Parsing LESS Exception", (Throwable)root);
        if (root instanceof JavaScriptException) {
            Scriptable value = (Scriptable)((JavaScriptException)root).getValue();
            String type = (String)ScriptableObject.getProperty((Scriptable)value, (String)"type") + " Error";
            String message = (String)ScriptableObject.getProperty((Scriptable)value, (String)"message");
            String filename = "";
            if (ScriptableObject.hasProperty((Scriptable)value, (String)"filename")) {
                filename = (String)ScriptableObject.getProperty((Scriptable)value, (String)"filename");
            }
            int line = -1;
            if (ScriptableObject.hasProperty((Scriptable)value, (String)"line")) {
                line = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"line")).intValue();
            }
            int column = -1;
            if (ScriptableObject.hasProperty((Scriptable)value, (String)"column")) {
                column = ((Double)ScriptableObject.getProperty((Scriptable)value, (String)"column")).intValue();
            }
            ArrayList<String> extractList = new ArrayList<String>();
            if (ScriptableObject.hasProperty((Scriptable)value, (String)"extract")) {
                NativeArray extract = (NativeArray)ScriptableObject.getProperty((Scriptable)value, (String)"extract");
                int i = 0;
                while ((long)i < extract.getLength()) {
                    if (extract.get(i, (Scriptable)extract) instanceof String) {
                        extractList.add(((String)extract.get(i, (Scriptable)extract)).replace("\t", " "));
                    }
                    ++i;
                }
            }
            throw new LessException(message, type, filename, line, column, extractList);
        }
        throw new LessException(root);
    }
}

