/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AttributeList {
    private List entryList = new ArrayList();

    public Iterator keys() {
        return new AttributeIterator(this.entryList.iterator());
    }

    public synchronized void setAttribute(String name, String value) {
        AttributeEntry entry = new AttributeEntry(name, value);
        int pos = this.entryList.indexOf(entry);
        if (pos != -1) {
            this.entryList.remove(pos);
        }
        this.entryList.add(entry);
    }

    public synchronized String getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public synchronized String getAttribute(String name, String defaultValue) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)this.entryList.get(i);
            if (!ae.getName().equals(name)) continue;
            return ae.getValue();
        }
        return defaultValue;
    }

    public synchronized void removeAttribute(String name) {
        for (int i = 0; i < this.entryList.size(); ++i) {
            AttributeEntry ae = (AttributeEntry)this.entryList.get(i);
            if (!ae.getName().equals(name)) continue;
            this.entryList.remove(ae);
            return;
        }
    }

    private static class AttributeIterator
    implements Iterator {
        private Iterator backend;

        public AttributeIterator(Iterator backend) {
            if (backend == null) {
                throw new NullPointerException();
            }
            this.backend = backend;
        }

        @Override
        public boolean hasNext() {
            return this.backend.hasNext();
        }

        public Object next() {
            AttributeEntry entry = (AttributeEntry)this.backend.next();
            if (entry != null) {
                return entry.getName();
            }
            return entry;
        }

        @Override
        public void remove() {
            this.backend.remove();
        }
    }

    private static class AttributeEntry {
        private String name;
        private String value;

        public AttributeEntry(String name, String value) {
            if (name == null) {
                throw new NullPointerException("Name must not be null. [" + name + ", " + value + "]");
            }
            if (value == null) {
                throw new NullPointerException("Value must not be null. [" + name + ", " + value + "]");
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeEntry)) {
                return false;
            }
            AttributeEntry attributeEntry = (AttributeEntry)o;
            return this.name.equals(attributeEntry.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

