/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.jfree.util.ObjectUtilities;
import org.jfree.xml.ElementDefinitionException;
import org.jfree.xml.FrontendDefaultHandler;
import org.jfree.xml.ParseException;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.jfree.xml.parser.coretypes.BasicStrokeReadHandler;
import org.jfree.xml.parser.coretypes.ColorReadHandler;
import org.jfree.xml.parser.coretypes.FontReadHandler;
import org.jfree.xml.parser.coretypes.GenericReadHandler;
import org.jfree.xml.parser.coretypes.GradientPaintReadHandler;
import org.jfree.xml.parser.coretypes.InsetsReadHandler;
import org.jfree.xml.parser.coretypes.ListReadHandler;
import org.jfree.xml.parser.coretypes.Point2DReadHandler;
import org.jfree.xml.parser.coretypes.Rectangle2DReadHandler;
import org.jfree.xml.parser.coretypes.RenderingHintsReadHandler;
import org.jfree.xml.parser.coretypes.StringReadHandler;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.MultiplexMappingEntry;
import org.jfree.xml.util.ObjectFactory;
import org.jfree.xml.util.SimpleObjectFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class RootXmlReadHandler
extends FrontendDefaultHandler {
    private Stack currentHandlers;
    private Stack outerScopes;
    private XmlReadHandler rootHandler;
    private HashMap objectRegistry = new HashMap();
    private SimpleObjectFactory classToHandlerMapping = new SimpleObjectFactory();
    private boolean rootHandlerInitialized;

    protected void addDefaultMappings() {
        MultiplexMappingEntry[] paintEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("color", Color.class.getName()), new MultiplexMappingEntry("gradientPaint", GradientPaint.class.getName())};
        this.addMultiplexMapping(Paint.class, "type", paintEntries);
        this.addManualMapping(Color.class, ColorReadHandler.class);
        this.addManualMapping(GradientPaint.class, GradientPaintReadHandler.class);
        MultiplexMappingEntry[] point2DEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Point2D.Float.class.getName()), new MultiplexMappingEntry("double", Point2D.Double.class.getName())};
        this.addMultiplexMapping(Point2D.class, "type", point2DEntries);
        this.addManualMapping(Point2D.Float.class, Point2DReadHandler.class);
        this.addManualMapping(Point2D.Double.class, Point2DReadHandler.class);
        MultiplexMappingEntry[] rectangle2DEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("float", Rectangle2D.Float.class.getName()), new MultiplexMappingEntry("double", Rectangle2D.Double.class.getName())};
        this.addMultiplexMapping(Rectangle2D.class, "type", rectangle2DEntries);
        this.addManualMapping(Rectangle2D.Float.class, Rectangle2DReadHandler.class);
        this.addManualMapping(Rectangle2D.Double.class, Rectangle2DReadHandler.class);
        MultiplexMappingEntry[] listEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("array-list", ArrayList.class.getName()), new MultiplexMappingEntry("linked-list", LinkedList.class.getName()), new MultiplexMappingEntry("vector", Vector.class.getName()), new MultiplexMappingEntry("stack", Stack.class.getName())};
        this.addMultiplexMapping(List.class, "type", listEntries);
        this.addManualMapping(LinkedList.class, ListReadHandler.class);
        this.addManualMapping(Vector.class, ListReadHandler.class);
        this.addManualMapping(ArrayList.class, ListReadHandler.class);
        this.addManualMapping(Stack.class, ListReadHandler.class);
        MultiplexMappingEntry[] strokeEntries = new MultiplexMappingEntry[]{new MultiplexMappingEntry("basic", BasicStroke.class.getName())};
        this.addMultiplexMapping(Stroke.class, "type", strokeEntries);
        this.addManualMapping(BasicStroke.class, BasicStrokeReadHandler.class);
        this.addManualMapping(Font.class, FontReadHandler.class);
        this.addManualMapping(Insets.class, InsetsReadHandler.class);
        this.addManualMapping(RenderingHints.class, RenderingHintsReadHandler.class);
        this.addManualMapping(String.class, StringReadHandler.class);
    }

    public abstract ObjectFactory getFactoryLoader();

    protected void addManualMapping(Class classToRead, Class handler) {
        if (handler == null) {
            throw new NullPointerException("handler must not be null.");
        }
        if (classToRead == null) {
            throw new NullPointerException("classToRead must not be null.");
        }
        if (!XmlReadHandler.class.isAssignableFrom(handler)) {
            throw new IllegalArgumentException("The given handler is no XmlReadHandler.");
        }
        this.classToHandlerMapping.addManualMapping(new ManualMappingDefinition(classToRead, handler.getName(), null));
    }

    protected void addMultiplexMapping(Class baseClass, String typeAttr, MultiplexMappingEntry[] mdef) {
        this.classToHandlerMapping.addMultiplexMapping(new MultiplexMappingDefinition(baseClass, typeAttr, mdef));
    }

    public void setHelperObject(String key, Object value) {
        if (value == null) {
            this.objectRegistry.remove(key);
        } else {
            this.objectRegistry.put(key, value);
        }
    }

    public Object getHelperObject(String key) {
        return this.objectRegistry.get(key);
    }

    public XmlReadHandler createHandler(Class classToRead, String tagName, Attributes atts) throws XmlReaderException {
        XmlReadHandler retval = this.findHandlerForClass(classToRead, atts, new ArrayList());
        if (retval == null) {
            throw new NullPointerException("Unable to find handler for class: " + classToRead);
        }
        retval.init(this, tagName);
        return retval;
    }

    private XmlReadHandler findHandlerForClass(Class classToRead, Attributes atts, ArrayList history) throws XmlReaderException {
        ObjectFactory genericFactory = this.getFactoryLoader();
        if (history.contains(classToRead)) {
            throw new IllegalStateException("Circular reference detected: " + history);
        }
        history.add(classToRead);
        ManualMappingDefinition manualDefinition = this.classToHandlerMapping.getManualMappingDefinition(classToRead);
        if (manualDefinition == null) {
            manualDefinition = genericFactory.getManualMappingDefinition(classToRead);
        }
        if (manualDefinition != null) {
            return this.loadHandlerClass(manualDefinition.getReadHandler());
        }
        MultiplexMappingDefinition mplex = this.getFactoryLoader().getMultiplexDefinition(classToRead);
        if (mplex == null) {
            mplex = this.classToHandlerMapping.getMultiplexDefinition(classToRead);
        }
        if (mplex != null) {
            String attributeValue = atts.getValue(mplex.getAttributeName());
            if (attributeValue == null) {
                throw new XmlReaderException("Multiplexer type attribute is not defined: " + mplex.getAttributeName() + " for " + classToRead);
            }
            MultiplexMappingEntry entry = mplex.getEntryForType(attributeValue);
            if (entry == null) {
                throw new XmlReaderException("Invalid type attribute value: " + mplex.getAttributeName() + " = " + attributeValue);
            }
            Class c = this.loadClass(entry.getTargetClass());
            if (!c.equals(mplex.getBaseClass())) {
                return this.findHandlerForClass(c, atts, history);
            }
        }
        if (this.classToHandlerMapping.isGenericHandler(classToRead)) {
            return new GenericReadHandler(this.classToHandlerMapping.getFactoryForClass(classToRead));
        }
        if (this.getFactoryLoader().isGenericHandler(classToRead)) {
            return new GenericReadHandler(this.getFactoryLoader().getFactoryForClass(classToRead));
        }
        return null;
    }

    protected void setRootHandler(XmlReadHandler handler) {
        this.rootHandler = handler;
        this.rootHandlerInitialized = false;
    }

    protected XmlReadHandler getRootHandler() {
        return this.rootHandler;
    }

    public void recurse(XmlReadHandler handler, String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        this.outerScopes.push(this.currentHandlers);
        this.currentHandlers = new Stack();
        this.currentHandlers.push(handler);
        handler.startElement(tagName, attrs);
    }

    public void delegate(XmlReadHandler handler, String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        this.currentHandlers.push(handler);
        handler.init(this, tagName);
        handler.startElement(tagName, attrs);
    }

    public void unwind(String tagName) throws SAXException, XmlReaderException {
        this.currentHandlers.pop();
        if (this.currentHandlers.isEmpty() && !this.outerScopes.isEmpty()) {
            this.currentHandlers = (Stack)this.outerScopes.pop();
        } else if (!this.currentHandlers.isEmpty()) {
            this.getCurrentHandler().endElement(tagName);
        }
    }

    protected XmlReadHandler getCurrentHandler() {
        return (XmlReadHandler)this.currentHandlers.peek();
    }

    @Override
    public void startDocument() throws SAXException {
        this.outerScopes = new Stack();
        this.currentHandlers = new Stack();
        this.currentHandlers.push(this.rootHandler);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.rootHandlerInitialized) {
            this.rootHandler.init(this, qName);
            this.rootHandlerInitialized = true;
        }
        try {
            this.getCurrentHandler().startElement(qName, attributes);
        }
        catch (XmlReaderException xre) {
            throw new ParseException((Exception)((Object)xre), this.getLocator());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getCurrentHandler().characters(ch, start, length);
        }
        catch (SAXException se) {
            throw se;
        }
        catch (Exception e) {
            throw new ParseException(e, this.getLocator());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.getCurrentHandler().endElement(qName);
        }
        catch (XmlReaderException xre) {
            throw new ParseException((Exception)((Object)xre), this.getLocator());
        }
    }

    protected XmlReadHandler loadHandlerClass(String className) throws XmlReaderException {
        try {
            Class c = this.loadClass(className);
            return (XmlReadHandler)c.newInstance();
        }
        catch (Exception e) {
            throw new XmlReaderException("LoadHanderClass: Unable to instantiate " + className, e);
        }
    }

    protected Class loadClass(String className) throws XmlReaderException {
        if (className == null) {
            throw new XmlReaderException("LoadHanderClass: Class name not defined");
        }
        try {
            Class<?> c = ObjectUtilities.getClassLoader(this.getClass()).loadClass(className);
            return c;
        }
        catch (Exception e) {
            throw new XmlReaderException("LoadHanderClass: Unable to load " + className, e);
        }
    }

    @Override
    public Object getResult() throws SAXException {
        if (this.rootHandler != null) {
            try {
                return this.rootHandler.getObject();
            }
            catch (XmlReaderException e) {
                throw new ElementDefinitionException((Exception)((Object)e));
            }
        }
        return null;
    }
}

