/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.parser;

import org.jfree.util.Log;
import org.jfree.xml.parser.RootXmlReadHandler;
import org.jfree.xml.parser.XmlReadHandler;
import org.jfree.xml.parser.XmlReaderException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class AbstractXmlReadHandler
implements XmlReadHandler {
    private RootXmlReadHandler rootHandler;
    private String tagName;
    private boolean firstCall = true;

    @Override
    public void init(RootXmlReadHandler rootHandler, String tagName) {
        if (rootHandler == null) {
            throw new NullPointerException("Root handler must not be null");
        }
        if (tagName == null) {
            throw new NullPointerException("Tag name must not be null");
        }
        this.rootHandler = rootHandler;
        this.tagName = tagName;
    }

    @Override
    public final void startElement(String tagName, Attributes attrs) throws XmlReaderException, SAXException {
        if (this.firstCall) {
            if (!this.tagName.equals(tagName)) {
                throw new SAXException("Expected <" + this.tagName + ">, found <" + tagName + ">");
            }
            this.firstCall = false;
            this.startParsing(attrs);
        } else {
            XmlReadHandler childHandler = this.getHandlerForChild(tagName, attrs);
            if (childHandler == null) {
                Log.warn((Object)("Unknown tag <" + tagName + ">"));
                return;
            }
            childHandler.init(this.getRootHandler(), tagName);
            this.rootHandler.recurse(childHandler, tagName, attrs);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public final void endElement(String tagName) throws SAXException {
        if (this.tagName.equals(tagName)) {
            try {
                this.doneParsing();
                this.rootHandler.unwind(tagName);
            }
            catch (XmlReaderException xre) {
                throw new SAXException((Exception)((Object)xre));
            }
        }
    }

    protected void startParsing(Attributes attrs) throws SAXException, XmlReaderException {
    }

    protected void doneParsing() throws SAXException, XmlReaderException {
    }

    protected XmlReadHandler getHandlerForChild(String tagName, Attributes atts) throws XmlReaderException, SAXException {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public RootXmlReadHandler getRootHandler() {
        return this.rootHandler;
    }
}

