/*
 * This file is subject to the licence found in LICENCE.TXT in the root directory of the project.
 * Copyright Jayasoft 2005 - All rights reserved
 * 
 * version 1.3.1
 */
package fr.jayasoft.ivy.repository;

import fr.jayasoft.ivy.util.CopyProgressEvent;
import fr.jayasoft.ivy.util.CopyProgressListener;

public class RepositoryCopyProgressListener implements CopyProgressListener {
    private final AbstractRepository _repository;

    public RepositoryCopyProgressListener(AbstractRepository repository) {
        _repository = repository;
    }

    private Long _totalLength = null;
    public void start(CopyProgressEvent evt) {
        if (_totalLength != null) {
            _repository.fireTransferStarted(_totalLength.longValue());
        } else {
            _repository.fireTransferStarted();
        }
    }

    public void progress(CopyProgressEvent evt) {
        _repository.fireTransferProgress(evt.getBuffer(), evt.getReadBytes());
    }

    public void end(CopyProgressEvent evt) {
        _repository.fireTransferCompleted(evt.getBuffer(), evt.getReadBytes());
    }

    public Long getTotalLength() {
        return _totalLength;
    }

    public void setTotalLength(Long totalLength) {
        _totalLength = totalLength;
    }
}