#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "main.h"
#include "game.h"
#include "menu.h"
#include "config.h"
#include "gfx.h"
#include "scroller.h"

#ifdef ALLEGRO_WINDOWS
#define CHAR CHARblablabla
#include <winalleg.h>
#undef CHAR
#endif

#ifdef ALLEGRO_LINUX
#include <sys/time.h>
#endif

int frames;
int fps;
BITMAP *page;
int show_fps = 0;

int fullscreen;
int colordepth;
int joy_ok;

int USE_DRS = 1;

static int quit = 0;

static volatile int ticks = 0;
static void
ticker (void)
{
	ticks++;
}
END_OF_FUNCTION (ticker)

   
#define MRAND_MAX 0xFFFF
unsigned int mrand_seed;

static int
mrand (void)
{
    mrand_seed = (mrand_seed + 1) * 1103515245 + 12345;
    return (mrand_seed >> 16) % (MRAND_MAX + 1);
}

int rnd (int min, int max)
{
	return min + ((max - min) * ((float) mrand () / (float) MRAND_MAX) + 0.5);
}

static int oldkeys[KEY_MAX];

static void
display_switch (void)
{
	menu_alt_tab ();
	game_alt_tab ();
}

void
fix_alt_tab (void)
{
	#if !(defined(ALLEGRO_MSVC) && defined(_DEBUG))
		if (set_display_switch_mode (SWITCH_BACKGROUND))
			set_display_switch_mode (SWITCH_BACKAMNESIA);
			set_display_switch_callback (SWITCH_IN, display_switch);
	#endif
}

int
check_key_ex (int k, int fast)
{
	int joy_key=0;

	if (oldkeys[k])
		oldkeys[k]--;

	if(joy_ok)
	{
		switch(k)
		{
			case KEY_ENTER:
				joy_key=joy[0].button[0].b;
				break;

			case KEY_LEFT:
				joy_key=joy[0].stick[0].axis[0].d1;
				break;

			case KEY_RIGHT:
				joy_key=joy[0].stick[0].axis[0].d2;
				break;

			case KEY_UP:
				joy_key=joy[0].stick[0].axis[1].d1;
				break;

			case KEY_DOWN:
				joy_key=joy[0].stick[0].axis[1].d2;
				break;
		}
	}


	if (key[k] || joy_key)
	{
		if (!oldkeys[k] || fast)
		{
			oldkeys[k] = FPS;
			return 1;
		}
	}
	else
	{
		oldkeys[k] = 0;
	}
	return 0;
}


int check_key(int k)
{
	return check_key_ex(k, FALSE);
}


static int
run_init (void)
{
	DATAFILE *fontdata = load_datafile ("gfx/sword.dat");

	if (!fontdata)
	{
		printf ("Could not load font.\n");
		return 1;
	}
	font = fontdata[0].dat;
	if (game_init ())
		return 1;
	
	if (quest_number)
		game_load (quest_number);
	
	menu_init ();	
	return 0;
}

void
run_exit (void)
{
	quit = 1;
}

static void
run_frame (void)
{
	poll_joystick();

	while (keypressed ())
	{
		int k = readkey ();
		
		k >>= 8;
		if (k == KEY_ESC)
		{
			if (scroller_active)
			{
				scroller_exit ();
				menu_init ();
				menu_active = 1;
			}
			else
			if (menu_active)
			{
				menu_active = 0;
				game_continue ();
			}
			else
			{
				menu_init ();
				menu_active = 1;
			}
		}
	}
	if (scroller_active)
		scroller_frame ();
	else
	if (menu_active)
		menu_run ();
	else
		game_frame ();
}

static void
run_render (void)
{
	if (scroller_active)
		scroller_render ();
	else
	if (menu_active)
		menu_render ();
	else
		game_render ();

	if (show_fps)
	{
		text_mode (0);
		textprintf_right (screen, font, SCREEN_W, 0, makecol (255, 255, 255), "%d fps", fps);
	}
}

static int
scan_int_arg (int argc, char *argv[], const char *arg, int def)
{
	int i;

	for (i = 1; i < argc; i++)
	{
		if (!strcmp (argv[i], arg))
		{
			i++;
			if (i < argc)
			{
				return strtol (argv[i], NULL, 0);
			}
		}
	}
	return def;
}


static void
close_button (void)
{
	quit = 1;
}

extern int _mangled_main (int, char **);
int
main (int argc, char *argv[])
{
	int gframes;
	int framecounttime, framecounter;
	
	if (scan_int_arg (argc, argv, "-monsterstats", 0) == 1)
	{
		int t, i;
		TYPE grid[100][CHAR_NUM];
		int h[4][100]; /* min, avg, max, player_avg */
		int s[4][100];
		int lev_avg[100];
		memset (&grid, 0, sizeof grid);
		memset (&h, 0, sizeof h);
		memset (&s, 0, sizeof s);
		memset (&lev_avg, 0, sizeof lev_avg);
		/* Run 1000 games. */
		for (t = 0; t < 1000; t++)
		{
			int ph, ps;
			char_num = 2;
			list[1].alive = 0;
			/* Create test player. */
			player_roll (&ph, &ps);
			player_create (0, 0, ph, ps);
			list[1].lev = 1;
			for (i = 0; i < 100; i++)
			{
				int m;
				list[1].current_level = i;
				/* Create 8 monsters in level i, and slay them. */
				for (m = 0; m < 8; m++)
				{
					int r = rnd (1, 2);
					list[2].alive = 0;
					char_num = 2;
					char_create (0, 0);
					if (r == 1) monster_human_create (2, i);
					if (r == 2) monster_creature_create (2, i);
					grid[i][list[2].type]++;
					h[1][i] += list[2].hit;
					if (t == 0 || list[2].hit < h[0][i])
						h[0][i] = list[2].hit;
					if (t == 0 || list[2].hit > h[2][i])
						h[2][i] = list[2].hit;
					
					s[1][i] += list[2].dex;
					if (t == 0 || list[2].dex < s[0][i])
						s[0][i] = list[2].dex;
					if (t == 0 || list[2].dex > s[2][i])
						s[2][i] = list[2].dex;
					
					list[1].fighting = 2;
					player_won (1);
					player_try_levelup (1);
				}
				h[3][i] += list[1].maxhit;
				s[3][i] += list[1].dex;
				lev_avg[i] += list[1].lev;
			}
			fprintf (stderr, ".");
		}

		printf ("      Hitpoints        Skill            Player                 Types\n");
		printf ("Lev | Min Avg    Max | Min Avg    Max | Health Skill  Level  | %%\n");
		for (i = 0; i < 100; i++)
		{
			int j;
			printf ("%3i | %3i %6.1f %3i | %3i %6.1f %3i | %6.1f %6.1f %6.1f | ",
				i, h[0][i], (float)h[1][i] / 8000.0, h[2][i],
				s[0][i], (float)s[1][i] / 8000.0, s[2][i],
				(float) h[3][i] / 1000.0, (float) s[3][i] / 1000.0,
				(float) lev_avg[i] / 1000.0);
			for (j = 0; j < CHAR_NUM; j++)
			{
				int p = grid[i][j] / 80;
				if (p)
				{
					printf ("%i%%%c%c%c ", p,
						char_names[j][0], char_names[j][1], char_names[j][2]);
				}
			}
			printf ("\n");
		}
		
		exit (0);
	}

	allegro_init ();

	srand ((unsigned) time (NULL));

	load_settings ();
	
	/* TODO: all into the config system.. */
	show_fps = scan_int_arg (argc, argv, "-s", show_fps);

	USE_DRS = 1;

#define WINDOWED_MODE GFX_AUTODETECT_WINDOWED


#ifdef ALLEGRO_MSVC
#ifdef _DEBUG
#undef WINDOWED_MODE
#define WINDOWED_MODE GFX_GDI
USE_DRS = 0;
#endif
#endif

	set_color_depth (colordepth);
	if (set_gfx_mode (fullscreen ? GFX_AUTODETECT_FULLSCREEN : WINDOWED_MODE, 640, 480, 0, 0) < 0)
	{
		allegro_message ("Cannot set graphics mode.\n");
		exit (-1);
	}

	fix_alt_tab ();	

	#if (ALLEGRO_SUB_VERSION == 0)
		set_window_close_button (1);
		set_window_close_hook (close_button);
	#else
		set_close_button_callback (close_button);
	#endif
	
	if (colordepth == 8)
	{
		PALETTE pal;
		rgb_map = malloc (sizeof *rgb_map);
		generate_332_palette (pal);
		memset (&pal[0], 0, sizeof pal[0]);
		create_rgb_table (rgb_map, pal, NULL);
		set_palette (pal);
	}
	set_color_conversion (COLORCONV_TOTAL | COLORCONV_KEEP_TRANS);

	install_keyboard ();

	joy_ok=(!install_joystick(JOY_TYPE_AUTODETECT) && num_joysticks);

	install_timer ();

	LOCK_FUNCTION (ticker);
	LOCK_VARIABLE (ticks);

	install_int_ex (ticker, BPS_TO_TIMER (FPS));

	install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL);

	page = create_bitmap (SCREEN_W, SCREEN_H);

	override_config_file ("data/settings.cfg");
	if (!get_config_int ("SOF", "agreement", 0))
	{
		char *agreement;
		int w = SCREEN_W / 2;
		int h = 2 * SCREEN_H / 3;
		int a;
		DIALOG d[] =
		{
			{d_shadow_box_proc, 0, 0, w - 20, h - 20,
				0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
			{d_textbox_proc, 10, 10, w - 40, h - 80,
				0, 0, 0, 0, 0, 0, NULL, NULL, NULL},
			{d_button_proc, 10, h - 40, 80, 12,
				0, 0, 27, D_EXIT, 0, 0, (void *)"Exit", NULL, NULL},
			{d_button_proc, w - 30 - 80, h - 40, 80, 12,
				0, 0, 13, D_EXIT, 0, 0, (void *)"Agree", NULL, NULL},
			{NULL, 0, 0, 0, 0,
				0, 0, 0, 0, 0, 0, NULL, NULL, NULL}
		};
		install_mouse ();
		set_dialog_color (d, makecol (0, 0, 0), makecol (250, 240, 190));
		d[0].bg = makecol (200, 190, 180);
		centre_dialog (d);
		
		{
			int s = file_size ("agreement.txt");
			PACKFILE *file = pack_fopen ("agreement.txt", "r");
			agreement = calloc (1 + s, 1);
			pack_fread (agreement, s, file);
			pack_fclose (file);
		}
		d[1].dp = agreement;
		
		a = do_dialog (d, 2);

		free (agreement);
		
		if (a != 3)
			exit (0);
		
		set_config_file ("data/settings.cfg");
		set_config_int ("SOF", "agreement", 1);
	}

	if (run_init ())
	{
		allegro_message ("Data could not be found. Please check your installation.");
		return 1;
	}

	framecounter = 0;
	framecounttime = ticks;
	gframes = ticks;
	frames = ticks;
	while (!quit)
	{
		while (frames <= ticks)
		{
			run_frame ();
			frames++;
		}
		if (gframes < frames)
		{
			run_render ();

			gframes = frames;
			framecounter++;

			if (ticks - framecounttime >= FPS)
			{
				fps = framecounter;
				framecounter = 0;
				framecounttime = ticks;
			}

		}
		#ifdef ALLEGRO_WINDOWS
			Sleep (1);
		#endif
		#ifdef ALLEGRO_UNIX
		{
			/* This way we use 0% CPU in linux. */
			struct timeval timeval = {0, 1};
			select (0, NULL, NULL, NULL, &timeval);
		}
		#endif
	}

	remove ("data/last.log");
	save_settings ();
	
	run_exit ();
	return 0;
}

END_OF_MAIN ()
