#include "char.h"
#include "map.h"
#include "game.h"
#include "gfx.h"

CHAR list[MAX_CHARS];
int char_num = 1;

/* Moving:

   main loop -> player_process(), monster_process()
                             |      |
						    char_move()
                                |
                               / \
						   step	  dx || dy 
						    |        |
		   when step gets 0 |        |
              change_position()    leave(), encounter()

*/

/* C64: data
455 dataa,dire wolf,31,a,rogue,42
456 dataan,ogre,27,a,barbarian,41,a,hobgoblin,27,an,elvin ranger,41,a,werebear,27
457 dataa,dwarven guard,43,a,gargoyle,28,a,mercenary,41,a,troll,27,a,swordsman,41
458 dataa,wyvern,30,a,monk,41,a,dimension spider,29,a,dark warrior,41,a,shadow dragon,30
459 dataan,assassin,40,a,fyre drake,30,a,war lord,41
*/

char const *char_names[CHAR_NUM] = {
	"you",
	"Rogue",
	"Barbarian",
	"Elvin Ranger",
	"Dwarven Guard",
	"Mercenary",
	"Swordsman",
	"Monk",
	"Dark Warrior",
	"Assassin",
	"War Lord",
	"Dire Wolf",
	"Ogre",
	"Hobgoblin",
	"Werebear",
	"Gargoyle",
	"Troll",
	"Wyvern",
	"Dimension Spider",
	"Shadow Dragon",
	"Fyre Drake"
};

char const *char_prefixes[CHAR_NUM][3] = {
	{"", "", ""},
	{"a", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"an", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"an", "an inferior", "an experienced"},
	{"a", "an inferior", "an experienced"},
	{"a", "a weak", "a powerful"},
	{"an", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"},
	{"a", "a weak", "a powerful"}
};

void
chars_init (void)
{
	
}

int
char_create (int x, int y)
{
	int id;

	if (char_num == MAX_CHARS)
		return 0;

	for (id = 1; id < char_num; id++)
	{
		if (!list[id].alive)
			break;
	}
	if (id == MAX_CHARS)
		return 0;
	if (id == char_num)
		char_num++;
	
	memset (&list[id], 0, sizeof list[id]);
	
	list[id].x = x;
	list[id].y = y;
	list[id].alive = 1;

	return id;
}

/**
 * Called by char_move when a character encounters another one.
 */
static int
encounter (int id, int who)
{
	if (who == 1 && map_get_spot (list[who].x, list[who].y) != SPOT_TEMPLE &&
		map_get_spot (list[who].x, list[who].y) != SPOT_BEACON/* &&
		!list[who].step*/)
	{
		if (!list[who].fighting && list[who].alive)
		{
			list[id].fighting = who;
			list[who].fighting = id;
			list[who].attacked = 1;
			message (FPS * 2, attack, "Attacked by %s %s!",
				char_prefixes[list[id].type][list[id].subtype],
				char_names[list[id].type]);
			return 1;
		}
	}
	if (id == 1)
	{
		if (!list[id].fighting)
		{
			list[id].fighting = who;
			list[who].fighting = id;
			list[who].attacked = 1;
			message (FPS * 2, fight, "%c%s %s!",
				toupper (char_prefixes[list[who].type][list[who].subtype][0]),
				char_prefixes[list[who].type][list[who].subtype] + 1,
				char_names[list[who].type]);
			return 1;
		}
	}
	return 0;
}

/**
 * Called by char_move whenever a character leaves his current position.
 */
static void
leave (int id)
{		
	if (id == 1)
	{
		player_leave (id);
	}
}

/**
 * Called by char_move whenever a character changes to a new position.
 */
static void
change_position (int id)
{
	if (id == 1)
		player_change_position (id);
	else
		monster_change_position (id);
}

/**
 * Returns 0 if the character may not enter the given map position.
 */
static int
may_walk (int id, int x, int y)
{
	if (id == 1 && !list[id].attacked && map_get_spot (x, y) != SPOT_WALL)
		return 1;
	if (id > 1 && map_get_spot (x, y) != SPOT_WALL)
		return 1;
	return 0;
}

/**
 * Processes movement of a character. If its is still moving, dx and dy are
 * ignored. Else, the character tries to move in the given direction.
 *
 * Returns 1 if a move is initiated
 **/
int
char_move (int id, int dx, int dy)
{
	int x = list[id].x;
	int y = list[id].y;

	if (!list[id].alive)
		return 0;

	if (list[id].step)
	{
		int overlap;
		
		overlap = (sprite_h + th - 1) / th - 1;
		list[id].step--;

		DR_add (x - 1 - 1, y - overlap - 1, x + 1 + 1, y + 1);

		if (!list[id].step)
			change_position (id);
	}
	else if (dx || dy)
	{
		int ok = 0;
		int ox, oy;

		ox = x;
		oy = y;

		if (may_walk (id, x + dx, y + dy))
			ok = 1;
		else if (dx && dy)
		{
			if (may_walk (id, x, y + dy))
			{
				ok = 1;
				dx = 0;
			}
			else if (may_walk (id, x + dx, y))
			{
				ok = 1;
				dy = 0;
			}
		}

		if (ok)
		{
			int e = map_get_char (x + dx, y + dy);
			int go = 0;
			if (e == 0)
			{
				e=list[id].fighting;
				cancel_fighting (id);
				if(!e)
					go = 1;
				else
					go = 2;
			}
			else
			{
				if (extensions_overlapfight)
				{
					encounter (id, e);
					return 0;
				}
				else
				{
					int player_involved = (id == 1 || (e == 1 && !list[e].fighting));				
					if (player_involved)
					{
						cancel_fighting (id);
						if (encounter (id, e))
							go = 1;	
					}
				}
			}
			
			if (go)
			{	
				if(go==2 && !extensions_overlapfight)
					map_put_char (x, y, e);
				else
					map_put_char (x, y, 0);

				leave (id);

				x += dx;
				y += dy;

				list[id].dx = dx;
				list[id].dy = dy;
				list[id].step = get_steptime();
				list[id].x = x;
				list[id].y = y;

				map_put_char (x, y, id);
			}
		}
		else
		{
			return 0;
		}

		return 1;
	}
	return 0;
}

void
char_transfer_to (int id, int x, int y)
{	
	list[id].step = 0;
	
	map_put_char (list[id].x, list[id].y, 0);					
	cancel_fighting (id);
	
	leave (id);

	list[id].x = x;
	list[id].y = y;
	map_put_char (x, y, id);
	
	change_position (id);
}

int
char_teleport (int id)
{
	int x = list[id].beaconx;
	int y = list[id].beacony;	

	if ((!x || !y) || list[1].trapped)
		do
		{
			x = rnd (1, MAP_W - 2);
			y = rnd (1, MAP_H - 2);
		}
		while (map_get_spot (x, y) != SPOT_FLOOR || map_get_char (x, y));

	char_transfer_to (id, x, y);
	return 1;
}
