/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.CryptixException;
import cryptix.provider.rsa.RSAAlgorithm;
import cryptix.util.core.Debug;
import cryptix.util.core.Hex;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public abstract class Any_RSA_PKCS1Signature
extends Signature {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "Any_RSA_PKCS1Signature");
    private static final PrintWriter err = Debug.getOutput();
    private static final int POSITIVE = 1;
    private static final BigInteger ZERO = BigInteger.valueOf(0L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private BigInteger n;
    private BigInteger exp;
    private BigInteger p;
    private BigInteger q;
    private BigInteger u;
    private MessageDigest md;

    private static void debug(String string) {
        err.println("Any_RSA_PKCS1Signature: " + string);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not an RSA private key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)privateKey;
        this.n = cryptixRSAPrivateKey.getModulus();
        this.exp = cryptixRSAPrivateKey.getExponent();
        if (privateKey instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)privateKey);
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
        this.md.reset();
        int n = this.md.digest().length;
        int n2 = (this.n.bitLength() + 7) / 8;
        int n3 = this.getAlgorithmEncoding().length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new InvalidKeyException("Signer's public key modulus too short.");
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not an RSA public key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)publicKey;
        this.n = cryptixRSAPublicKey.getModulus();
        this.exp = cryptixRSAPublicKey.getExponent();
        if (publicKey instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)publicKey);
            this.p = rSAFactors.getP();
            this.q = rSAFactors.getQ();
            this.u = rSAFactors.getInverseOfQModP();
        }
        this.md.reset();
        int n = this.md.digest().length;
        int n2 = (this.n.bitLength() + 7) / 8;
        int n3 = this.getAlgorithmEncoding().length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new InvalidKeyException("Signer's public key modulus too short.");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.md.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.md.update(byArray, n, n2);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for signing");
        }
        long l = 0L;
        if (debuglevel >= 7) {
            l = System.currentTimeMillis();
        }
        BigInteger bigInteger = this.makePKCS1();
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
        if (debuglevel >= 7) {
            l = System.currentTimeMillis() - l;
            Any_RSA_PKCS1Signature.debug(" ...engineSign() completed in " + l + " ms.");
        }
        return bigInteger2.toByteArray();
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for verification");
        }
        long l = 0L;
        if (debuglevel >= 7) {
            l = System.currentTimeMillis();
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = RSAAlgorithm.rsa(bigInteger, this.n, this.exp, this.p, this.q, this.u);
        BigInteger bigInteger3 = this.makePKCS1();
        boolean bl = bigInteger2.equals(bigInteger3);
        if (debuglevel >= 7) {
            l = System.currentTimeMillis() - l;
            Any_RSA_PKCS1Signature.debug(" ...engineVerify() completed in " + l + " ms.");
            if (!bl) {
                Any_RSA_PKCS1Signature.debug("   Computed: " + Hex.dumpString(bigInteger2.toByteArray()));
                Any_RSA_PKCS1Signature.debug("     Actual: " + Hex.dumpString(bigInteger3.toByteArray()));
            }
        }
        return bl;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": " + string);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": " + string);
    }

    private BigInteger makePKCS1() throws SignatureException {
        byte[] byArray = this.md.digest();
        int n = byArray.length;
        int n2 = (this.n.bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n2];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n3 = byArray3.length;
        int n4 = n2 - 3 - n3 - n;
        if (n4 < 0) {
            throw new SignatureException("Signer's public key modulus too short.");
        }
        int n5 = 0;
        while (n5 < n4) {
            byArray2[2 + n5++] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n4 + 3, n3);
        System.arraycopy(byArray, 0, byArray2, n2 - n, n);
        if (debuglevel >= 4) {
            Any_RSA_PKCS1Signature.debug("PKCS#1 frame = " + Hex.dumpString(byArray2));
        }
        return new BigInteger(byArray2);
    }

    protected abstract byte[] getAlgorithmEncoding();

    protected Any_RSA_PKCS1Signature(String string) {
        super(string + "/RSA/PKCS#1");
        try {
            this.md = MessageDigest.getInstance(string);
        }
        catch (Exception exception) {
            throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + string + " MessageDigest\n" + exception);
        }
    }
}

