/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Collection;
import java.util.function.BiFunction;
import javafx.scene.control.Control;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationResult;

public interface Validator<T>
extends BiFunction<Control, T, ValidationResult> {
    public static <T> Validator<T> createEmptyValidator(String message, Severity severity) {
        return (c, value) -> {
            boolean condition = value instanceof String ? value.toString().trim().isEmpty() : value == null;
            return ValidationResult.fromMessageIf(c, message, severity, condition);
        };
    }

    public static <T> Validator<T> createEmptyValidator(String message) {
        return Validator.createEmptyValidator(message, Severity.ERROR);
    }

    public static <T> Validator<T> createEqualsValidator(String message, Severity severity, Collection<T> values) {
        return (c, value) -> ValidationResult.fromMessageIf(c, message, severity, !values.contains(value));
    }

    public static <T> Validator<T> createEqualsValidator(String message, Collection<T> values) {
        return Validator.createEqualsValidator(message, Severity.ERROR, values);
    }
}

