/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.validation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.ListView;
import javafx.scene.control.Slider;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputControl;
import javafx.util.Callback;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;

public class ValidationSupport {
    private static List<ObservableValueExtractor> extractors = FXCollections.observableArrayList();
    private static final String CTRL_REQUIRED_FLAG = "$org.controlsfx.validation.required$";
    private ObservableSet<Control> controls;
    private ObservableMap<Control, ValidationResult> validationResults;
    private ReadOnlyObjectWrapper<ValidationResult> validationResultProperty;
    private ReadOnlyObjectWrapper<Boolean> invalidProperty;
    private ObjectProperty<ValidationDecoration> validationDecoratorProperty;

    public static void addObservableValueExtractor(Predicate<Control> test, Callback<Control, ObservableValue<?>> extract) {
        extractors.add(new ObservableValueExtractor(test, extract));
    }

    public static void setRequired(Control c, boolean required) {
        c.getProperties().put((Object)CTRL_REQUIRED_FLAG, (Object)required);
    }

    public static boolean isRequired(Control c) {
        Object value = c.getProperties().get((Object)CTRL_REQUIRED_FLAG);
        return value instanceof Boolean ? (Boolean)value : false;
    }

    public ValidationSupport() {
        ValidationSupport.addObservableValueExtractor(c -> c instanceof TextInputControl, c -> ((TextInputControl)c).textProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof ComboBox, c -> ((ComboBox)c).valueProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof ChoiceBox, c -> ((ChoiceBox)c).valueProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof CheckBox, c -> ((CheckBox)c).selectedProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof Slider, c -> ((Slider)c).valueProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof ColorPicker, c -> ((ColorPicker)c).valueProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof DatePicker, c -> ((DatePicker)c).valueProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof ListView, c -> ((ListView)c).itemsProperty());
        ValidationSupport.addObservableValueExtractor(c -> c instanceof TableView, c -> ((TableView)c).itemsProperty());
        this.controls = FXCollections.observableSet((Object[])new Control[0]);
        this.validationResults = FXCollections.observableMap(new WeakHashMap());
        this.validationResultProperty = new ReadOnlyObjectWrapper();
        this.invalidProperty = new ReadOnlyObjectWrapper();
        this.validationDecoratorProperty = new SimpleObjectProperty<ValidationDecoration>((Object)this, "validationDecorator", (ValidationDecoration)new GraphicValidationDecoration()){

            protected void invalidated() {
                ValidationSupport.this.redecorate();
            }
        };
        this.validationResults.addListener(change -> this.validationResultProperty.set((Object)ValidationResult.fromResults(this.validationResults.values())));
        this.validationResultProperty().addListener((o, oldValue, validationResult) -> {
            this.invalidProperty.set((Object)(!validationResult.getErrors().isEmpty() ? 1 : 0));
            this.redecorate();
        });
    }

    public void redecorate() {
        Optional<ValidationDecoration> odecorator = Optional.ofNullable(this.getValidationDecorator());
        for (Control target : this.getRegisteredControls()) {
            odecorator.ifPresent(decorator -> {
                decorator.removeDecorations(target);
                decorator.applyRequiredDecoration(target);
                this.getHighestMessage(target).ifPresent(msg -> decorator.applyValidationDecoration((ValidationMessage)msg));
            });
        }
    }

    public ValidationResult getValidationResult() {
        return (ValidationResult)this.validationResultProperty.get();
    }

    public ReadOnlyObjectProperty<ValidationResult> validationResultProperty() {
        return this.validationResultProperty.getReadOnlyProperty();
    }

    public Boolean isInvalid() {
        return (Boolean)this.invalidProperty.get();
    }

    public ReadOnlyObjectProperty<Boolean> invalidProperty() {
        return this.invalidProperty.getReadOnlyProperty();
    }

    public ObjectProperty<ValidationDecoration> validationDecoratorProperty() {
        return this.validationDecoratorProperty;
    }

    public ValidationDecoration getValidationDecorator() {
        return (ValidationDecoration)this.validationDecoratorProperty.get();
    }

    public void setValidationDecorator(ValidationDecoration decorator) {
        this.validationDecoratorProperty.set((Object)decorator);
    }

    private Optional<ObservableValueExtractor> getExtractor(Control c) {
        for (ObservableValueExtractor e : extractors) {
            if (!e.applicability.test(c)) continue;
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public <T> boolean registerValidator(Control c, boolean required, Validator<T> validator) {
        return this.getExtractor(c).map(e -> {
            ObservableValue observable = (ObservableValue)e.extraction.call((Object)c);
            ValidationSupport.setRequired(c, required);
            Consumer<Object> updateResults = value -> Platform.runLater(() -> {
                ValidationResult cfr_ignored_0 = (ValidationResult)this.validationResults.put((Object)c, validator.apply(c, value));
            });
            this.controls.add((Object)c);
            observable.addListener((o, oldValue, newValue) -> updateResults.accept(newValue));
            updateResults.accept(observable.getValue());
            return e;
        }).isPresent();
    }

    public <T> boolean registerValidator(Control c, Validator<T> validator) {
        return this.registerValidator(c, true, validator);
    }

    public Set<Control> getRegisteredControls() {
        return Collections.unmodifiableSet(this.controls);
    }

    public Optional<ValidationMessage> getHighestMessage(Control target) {
        return Optional.ofNullable(this.validationResults.get((Object)target)).flatMap(result -> result.getMessages().stream().max(ValidationMessage.COMPARATOR));
    }

    private static class ObservableValueExtractor {
        public final Predicate<Control> applicability;
        public final Callback<Control, ObservableValue<?>> extraction;

        public ObservableValueExtractor(Predicate<Control> applicability, Callback<Control, ObservableValue<?>> extraction) {
            this.applicability = Objects.requireNonNull(applicability);
            this.extraction = Objects.requireNonNull(extraction);
        }
    }
}

