/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.property;

import impl.org.controlsfx.i18n.Localization;
import java.beans.PropertyDescriptor;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.dialog.Dialogs;
import org.controlsfx.property.editor.PropertyEditor;

public class BeanProperty
implements PropertySheet.Item {
    private final Object bean;
    private final PropertyDescriptor beanPropertyDescriptor;
    private final Method readMethod;
    private boolean editable = true;

    public BeanProperty(Object bean, PropertyDescriptor propertyDescriptor) {
        this.bean = bean;
        this.beanPropertyDescriptor = propertyDescriptor;
        this.readMethod = propertyDescriptor.getReadMethod();
    }

    @Override
    public String getName() {
        return this.beanPropertyDescriptor.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.beanPropertyDescriptor.getShortDescription();
    }

    @Override
    public Class<?> getType() {
        return this.beanPropertyDescriptor.getPropertyType();
    }

    @Override
    public Object getValue() {
        try {
            return this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setValue(Object value) {
        Method writeMethod = this.beanPropertyDescriptor.getWriteMethod();
        if (writeMethod != null) {
            try {
                writeMethod.invoke(this.bean, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Throwable e) {
                if (e instanceof PropertyVetoException) {
                    Dialogs.create().title(Localization.localize(Localization.asKey("bean.property.change.error.title"))).message(e.getLocalizedMessage()).masthead(Localization.localize(Localization.asKey("bean.property.change.error.masthead"))).showError();
                }
                throw e;
            }
        }
    }

    @Override
    public String getCategory() {
        return Localization.localize(Localization.asKey(this.beanPropertyDescriptor.isExpert() ? "bean.property.category.expert" : "bean.property.category.basic"));
    }

    public Object getBean() {
        return this.bean;
    }

    public PropertyDescriptor getPropertyDescriptor() {
        return this.beanPropertyDescriptor;
    }

    @Override
    public Optional<Class<? extends PropertyEditor>> getPropertyEditorClass() {
        if (this.beanPropertyDescriptor.getPropertyEditorClass() != null && PropertyEditor.class.isAssignableFrom(this.beanPropertyDescriptor.getPropertyEditorClass())) {
            return Optional.of(this.beanPropertyDescriptor.getPropertyEditorClass());
        }
        return PropertySheet.Item.super.getPropertyEditorClass();
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }
}

