/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javafx.scene.Node;
import org.controlsfx.glyphfont.GlyphFont;

public final class GlyphFontRegistry {
    private static Map<String, GlyphFont> fontMap = new HashMap<String, GlyphFont>();
    private static boolean isInited = false;

    private GlyphFontRegistry() {
    }

    private static void init() {
        if (isInited) {
            return;
        }
        isInited = true;
        ServiceLoader<GlyphFont> loader = ServiceLoader.load(GlyphFont.class);
        for (GlyphFont font : loader) {
            GlyphFontRegistry.register(font);
        }
    }

    public static void register(GlyphFont font) {
        GlyphFontRegistry.init();
        if (font != null) {
            fontMap.put(font.getName(), font);
        }
    }

    public static GlyphFont font(String fontName) {
        GlyphFontRegistry.init();
        return fontMap.get(fontName);
    }

    public static Node glyph(String fontName, String glyphName) {
        GlyphFontRegistry.init();
        GlyphFont font = GlyphFontRegistry.font(fontName);
        return font.create(glyphName);
    }

    public static Node glyph(String fontAndGlyph) {
        GlyphFontRegistry.init();
        String[] args = fontAndGlyph.split("\\|");
        return GlyphFontRegistry.glyph(args[0], args[1]);
    }
}

