/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import com.sun.javafx.css.StyleManager;
import java.io.InputStream;
import java.util.Map;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import org.controlsfx.glyphfont.Glyph;

public abstract class GlyphFont {
    private final String fontName;
    private final double defaultSize;
    private double size;
    private Color color;
    private boolean fontLoaded = false;
    private Runnable fontLoader = null;

    public GlyphFont(String fontName, int defaultSize, final InputStream in) {
        this.fontName = fontName;
        this.defaultSize = defaultSize;
        this.size = defaultSize;
        this.fontLoader = new Runnable(){

            @Override
            public void run() {
                Font.loadFont((InputStream)in, (double)-1.0);
                GlyphFont.this.fontLoaded = true;
            }
        };
    }

    public GlyphFont(String fontName, int defaultSize, final String urlStr) {
        this.fontName = fontName;
        this.defaultSize = defaultSize;
        this.size = defaultSize;
        this.fontLoader = new Runnable(){

            @Override
            public void run() {
                Font.loadFont((String)urlStr, (double)-1.0);
                GlyphFont.this.fontLoaded = true;
            }
        };
    }

    public String getName() {
        return this.fontName;
    }

    public double getDefaultSize() {
        return this.defaultSize;
    }

    public GlyphFont fontSize(double size) {
        this.size = size;
        return this;
    }

    public GlyphFont fontColor(Color color) {
        this.color = color;
        return this;
    }

    public Glyph create(char character) {
        if (!this.fontLoaded) {
            this.fontLoader.run();
        }
        return new Glyph(this.fontName, Character.valueOf(character), this.size, this.color);
    }

    public Glyph create(String glyphName) {
        Character ch = this.getGlyphs().get(glyphName);
        return ch == null ? null : this.create(ch.charValue());
    }

    public abstract Map<String, Character> getGlyphs();

    static {
        StyleManager.getInstance().addUserAgentStylesheet(GlyphFont.class.getResource("glyphfont.css").toExternalForm());
    }
}

