/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.glyphfont;

import javafx.scene.control.Label;
import javafx.scene.paint.Color;
import org.controlsfx.tools.Duplicatable;

public class Glyph
extends Label
implements Duplicatable<Glyph> {
    public static final String STYLE_GRADIENT = "gradient";
    public static final String STYLE_HOVER_EFFECT = "hover-effect";
    private final String fontFamily;
    private final Character character;
    private double size;
    private Color color;

    public Glyph(String fontFamily, Character character, double size, Color color) {
        super(character.toString());
        this.fontFamily = fontFamily;
        this.character = character;
        this.size = size;
        this.color = color;
        this.getStyleClass().add((Object)"glyph-font");
        this.updateStyle();
    }

    public Glyph size(double size) {
        this.size = size;
        this.updateStyle();
        return this;
    }

    public Glyph color(Color color) {
        this.color = color;
        this.updateStyle();
        return this;
    }

    public Glyph useHoverEffect() {
        this.getStyleClass().addAll((Object[])new String[]{STYLE_HOVER_EFFECT});
        return this;
    }

    public Glyph useGradientEffect() {
        this.getStyleClass().addAll((Object[])new String[]{STYLE_GRADIENT});
        return this;
    }

    private void updateStyle() {
        StringBuilder css = new StringBuilder(String.format("-fx-font-family: %s; -fx-font-size: %fpx;", this.fontFamily, this.size));
        if (this.color == null) {
            css.append("-glyphs-color: -fx-text-background-color;");
        } else {
            css.append(String.format("-glyphs-color: rgba(%d,%d,%d,%f)", (int)(this.color.getRed() * 255.0), (int)(this.color.getGreen() * 255.0), (int)(this.color.getBlue() * 255.0), this.color.getOpacity()));
        }
        this.setStyle(css.toString());
    }

    @Override
    public Glyph duplicate() {
        return new Glyph(this.fontFamily, this.character, this.size, this.color);
    }
}

