/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import com.sun.javafx.Utils;
import com.sun.javafx.tk.Toolkit;
import impl.org.controlsfx.ImplUtils;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.dialog.DialogStyle;
import org.controlsfx.dialog.FXDialog;

class LightweightDialog
extends FXDialog {
    private Scene scene;
    private Parent owner;
    private Region opaqueLayer;
    private Group dialogStack;
    private Parent originalParent;
    private BooleanProperty focused;
    private StringProperty title;
    private BooleanProperty resizable;
    private Effect effect;
    private Effect tempEffect;
    private boolean modal = true;

    LightweightDialog(String title, Object incomingOwner, DialogStyle style) {
        Object _owner = incomingOwner;
        if (_owner == null) {
            _owner = org.controlsfx.tools.Utils.getWindow(_owner);
        }
        if (_owner instanceof Scene) {
            this.scene = (Scene)_owner;
        } else if (_owner instanceof Stage) {
            this.scene = ((Stage)_owner).getScene();
        } else if (_owner instanceof Tab) {
            this.owner = (Parent)((Tab)_owner).getContent();
        } else if (_owner instanceof Node) {
            this.owner = this.getFirstParent((Node)_owner);
        } else {
            throw new IllegalArgumentException("Unknown owner: " + _owner.getClass());
        }
        if (this.scene == null && this.owner != null) {
            this.scene = this.owner.getScene();
        }
        if (style == DialogStyle.UNDECORATED) {
            this.init(title, style);
            return;
        }
        this.init(title, DialogStyle.CROSS_PLATFORM_DARK);
        this.lightweightDialog.getStyleClass().addAll((Object[])new String[]{"lightweight", "custom-chrome"});
        this.toolBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                LightweightDialog.this.mouseDragDeltaX = LightweightDialog.this.lightweightDialog.getLayoutX() - event.getSceneX();
                LightweightDialog.this.mouseDragDeltaY = LightweightDialog.this.lightweightDialog.getLayoutY() - event.getSceneY();
                LightweightDialog.this.lightweightDialog.setCache(true);
            }
        });
        this.toolBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                double w = LightweightDialog.this.lightweightDialog.getWidth();
                double h = LightweightDialog.this.lightweightDialog.getHeight();
                double DROP_SHADOW_SIZE = (LightweightDialog.this.lightweightDialog.getBoundsInParent().getWidth() - LightweightDialog.this.lightweightDialog.getLayoutBounds().getWidth()) / 2.0;
                Insets padding = LightweightDialog.this.lightweightDialog.getPadding();
                double rightPadding = padding.getRight();
                double bottomPadding = padding.getBottom();
                double minX = 0.0;
                double maxX = LightweightDialog.this.owner == null ? LightweightDialog.this.scene.getWidth() : LightweightDialog.this.owner.getLayoutBounds().getWidth();
                double newX = event.getSceneX() + LightweightDialog.this.mouseDragDeltaX;
                newX = Utils.clamp((double)minX, (double)newX, (double)(maxX - w + DROP_SHADOW_SIZE + rightPadding + minX));
                double minY = 0.0;
                double maxY = LightweightDialog.this.owner == null ? LightweightDialog.this.scene.getHeight() : LightweightDialog.this.owner.getLayoutBounds().getHeight();
                double newY = event.getSceneY() + LightweightDialog.this.mouseDragDeltaY;
                newY = Utils.clamp((double)0.0, (double)newY, (double)(maxY - h + DROP_SHADOW_SIZE + bottomPadding + minY));
                LightweightDialog.this.lightweightDialog.setLayoutX(newX);
                LightweightDialog.this.lightweightDialog.setLayoutY(newY);
            }
        });
        this.toolBar.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                LightweightDialog.this.lightweightDialog.setCache(false);
            }
        });
        this.minButton = null;
        this.maxButton = null;
        this.windowBtns.getChildren().setAll((Object[])new Node[]{this.closeButton});
        EventHandler<MouseEvent> resizeHandler = new EventHandler<MouseEvent>(){
            private double width;
            private double height;
            private Point2D dragAnchor;

            public void handle(MouseEvent event) {
                EventType type = event.getEventType();
                if (type == MouseEvent.MOUSE_PRESSED) {
                    this.initAnchor(event);
                } else if (type == MouseEvent.MOUSE_DRAGGED) {
                    if (null == this.dragAnchor) {
                        this.initAnchor(event);
                    }
                    LightweightDialog.this.lightweightDialog.setPrefWidth(Math.max(LightweightDialog.this.lightweightDialog.minWidth(-1.0), this.width + (event.getSceneX() - this.dragAnchor.getX())));
                    LightweightDialog.this.lightweightDialog.setPrefHeight(Math.max(LightweightDialog.this.lightweightDialog.minHeight(-1.0), this.height + (event.getSceneY() - this.dragAnchor.getY())));
                }
            }

            private void initAnchor(MouseEvent event) {
                this.width = LightweightDialog.this.lightweightDialog.getWidth();
                this.height = LightweightDialog.this.lightweightDialog.getHeight();
                this.dragAnchor = new Point2D(event.getSceneX(), event.getSceneY());
            }
        };
        this.resizeCorner.setOnMousePressed((EventHandler)resizeHandler);
        this.resizeCorner.setOnMouseDragged((EventHandler)resizeHandler);
        this.lightweightDialog.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.lightweightDialog.pseudoClassStateChanged(ACTIVE_PSEUDO_CLASS, true);
    }

    @Override
    public void setModal(boolean modal) {
        this.modal = modal;
    }

    @Override
    public boolean isModal() {
        return this.modal;
    }

    @Override
    public ObservableList<String> getStylesheets() {
        return this.scene.getStylesheets();
    }

    @Override
    public void setEffect(Effect e) {
        this.effect = e;
    }

    @Override
    public StringProperty titleProperty() {
        if (this.title == null) {
            this.title = new SimpleStringProperty((Object)this, "title");
        }
        return this.title;
    }

    @Override
    public void show() {
        if (this.owner != null && this.owner.getParent() != null) {
            this.showInParent();
        } else if (this.scene != null) {
            this.showInScene();
        }
        if (this.isModal()) {
            Parent lock = this.owner != null ? this.owner : this.scene;
            Toolkit.getToolkit().enterNestedEventLoop((Object)lock);
        }
    }

    @Override
    public void hide() {
        if (this.owner != null) {
            this.hideInParent();
        } else if (this.scene != null) {
            this.hideInScene();
        }
        if (this.isModal()) {
            Parent lock = this.owner != null ? this.owner : this.scene;
            Toolkit.getToolkit().exitNestedEventLoop((Object)lock, null);
        }
    }

    @Override
    BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new SimpleBooleanProperty((Object)this, "resizable", false);
        }
        return this.resizable;
    }

    @Override
    public Window getWindow() {
        return this.scene.getWindow();
    }

    @Override
    public Node getRoot() {
        return this.lightweightDialog;
    }

    @Override
    public double getX() {
        return this.lightweightDialog.getLayoutX();
    }

    @Override
    public void setX(double x) {
        this.lightweightDialog.setLayoutX(x);
    }

    @Override
    ReadOnlyDoubleProperty widthProperty() {
        return this.lightweightDialog.widthProperty();
    }

    @Override
    ReadOnlyDoubleProperty heightProperty() {
        return this.lightweightDialog.heightProperty();
    }

    BooleanProperty focusedProperty() {
        if (this.focused == null) {
            this.focused = new SimpleBooleanProperty((Object)this, "focused", true);
        }
        return this.focused;
    }

    @Override
    public void setContentPane(Pane pane) {
        this.root.setCenter((Node)pane);
    }

    @Override
    public void sizeToScene() {
    }

    @Override
    void setIconified(boolean iconified) {
    }

    @Override
    boolean isIconified() {
        return false;
    }

    @Override
    public void setIconifiable(boolean iconifiable) {
    }

    @Override
    public void setClosable(boolean closable) {
        this.closeButton.setVisible(closable);
    }

    private void hideInScene() {
        if (this.opaqueLayer != null) {
            this.opaqueLayer.setVisible(false);
        }
        this.originalParent.setEffect(this.tempEffect);
        this.lightweightDialog.setVisible(false);
        ImplUtils.stripRootPane(this.scene, this.originalParent);
    }

    private void hideInParent() {
        if (this.opaqueLayer != null) {
            this.opaqueLayer.setVisible(false);
        }
        if (this.originalParent != null) {
            this.originalParent.setEffect(this.tempEffect);
        }
        this.lightweightDialog.setVisible(false);
        ImplUtils.getChildren(this.owner.getParent()).setAll((Object[])new Node[]{this.owner});
        this.dialogStack = null;
    }

    private void showInScene() {
        this.installCSSInScene();
        this.originalParent = this.scene.getRoot();
        this.buildDialogStack((Node)this.originalParent);
        this.lightweightDialog.setVisible(true);
        ImplUtils.injectAsRootPane(this.scene, (Parent)this.dialogStack);
        this.configureDialogStack((Node)this.originalParent);
        this.lightweightDialog.requestFocus();
    }

    private void showInParent() {
        this.installCSSInScene();
        this.buildDialogStack((Node)this.owner);
        ImplUtils.injectPane(this.owner, (Parent)this.dialogStack);
        this.configureDialogStack((Node)this.owner);
        this.lightweightDialog.setVisible(true);
        this.lightweightDialog.requestFocus();
    }

    private void installCSSInScene() {
        Scene _scene;
        String dialogsCssUrl = DIALOGS_CSS_URL.toExternalForm();
        if (this.scene != null) {
            if (!this.scene.getStylesheets().contains((Object)dialogsCssUrl)) {
                this.scene.getStylesheets().addAll((Object[])new String[]{dialogsCssUrl});
            }
        } else if (this.owner != null && (_scene = this.owner.getScene()) != null && !this.scene.getStylesheets().contains((Object)dialogsCssUrl)) {
            _scene.getStylesheets().addAll((Object[])new String[]{dialogsCssUrl});
        }
    }

    private void buildDialogStack(final Node parent) {
        this.dialogStack = new Group(new Node[]{this.lightweightDialog}){
            private boolean isFirstRun;
            {
                super(x0);
                this.isFirstRun = true;
            }

            protected void layoutChildren() {
                double w = LightweightDialog.this.getOverlayWidth();
                double h = LightweightDialog.this.getOverlayHeight();
                double x = LightweightDialog.this.getOverlayX();
                double y = LightweightDialog.this.getOverlayY();
                if (parent != null) {
                    parent.resizeRelocate(x, y, w, h);
                }
                if (LightweightDialog.this.opaqueLayer != null) {
                    LightweightDialog.this.opaqueLayer.resizeRelocate(x, y, w, h);
                }
                double dialogWidth = LightweightDialog.this.lightweightDialog.prefWidth(-1.0);
                double dialogHeight = LightweightDialog.this.lightweightDialog.prefHeight(-1.0);
                LightweightDialog.this.lightweightDialog.resize((double)((int)dialogWidth), (double)((int)dialogHeight));
                if (this.isFirstRun) {
                    this.isFirstRun = false;
                    double dialogX = LightweightDialog.this.lightweightDialog.getLayoutX();
                    dialogX = dialogX == 0.0 ? w / 2.0 - dialogWidth / 2.0 : dialogX;
                    double dialogY = LightweightDialog.this.lightweightDialog.getLayoutY();
                    dialogY = dialogY == 0.0 ? h / 2.0 - dialogHeight / 2.0 : dialogY;
                    LightweightDialog.this.lightweightDialog.relocate((double)((int)dialogX), (double)((int)dialogY));
                }
            }
        };
        this.dialogStack.setManaged(true);
    }

    private void configureDialogStack(Node parent) {
        this.opaqueLayer = new Region();
        this.dialogStack.getChildren().add(parent == null ? 0 : 1, (Object)this.opaqueLayer);
        if (this.effect == null) {
            this.opaqueLayer.getStyleClass().add((Object)"lightweight-dialog-background");
        } else if (parent != null) {
            this.tempEffect = parent.getEffect();
            parent.setEffect(this.effect);
        }
    }

    private double getOverlayWidth() {
        if (this.owner != null) {
            return this.owner.getLayoutBounds().getWidth();
        }
        if (this.scene != null) {
            return this.scene.getWidth();
        }
        return 0.0;
    }

    private double getOverlayHeight() {
        if (this.owner != null) {
            return this.owner.getLayoutBounds().getHeight();
        }
        if (this.scene != null) {
            return this.scene.getHeight();
        }
        return 0.0;
    }

    private double getOverlayX() {
        return 0.0;
    }

    private double getOverlayY() {
        return 0.0;
    }

    private Parent getFirstParent(Node n) {
        if (n == null) {
            return null;
        }
        return n instanceof Parent ? (Parent)n : this.getFirstParent((Node)n.getParent());
    }
}

