/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import java.util.EnumSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.Effect;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.controlsfx.dialog.DialogStyle;
import org.controlsfx.dialog.FXDialog;
import org.controlsfx.tools.Platform;

class HeavyweightDialog
extends FXDialog {
    private final Stage stage;
    private final Window owner;
    private boolean modal;
    private static EnumSet<Platform> DECORATED_STAGE_PLATFORMS = EnumSet.of(Platform.OSX, Platform.UNIX);
    private static final PseudoClass ACTIVE_PSEUDO_CLASS = PseudoClass.getPseudoClass((String)"active");

    HeavyweightDialog(String title, Window owner, boolean modal) {
        this(title, owner, modal, DialogStyle.CROSS_PLATFORM_DARK);
    }

    HeavyweightDialog(String title, Window owner, boolean modal, DialogStyle dialogStyle) {
        StageStyle style;
        this.owner = owner;
        switch (dialogStyle) {
            case CROSS_PLATFORM_DARK: {
                style = StageStyle.TRANSPARENT;
                break;
            }
            case NATIVE: {
                style = DECORATED_STAGE_PLATFORMS.contains((Object)Platform.getCurrent()) ? StageStyle.DECORATED : StageStyle.UTILITY;
                break;
            }
            case UNDECORATED: {
                style = StageStyle.UNDECORATED;
                break;
            }
            default: {
                dialogStyle = DialogStyle.CROSS_PLATFORM_DARK;
                style = StageStyle.TRANSPARENT;
            }
        }
        this.stage = new Stage(style){

            public void showAndWait() {
                Window owner = this.getOwner();
                if (owner != null) {
                    double y;
                    double x;
                    double dialogWidth = HeavyweightDialog.this.root.prefWidth(-1.0);
                    double dialogHeight = HeavyweightDialog.this.root.prefHeight(-1.0);
                    if (owner.getX() < 0.0 || owner.getY() < 0.0) {
                        Screen screen = Screen.getPrimary();
                        double maxW = screen.getVisualBounds().getWidth();
                        double maxH = screen.getVisualBounds().getHeight();
                        x = maxW / 2.0 - dialogWidth / 2.0;
                        y = maxH / 2.0 - dialogHeight / 2.0 - 50.0;
                    } else {
                        x = owner.getX() + owner.getWidth() / 2.0 - dialogWidth / 2.0;
                        y = owner.getY() + owner.getHeight() / 2.0 - dialogHeight / 2.0 - 50.0;
                    }
                    this.setX(x);
                    this.setY(y);
                }
                super.showAndWait();
            }
        };
        if (owner != null) {
            this.stage.initOwner(owner);
        }
        this.setModal(modal);
        boolean useCustomChrome = dialogStyle == DialogStyle.CROSS_PLATFORM_DARK;
        this.init(title, dialogStyle);
        this.lightweightDialog.getStyleClass().add((Object)"heavyweight");
        this.lightweightDialog.getStyleClass().add((Object)(useCustomChrome ? "custom-chrome" : "native-chrome"));
        Scene scene = new Scene((Parent)this.lightweightDialog);
        scene.getStylesheets().addAll((Object[])new String[]{DIALOGS_CSS_URL.toExternalForm()});
        scene.setFill((Paint)Color.TRANSPARENT);
        this.stage.setScene(scene);
        if (useCustomChrome) {
            this.toolBar.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    HeavyweightDialog.this.mouseDragDeltaX = event.getSceneX();
                    HeavyweightDialog.this.mouseDragDeltaY = event.getSceneY();
                }
            });
            this.toolBar.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    HeavyweightDialog.this.stage.setX(event.getScreenX() - HeavyweightDialog.this.mouseDragDeltaX);
                    HeavyweightDialog.this.stage.setY(event.getScreenY() - HeavyweightDialog.this.mouseDragDeltaY);
                }
            });
            this.maxButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){
                private double restoreX;
                private double restoreY;
                private double restoreW;
                private double restoreH;

                public void handle(ActionEvent event) {
                    Screen screen = Screen.getPrimary();
                    double minX = screen.getVisualBounds().getMinX();
                    double minY = screen.getVisualBounds().getMinY();
                    double maxW = screen.getVisualBounds().getWidth();
                    double maxH = screen.getVisualBounds().getHeight();
                    if (this.restoreW == 0.0 || HeavyweightDialog.this.stage.getX() != minX || HeavyweightDialog.this.stage.getY() != minY || HeavyweightDialog.this.stage.getWidth() != maxW || HeavyweightDialog.this.stage.getHeight() != maxH) {
                        this.restoreX = HeavyweightDialog.this.stage.getX();
                        this.restoreY = HeavyweightDialog.this.stage.getY();
                        this.restoreW = HeavyweightDialog.this.stage.getWidth();
                        this.restoreH = HeavyweightDialog.this.stage.getHeight();
                        HeavyweightDialog.this.stage.setX(minX);
                        HeavyweightDialog.this.stage.setY(minY);
                        HeavyweightDialog.this.stage.setWidth(maxW);
                        HeavyweightDialog.this.stage.setHeight(maxH);
                    } else {
                        HeavyweightDialog.this.stage.setX(this.restoreX);
                        HeavyweightDialog.this.stage.setY(this.restoreY);
                        HeavyweightDialog.this.stage.setWidth(this.restoreW);
                        HeavyweightDialog.this.stage.setHeight(this.restoreH);
                    }
                }
            });
            EventHandler<MouseEvent> resizeHandler = new EventHandler<MouseEvent>(){
                private double width;
                private double height;
                private Point2D dragAnchor;

                public void handle(MouseEvent event) {
                    EventType type = event.getEventType();
                    if (type == MouseEvent.MOUSE_PRESSED) {
                        this.width = HeavyweightDialog.this.stage.getWidth();
                        this.height = HeavyweightDialog.this.stage.getHeight();
                        this.dragAnchor = new Point2D(event.getSceneX(), event.getSceneY());
                    } else if (type == MouseEvent.MOUSE_DRAGGED) {
                        HeavyweightDialog.this.stage.setWidth(Math.max(HeavyweightDialog.this.lightweightDialog.minWidth(-1.0), this.width + (event.getSceneX() - this.dragAnchor.getX())));
                        HeavyweightDialog.this.stage.setHeight(Math.max(HeavyweightDialog.this.lightweightDialog.minHeight(-1.0), this.height + (event.getSceneY() - this.dragAnchor.getY())));
                    }
                }
            };
            this.resizeCorner.setOnMousePressed((EventHandler)resizeHandler);
            this.resizeCorner.setOnMouseDragged((EventHandler)resizeHandler);
        }
    }

    @Override
    public void setModal(boolean modal) {
        this.modal = modal;
        if (modal) {
            if (this.owner != null) {
                this.stage.initModality(Modality.WINDOW_MODAL);
            } else {
                this.stage.initModality(Modality.APPLICATION_MODAL);
            }
        } else {
            this.stage.initModality(Modality.NONE);
        }
    }

    @Override
    public ObservableList<String> getStylesheets() {
        return this.stage.getScene().getStylesheets();
    }

    @Override
    public boolean isModal() {
        return this.modal;
    }

    @Override
    public void setContentPane(Pane pane) {
        this.root.setCenter((Node)pane);
    }

    @Override
    public void setIconifiable(boolean iconifiable) {
        if (this.minButton != null) {
            this.minButton.setVisible(iconifiable);
        }
    }

    @Override
    public void setClosable(boolean closable) {
        if (this.closeButton != null) {
            this.closeButton.setVisible(closable);
        }
    }

    @Override
    public void show() {
        this.stage.centerOnScreen();
        this.stage.showAndWait();
    }

    @Override
    public void hide() {
        this.stage.hide();
    }

    @Override
    public Window getWindow() {
        return this.stage;
    }

    @Override
    public Node getRoot() {
        return this.stage.getScene().getRoot();
    }

    @Override
    public double getX() {
        return this.stage.getX();
    }

    @Override
    public void setX(double x) {
        this.stage.setX(x);
    }

    @Override
    ReadOnlyDoubleProperty heightProperty() {
        return this.stage.heightProperty();
    }

    @Override
    ReadOnlyDoubleProperty widthProperty() {
        return this.stage.widthProperty();
    }

    @Override
    BooleanProperty resizableProperty() {
        return this.stage.resizableProperty();
    }

    @Override
    StringProperty titleProperty() {
        return this.stage.titleProperty();
    }

    @Override
    ReadOnlyBooleanProperty focusedProperty() {
        return this.stage.focusedProperty();
    }

    @Override
    public void sizeToScene() {
        this.stage.sizeToScene();
    }

    @Override
    void setIconified(boolean iconified) {
        this.stage.setIconified(iconified);
    }

    @Override
    boolean isIconified() {
        return this.stage.isIconified();
    }

    @Override
    void setEffect(Effect e) {
    }
}

