/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import javafx.stage.Window;
import org.controlsfx.dialog.DialogStyle;
import org.controlsfx.dialog.FXDialog;
import org.controlsfx.dialog.HeavyweightDialog;
import org.controlsfx.dialog.LightweightDialog;
import org.controlsfx.tools.Utils;

class DialogFactory {
    DialogFactory() {
    }

    static FXDialog createDialog(String title) {
        return DialogFactory.createDialog(false, title);
    }

    static FXDialog createDialog(boolean useLightweight, String title) {
        return DialogFactory.createDialog(false, title, null, false);
    }

    static FXDialog createDialog(boolean useLightweight, String title, Object owner, boolean modal) {
        return DialogFactory.createDialog(useLightweight, title, owner, modal, DialogStyle.CROSS_PLATFORM_DARK);
    }

    static FXDialog createDialog(boolean useLightweight, String title, Object owner, boolean modal, DialogStyle style) {
        if (style == null) {
            style = DialogStyle.CROSS_PLATFORM_DARK;
        }
        if (useLightweight) {
            return new LightweightDialog(title, owner, style);
        }
        Window window = Utils.getWindow(owner);
        return new HeavyweightDialog(title, window, modal, style);
    }
}

