/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.textfield;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.skin.AutoCompletePopup;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.concurrent.Task;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.util.Callback;
import javafx.util.StringConverter;

public abstract class AutoCompletionBinding<T>
implements EventTarget {
    private final Node completionTarget;
    private final AutoCompletePopup<T> autoCompletionPopup;
    private final Object suggestionsTaskLock = new Object();
    private FetchSuggestionsTask suggestionsTask = null;
    private Callback<ISuggestionRequest, Collection<T>> suggestionProvider = null;
    private boolean ignoreInputChanges = false;
    private ObjectProperty<EventHandler<AutoCompletionEvent<T>>> onAutoCompleted;
    final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);

    protected AutoCompletionBinding(Node completionTarget, Callback<ISuggestionRequest, Collection<T>> suggestionProvider, StringConverter<T> converter) {
        this.completionTarget = completionTarget;
        this.suggestionProvider = suggestionProvider;
        this.autoCompletionPopup = new AutoCompletePopup();
        this.autoCompletionPopup.setConverter(converter);
        this.autoCompletionPopup.setOnSuggestion(new EventHandler<AutoCompletePopup.SuggestionEvent<T>>(){

            public void handle(AutoCompletePopup.SuggestionEvent<T> sce) {
                try {
                    AutoCompletionBinding.this.setIgnoreInputChanges(true);
                    AutoCompletionBinding.this.completeUserInput(sce.getSuggestion());
                    AutoCompletionBinding.this.fireAutoCompletion(sce.getSuggestion());
                    AutoCompletionBinding.this.hidePopup();
                }
                finally {
                    AutoCompletionBinding.this.setIgnoreInputChanges(false);
                }
            }
        });
    }

    public final void setUserInput(String userText) {
        if (!this.isIgnoreInputChanges()) {
            this.onUserInputChanged(userText);
        }
    }

    public Node getCompletionTarget() {
        return this.completionTarget;
    }

    public abstract void dispose();

    protected abstract void completeUserInput(T var1);

    protected void showPopup() {
        this.autoCompletionPopup.show(this.completionTarget);
    }

    protected void hidePopup() {
        this.autoCompletionPopup.hide();
    }

    protected void fireAutoCompletion(T completion) {
        Event.fireEvent((EventTarget)this, new AutoCompletionEvent<T>(completion));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onUserInputChanged(String userText) {
        this.autoCompletionPopup.getSuggestions().clear();
        Object object = this.suggestionsTaskLock;
        synchronized (object) {
            if (this.suggestionsTask != null && this.suggestionsTask.isRunning()) {
                this.suggestionsTask.cancel();
            }
            this.suggestionsTask = new FetchSuggestionsTask(userText);
            new Thread((Runnable)((Object)this.suggestionsTask)).start();
        }
    }

    private boolean isIgnoreInputChanges() {
        return this.ignoreInputChanges;
    }

    private void setIgnoreInputChanges(boolean state) {
        this.ignoreInputChanges = state;
    }

    public final void setOnAutoCompleted(EventHandler<AutoCompletionEvent<T>> value) {
        this.onAutoCompletedProperty().set(value);
    }

    public final EventHandler<AutoCompletionEvent<T>> getOnAutoCompleted() {
        return this.onAutoCompleted == null ? null : (EventHandler)this.onAutoCompleted.get();
    }

    public final ObjectProperty<EventHandler<AutoCompletionEvent<T>>> onAutoCompletedProperty() {
        if (this.onAutoCompleted == null) {
            this.onAutoCompleted = new ObjectPropertyBase<EventHandler<AutoCompletionEvent<T>>>(){

                protected void invalidated() {
                    AutoCompletionBinding.this.eventHandlerManager.setEventHandler(AutoCompletionEvent.AUTO_COMPLETED, (EventHandler)this.get());
                }

                public Object getBean() {
                    return AutoCompletionBinding.this;
                }

                public String getName() {
                    return "onAutoCompleted";
                }
            };
        }
        return this.onAutoCompleted;
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend((EventDispatcher)this.eventHandlerManager);
    }

    public static class AutoCompletionEvent<TE>
    extends Event {
        public static final EventType<AutoCompletionEvent> AUTO_COMPLETED = new EventType("AUTO_COMPLETED");
        private final TE completion;

        public AutoCompletionEvent(TE completion) {
            super(AUTO_COMPLETED);
            this.completion = completion;
        }

        public TE getCompletion() {
            return this.completion;
        }
    }

    private class FetchSuggestionsTask
    extends Task<Void>
    implements ISuggestionRequest {
        private final String userText;

        public FetchSuggestionsTask(String userText) {
            this.userText = userText;
        }

        protected Void call() throws Exception {
            Callback provider = AutoCompletionBinding.this.suggestionProvider;
            if (provider != null) {
                final Collection fetchedSuggestions = (Collection)provider.call((Object)this);
                if (!this.isCancelled()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (fetchedSuggestions != null && !fetchedSuggestions.isEmpty()) {
                                AutoCompletionBinding.this.autoCompletionPopup.getSuggestions().addAll(fetchedSuggestions);
                                AutoCompletionBinding.this.showPopup();
                            } else {
                                AutoCompletionBinding.this.hidePopup();
                            }
                        }
                    });
                }
            } else {
                AutoCompletionBinding.this.hidePopup();
            }
            return null;
        }

        @Override
        public String getUserText() {
            return this.userText;
        }
    }

    public static interface ISuggestionRequest {
        public boolean isCancelled();

        public String getUserText();
    }
}

