/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.table;

import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Skin;
import javafx.scene.control.TableView;

public final class TableMenuButtonAccessor {
    public static void modifyTableMenu(final TableView<?> tableView, final Consumer<ContextMenu> consumer) {
        if (tableView.getScene() == null) {
            tableView.sceneProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    tableView.sceneProperty().removeListener((InvalidationListener)this);
                    TableMenuButtonAccessor.modifyTableMenu(tableView, consumer);
                }
            });
            return;
        }
        Skin skin = tableView.getSkin();
        if (skin == null) {
            tableView.skinProperty().addListener(new InvalidationListener(){

                public void invalidated(Observable o) {
                    tableView.skinProperty().removeListener((InvalidationListener)this);
                    TableMenuButtonAccessor.modifyTableMenu(tableView, consumer);
                }
            });
            return;
        }
        TableMenuButtonAccessor.doModify(tableView, consumer);
    }

    private static void doModify(TableView<?> tableView, Consumer<ContextMenu> consumer) {
        Skin skin = tableView.getSkin();
        if (!(skin instanceof TableViewSkin)) {
            return;
        }
        TableViewSkin tableSkin = (TableViewSkin)skin;
        TableHeaderRow headerRow = TableMenuButtonAccessor.getHeaderRow(tableSkin);
        if (headerRow == null) {
            return;
        }
        ContextMenu contextMenu = TableMenuButtonAccessor.getContextMenu(headerRow);
        consumer.accept(contextMenu);
    }

    private static TableHeaderRow getHeaderRow(TableViewSkin<?> tableSkin) {
        ObservableList children = tableSkin.getChildren();
        int max = children.size();
        for (int i = 0; i < max; ++i) {
            Node child = (Node)children.get(i);
            if (!(child instanceof TableHeaderRow)) continue;
            return (TableHeaderRow)child;
        }
        return null;
    }

    private static ContextMenu getContextMenu(TableHeaderRow headerRow) {
        try {
            Field privateContextMenuField = TableHeaderRow.class.getDeclaredField("columnPopupMenu");
            privateContextMenuField.setAccessible(true);
            ContextMenu contextMenu = (ContextMenu)privateContextMenuField.get(headerRow);
            return contextMenu;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchFieldException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

