/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import impl.org.controlsfx.i18n.Localization;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;
import org.controlsfx.tools.Utils;

public final class SpreadsheetColumn {
    private final SpreadsheetView spreadsheetView;
    final TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> column;
    private final boolean canFix;
    private final Integer indexColumn;
    private MenuItem fixItem;
    private final InvalidationListener updateTextListener = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            SpreadsheetColumn.this.setText(SpreadsheetColumn.this.getText());
        }
    };

    SpreadsheetColumn(final TableColumn<ObservableList<SpreadsheetCell>, SpreadsheetCell> column, final SpreadsheetView spreadsheetView, final Integer indexColumn) {
        this.spreadsheetView = spreadsheetView;
        this.column = column;
        column.setMinWidth(0.0);
        this.indexColumn = indexColumn;
        this.canFix = this.initCanFix();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                column.setContextMenu(SpreadsheetColumn.this.getColumnContextMenu());
            }
        };
        Platform.runLater((Runnable)r);
        spreadsheetView.getFixedColumns().addListener(this.updateTextListener);
        spreadsheetView.fixingColumnsAllowedProperty().addListener(this.updateTextListener);
        spreadsheetView.getGrid().getColumnHeaders().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                ObservableList<String> columnsHeader = spreadsheetView.getGrid().getColumnHeaders();
                if (columnsHeader.size() <= indexColumn) {
                    SpreadsheetColumn.this.setText(Utils.getExcelLetterFromNumber(indexColumn));
                } else if (!((String)columnsHeader.get(indexColumn)).equals(SpreadsheetColumn.this.getText())) {
                    SpreadsheetColumn.this.setText((String)columnsHeader.get(indexColumn));
                }
            }
        });
        spreadsheetView.getGrid().getRows().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                SpreadsheetColumn.this.initCanFix();
            }
        });
    }

    public boolean isFixed() {
        return this.spreadsheetView.getFixedColumns().contains((Object)this);
    }

    public void setFixed(boolean fixed) {
        if (fixed) {
            this.spreadsheetView.getFixedColumns().add((Object)this);
        } else {
            this.spreadsheetView.getFixedColumns().removeAll((Object[])new SpreadsheetColumn[]{this});
        }
    }

    public void setPrefWidth(double width) {
        this.column.setPrefWidth(width);
    }

    public double getWidth() {
        return this.column.getWidth();
    }

    public void setResizable(boolean b) {
        this.column.setResizable(b);
    }

    public void fitColumn() {
        if (this.column.isResizable()) {
            this.spreadsheetView.getCellsViewSkin().resizeColumnToFitContent(this.column, -1);
        }
    }

    public boolean isColumnFixable() {
        return this.canFix && this.spreadsheetView.isFixingColumnsAllowed();
    }

    private void setText(String text) {
        this.column.setText(text);
    }

    private String getText() {
        return this.column.getText();
    }

    private ContextMenu getColumnContextMenu() {
        if (this.isColumnFixable()) {
            ContextMenu contextMenu = new ContextMenu();
            this.fixItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.column.menu.fix")));
            this.fixItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    if (!SpreadsheetColumn.this.isFixed()) {
                        SpreadsheetColumn.this.setFixed(true);
                    } else {
                        SpreadsheetColumn.this.setFixed(false);
                    }
                }
            });
            contextMenu.getItems().addAll((Object[])new MenuItem[]{this.fixItem});
            return contextMenu;
        }
        return new ContextMenu();
    }

    private boolean initCanFix() {
        for (ObservableList row : this.spreadsheetView.getGrid().getRows()) {
            int columnSpan = ((SpreadsheetCell)row.get(this.indexColumn.intValue())).getColumnSpan();
            if (columnSpan <= 1 && ((SpreadsheetCell)row.get(this.indexColumn.intValue())).getRowSpan() <= 1) continue;
            return false;
        }
        return true;
    }
}

