/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.spreadsheet;

import java.text.DecimalFormat;
import java.time.LocalDate;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public abstract class SpreadsheetCellEditor {
    public static final DecimalFormat decimalFormat = new DecimalFormat("#.##########");
    SpreadsheetView view;

    public SpreadsheetCellEditor(SpreadsheetView view) {
        this.view = view;
    }

    public final void endEdit(boolean b) {
        this.view.getCellsViewSkin().getSpreadsheetCellEditorImpl().endEdit(b);
    }

    public abstract void startEdit(Object var1);

    public abstract Control getEditor();

    public abstract String getControlValue();

    public abstract void end();

    public static class DateEditor
    extends SpreadsheetCellEditor {
        private final DatePicker datePicker = new DatePicker();
        private EventHandler<KeyEvent> eh;
        private ChangeListener<LocalDate> cl;
        private boolean ending = false;

        public DateEditor(SpreadsheetView view, StringConverter<LocalDate> converter) {
            super(view);
            this.datePicker.setConverter(converter);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof LocalDate) {
                this.datePicker.setValue((Object)((LocalDate)value));
            }
            this.attachEnterEscapeEventHandler();
            this.datePicker.show();
            this.datePicker.getEditor().requestFocus();
        }

        @Override
        public void end() {
            if (this.datePicker.isShowing()) {
                this.datePicker.hide();
            }
            this.datePicker.removeEventFilter(KeyEvent.KEY_PRESSED, this.eh);
            this.datePicker.valueProperty().removeListener(this.cl);
        }

        public DatePicker getEditor() {
            return this.datePicker;
        }

        @Override
        public String getControlValue() {
            return this.datePicker.getEditor().getText();
        }

        private void attachEnterEscapeEventHandler() {
            this.eh = new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        ending = true;
                        this.endEdit(true);
                        ending = false;
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    }
                }
            };
            this.datePicker.addEventFilter(KeyEvent.KEY_PRESSED, this.eh);
            this.cl = new ChangeListener<LocalDate>(){

                public void changed(ObservableValue<? extends LocalDate> arg0, LocalDate arg1, LocalDate arg2) {
                    if (!ending) {
                        this.endEdit(true);
                    }
                }
            };
            this.datePicker.valueProperty().addListener(this.cl);
        }
    }

    public static class ListEditor<R>
    extends SpreadsheetCellEditor {
        private final List<String> itemList;
        private final ComboBox<String> cb;
        private String originalValue;

        public ListEditor(SpreadsheetView view, List<String> itemList) {
            super(view);
            this.itemList = itemList;
            this.cb = new ComboBox();
            this.cb.setVisibleRowCount(5);
        }

        @Override
        public void startEdit(Object value) {
            this.originalValue = value instanceof String ? value.toString() : null;
            ObservableList items = FXCollections.observableList(this.itemList);
            this.cb.setItems(items);
            this.cb.setValue((Object)this.originalValue);
            this.attachEnterEscapeEventHandler();
            this.cb.show();
            this.cb.requestFocus();
        }

        @Override
        public void end() {
            this.cb.setOnKeyPressed(null);
        }

        public ComboBox<String> getEditor() {
            return this.cb;
        }

        @Override
        public String getControlValue() {
            return (String)this.cb.getSelectionModel().getSelectedItem();
        }

        private void attachEnterEscapeEventHandler() {
            this.cb.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ESCAPE) {
                        cb.setValue((Object)originalValue);
                        this.endEdit(false);
                    } else if (t.getCode() == KeyCode.ENTER) {
                        this.endEdit(true);
                    }
                }
            });
        }
    }

    public static class IntegerEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public IntegerEditor(SpreadsheetView view) {
            super(view);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof Integer) {
                this.tf.setText(Integer.toString((Integer)value));
            } else {
                this.tf.setText(null);
            }
            this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    block6: {
                        if (t.getCode() == KeyCode.ENTER) {
                            try {
                                if (tf.getText().equals("")) {
                                    this.endEdit(true);
                                    break block6;
                                }
                                Integer.parseInt(tf.getText());
                                this.endEdit(true);
                            }
                            catch (Exception exception) {}
                        } else if (t.getCode() == KeyCode.ESCAPE) {
                            this.endEdit(false);
                        }
                    }
                }
            });
            this.tf.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    try {
                        if (tf.getText().equals("")) {
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        } else {
                            Integer.parseInt(tf.getText());
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        }
                    }
                    catch (Exception e) {
                        tf.getStyleClass().add((Object)"error");
                    }
                }
            });
        }
    }

    public static class DoubleEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public DoubleEditor(SpreadsheetView view) {
            super(view);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof Double) {
                this.tf.setText(((Double)value).isNaN() ? "" : decimalFormat.format(value));
            } else {
                this.tf.setText(null);
            }
            this.tf.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    block6: {
                        if (t.getCode() == KeyCode.ENTER) {
                            try {
                                if (tf.getText().equals("")) {
                                    this.endEdit(true);
                                    break block6;
                                }
                                Double.parseDouble(tf.getText());
                                this.endEdit(true);
                            }
                            catch (Exception exception) {}
                        } else if (t.getCode() == KeyCode.ESCAPE) {
                            this.endEdit(false);
                        }
                    }
                }
            });
            this.tf.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    try {
                        if (tf.getText().equals("")) {
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        } else {
                            Double.parseDouble(tf.getText());
                            tf.getStyleClass().removeAll((Object[])new String[]{"error"});
                        }
                    }
                    catch (Exception e) {
                        tf.getStyleClass().add((Object)"error");
                    }
                }
            });
        }
    }

    public static class StringEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public StringEditor(SpreadsheetView view) {
            super(view);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof String || value == null) {
                this.tf.setText((String)value);
            }
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        this.endEdit(true);
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    }
                }
            });
        }
    }

    public static class ObjectEditor
    extends SpreadsheetCellEditor {
        private final TextField tf = new TextField();

        public ObjectEditor(SpreadsheetView view) {
            super(view);
        }

        @Override
        public void startEdit(Object value) {
            if (value instanceof String) {
                this.tf.setText(value.toString());
            }
            this.attachEnterEscapeEventHandler();
            this.tf.requestFocus();
            this.tf.end();
        }

        @Override
        public String getControlValue() {
            return this.tf.getText();
        }

        @Override
        public void end() {
            this.tf.setOnKeyPressed(null);
        }

        public TextField getEditor() {
            return this.tf;
        }

        private void attachEnterEscapeEventHandler() {
            this.tf.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent t) {
                    if (t.getCode() == KeyCode.ENTER) {
                        this.endEdit(true);
                    } else if (t.getCode() == KeyCode.ESCAPE) {
                        this.endEdit(false);
                    }
                }
            });
        }
    }
}

