/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.decoration;

import impl.org.controlsfx.ImplUtils;
import impl.org.controlsfx.skin.DecorationPane;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import org.controlsfx.control.decoration.Decoration;

public class Decorator {
    private static final String DECORATIONS_PROPERTY_KEY = "$org.controlsfx.decorations$";

    private Decorator() {
    }

    public static final void addDecoration(Node target, Decoration decoration) {
        Decorator.getDecorations(target, true).add((Object)decoration);
        Decorator.updateDecorationsOnNode(target, (List<Decoration>)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}), null);
    }

    public static final void removeDecoration(Node target, Decoration decoration) {
        Decorator.getDecorations(target, true).remove((Object)decoration);
        Decorator.updateDecorationsOnNode(target, null, (List<Decoration>)FXCollections.observableArrayList((Object[])new Decoration[]{decoration}));
    }

    public static final void removeAllDecorations(Node target) {
        ObservableList<Decoration> decorations = Decorator.getDecorations(target, true);
        ObservableList removed = FXCollections.observableArrayList(decorations);
        target.getProperties().remove((Object)DECORATIONS_PROPERTY_KEY);
        Decorator.updateDecorationsOnNode(target, null, (List<Decoration>)removed);
    }

    public static final ObservableList<Decoration> getDecorations(Node target) {
        return Decorator.getDecorations(target, false);
    }

    private static final ObservableList<Decoration> getDecorations(Node target, boolean createIfAbsent) {
        ObservableList decorations = (ObservableList)target.getProperties().get((Object)DECORATIONS_PROPERTY_KEY);
        if (decorations == null && createIfAbsent) {
            decorations = FXCollections.observableArrayList();
            target.getProperties().put((Object)DECORATIONS_PROPERTY_KEY, (Object)decorations);
        }
        return decorations;
    }

    private static void updateDecorationsOnNode(Node target, List<Decoration> added, List<Decoration> removed) {
        DecorationPane p = Decorator.getDecorationPane(target);
        if (p == null) {
            return;
        }
        p.updateDecorationsOnNode(target, added, removed);
    }

    private static DecorationPane getDecorationPane(Node target) {
        Object p;
        for (p = target.getParent(); p != null && !(p instanceof DecorationPane); p = p.getParent()) {
        }
        if (p == null) {
            Scene scene = target.getScene();
            if (scene == null) {
                return null;
            }
            p = new DecorationPane();
            Parent oldRoot = scene.getRoot();
            ImplUtils.injectAsRootPane(scene, p);
            ((DecorationPane)((Object)p)).setRoot((Node)oldRoot);
        }
        return (DecorationPane)((Object)p);
    }
}

