/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.ActionProxy;
import org.controlsfx.glyphfont.GlyphFontRegistry;

class AnnotatedAction
extends AbstractAction {
    private Method method;
    private Object target;

    public AnnotatedAction(ActionProxy annotation, Method method, Object target) {
        super(annotation.text());
        String acceleratorText;
        Node graphic = this.resolveGraphic(annotation);
        this.setGraphic(graphic);
        String longText = annotation.longText().trim();
        if (graphic != null) {
            this.setLongText(longText);
        }
        if ((acceleratorText = annotation.accelerator().trim()) != null && !acceleratorText.isEmpty()) {
            this.setAccelerator(KeyCombination.keyCombination((String)acceleratorText));
        }
        this.method = method;
        this.method.setAccessible(true);
        this.target = target;
    }

    private Node resolveGraphic(ActionProxy annotation) {
        String graphicDef = annotation.graphic().trim();
        if (!graphicDef.isEmpty()) {
            String[] def = graphicDef.split("\\>");
            if (def.length == 1) {
                return new ImageView(new Image(def[0]));
            }
            switch (def[0]) {
                case "font": {
                    return GlyphFontRegistry.glyph(def[1]);
                }
                case "image": {
                    return new ImageView(new Image(def[1]));
                }
            }
            throw new IllegalArgumentException(String.format("Unknown ActionProxy graphic protocol: %s", def[0]));
        }
        return null;
    }

    public Object getTarget() {
        return this.target;
    }

    public void handle(ActionEvent ae) {
        try {
            int paramCount = this.method.getParameterCount();
            if (paramCount == 0) {
                this.method.invoke(this.target, new Object[0]);
            } else if (paramCount == 1 && this.method.getParameterTypes()[0] == ActionEvent.class) {
                this.method.invoke(this.target, ae);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return this.getText();
    }
}

