/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.SnapshotViewSkin;
import impl.org.controlsfx.tools.MathTools;
import impl.org.controlsfx.tools.rectangle.Rectangles2D;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import org.controlsfx.control.ControlsFXControl;

public class SnapshotView
extends ControlsFXControl {
    private final ObjectProperty<Node> node;
    private final ObjectProperty<Rectangle2D> selection;
    private final BooleanProperty selectionValid;
    private final BooleanProperty selectionActive;
    private final BooleanProperty selectionChanging;
    private final BooleanProperty selectionRatioFixed;
    private final DoubleProperty fixedSelectionRatio;
    private final BooleanProperty selectionActivityExplicitlyManaged;
    private static final String DEFAULT_STYLE_CLASS = "snapshot-view";

    public SnapshotView() {
        this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
        this.node = new SimpleObjectProperty((Object)this, "node");
        this.selection = new SimpleObjectProperty((Object)this, "selection");
        this.selectionValid = new SimpleBooleanProperty((Object)this, "selectionValid", false);
        this.selectionActive = new SimpleBooleanProperty((Object)this, "selectionActive", false);
        this.selectionChanging = new SimpleBooleanProperty((Object)this, "selectionChanging", false);
        this.selectionRatioFixed = new SimpleBooleanProperty((Object)this, "selectionRatioFixed", false);
        this.fixedSelectionRatio = new SimpleDoubleProperty((Object)this, "fixedSelectionRatio", 1.0){

            public void set(double newValue) {
                if (newValue <= 0.0) {
                    throw new IllegalArgumentException("The fixed selection ratio must be positive.");
                }
                super.set(newValue);
            }
        };
        this.selectionActivityExplicitlyManaged = new SimpleBooleanProperty((Object)this, "selectionActivityExplicitlyManaged", false);
        this.addStateUpdatingListeners();
    }

    private void addStateUpdatingListeners() {
        this.node.addListener((observable, oldValue, newValue) -> this.updateSelectionValidity());
        this.selection.addListener((observable, oldValue, newValue) -> {
            this.updateSelectionValidity();
            this.updateSelectionActiviteState();
        });
        this.selectionRatioFixed.addListener((observable, oldValue, newValue) -> {
            boolean valueChangedToTrue;
            boolean bl = valueChangedToTrue = oldValue == false && newValue != false;
            if (valueChangedToTrue) {
                this.fixSelectionRatio();
            }
        });
        this.fixedSelectionRatio.addListener((observable, oldValue, newValue) -> {
            if (this.isSelectionRatioFixed()) {
                this.fixSelectionRatio();
            }
        });
    }

    public SnapshotView(Node node) {
        this();
        this.setNode(node);
    }

    public SnapshotView(String url) {
        this();
        Image image = new Image(url);
        this.setNode((Node)new ImageView(image));
    }

    private void fixSelectionRatio() {
        boolean noSelectionToFix;
        boolean bl = noSelectionToFix = this.getNode() == null || !this.isSelectionValid();
        if (noSelectionToFix) {
            return;
        }
        Rectangle2D resizeBounds = new Rectangle2D(0.0, 0.0, this.getNodeWidth(), this.getNodeHeight());
        Rectangle2D resizedSelection = Rectangles2D.fixRatioWithinBounds(this.getSelection(), this.getFixedSelectionRatio(), resizeBounds);
        this.setSelection(resizedSelection);
    }

    private void updateSelectionValidity() {
        if (this.getNode() == null || this.getSelection() == null) {
            this.selectionValid.set(false);
        } else {
            boolean upperLeftInImage = MathTools.isInInterval(0.0, this.getSelection().getMinX(), this.getNodeWidth()) && MathTools.isInInterval(0.0, this.getSelection().getMinY(), this.getNodeHeight());
            boolean lowerRightInImage = MathTools.isInInterval(0.0, this.getSelection().getMaxX(), this.getNodeWidth()) && MathTools.isInInterval(0.0, this.getSelection().getMaxY(), this.getNodeHeight());
            this.selectionValid.set(upperLeftInImage && lowerRightInImage);
        }
    }

    private void updateSelectionActiviteState() {
        boolean explicitlyManaged = this.isSelectionActivityExplicitlyManaged();
        if (explicitlyManaged) {
            return;
        }
        boolean selectionActive = this.getSelection() != null;
        this.setSelectionActive(selectionActive);
    }

    private double getNodeWidth() {
        Node n = this.getNode();
        return n == null ? 0.0 : n.prefWidth(-1.0);
    }

    private double getNodeHeight() {
        Node n = this.getNode();
        return n == null ? 0.0 : n.prefHeight(-1.0);
    }

    protected String getUserAgentStylesheet() {
        return ((Object)((Object)this)).getClass().getResource("snapshot-view.css").toExternalForm();
    }

    protected Skin<?> createDefaultSkin() {
        return new SnapshotViewSkin(this);
    }

    public final ObjectProperty<Node> nodeProperty() {
        return this.node;
    }

    public final Node getNode() {
        return (Node)this.nodeProperty().get();
    }

    public void setNode(Node node) {
        this.nodeProperty().set((Object)node);
    }

    public ObjectProperty<Rectangle2D> selectionProperty() {
        return this.selection;
    }

    public Rectangle2D getSelection() {
        return (Rectangle2D)this.selectionProperty().get();
    }

    public void setSelection(Rectangle2D selection) {
        this.selectionProperty().set((Object)selection);
    }

    public void setSelection(double upperLeftX, double upperLeftY, double width, double height) {
        this.selectionProperty().set((Object)new Rectangle2D(upperLeftX, upperLeftY, width, height));
    }

    public ReadOnlyBooleanProperty selectionValidProperty() {
        return this.selectionValid;
    }

    public boolean isSelectionValid() {
        return this.selectionValidProperty().get();
    }

    public BooleanProperty selectionActiveProperty() {
        return this.selectionActive;
    }

    public boolean isSelectionActive() {
        return this.selectionActiveProperty().get();
    }

    public void setSelectionActive(boolean selectionActive) {
        this.selectionActiveProperty().set(selectionActive);
    }

    public BooleanProperty selectionChangingProperty() {
        return this.selectionChanging;
    }

    public boolean isSelectionChanging() {
        return this.selectionChangingProperty().get();
    }

    public BooleanProperty selectionRatioFixedProperty() {
        return this.selectionRatioFixed;
    }

    public boolean isSelectionRatioFixed() {
        return this.selectionRatioFixedProperty().get();
    }

    public void setSelectionRatioFixed(boolean selectionRatioFixed) {
        this.selectionRatioFixedProperty().set(selectionRatioFixed);
    }

    public DoubleProperty fixedSelectionRatioProperty() {
        return this.fixedSelectionRatio;
    }

    public double getFixedSelectionRatio() {
        return this.fixedSelectionRatioProperty().get();
    }

    public void setFixedSelectionRatio(double fixedSelectionRatio) {
        this.fixedSelectionRatioProperty().set(fixedSelectionRatio);
    }

    public BooleanProperty selectionActivityExplicitlyManagedProperty() {
        return this.selectionActivityExplicitlyManaged;
    }

    public boolean isSelectionActivityExplicitlyManaged() {
        return this.selectionActivityExplicitlyManagedProperty().get();
    }

    public void setSelectionActivityExplicitlyManaged(boolean selectionActivityExplicitlyManaged) {
        this.selectionActivityExplicitlyManagedProperty().set(selectionActivityExplicitlyManaged);
    }

    public WritableImage createSnapshot() {
        if (this.getNode() != null || this.getSelection() == null) {
            SnapshotParameters params = new SnapshotParameters();
            params.setViewport(this.getSelection());
            return this.getNode().snapshot(params, null);
        }
        return null;
    }
}

