/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.PopOverSkin;
import java.util.Objects;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.control.Skin;
import javafx.scene.input.MouseEvent;
import javafx.stage.PopupWindow;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;

public class PopOver
extends PopupControl {
    private static final String DEFAULT_STYLE_CLASS = "popover";
    private static final Duration DEFAULT_FADE_DURATION = Duration.seconds((double)0.2);
    private double targetX;
    private double targetY;
    private final ObjectProperty<Node> contentNode = new SimpleObjectProperty<Node>((Object)this, "contentNode"){

        public void setValue(Node node) {
            if (node == null) {
                throw new IllegalArgumentException("content node can not be null");
            }
        }
    };
    private InvalidationListener hideListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            if (!PopOver.this.isDetached()) {
                PopOver.this.hide(Duration.ZERO);
            }
        }
    };
    private WeakInvalidationListener weakHideListener = new WeakInvalidationListener(this.hideListener);
    private ChangeListener<Number> xListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> value, Number oldX, Number newX) {
            PopOver.this.setX(PopOver.this.getX() + (newX.doubleValue() - oldX.doubleValue()));
        }
    };
    private WeakChangeListener<Number> weakXListener = new WeakChangeListener(this.xListener);
    private ChangeListener<Number> yListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> value, Number oldY, Number newY) {
            PopOver.this.setY(PopOver.this.getY() + (newY.doubleValue() - oldY.doubleValue()));
        }
    };
    private WeakChangeListener<Number> weakYListener = new WeakChangeListener(this.yListener);
    private Window ownerWindow;
    private final BooleanProperty detachable = new SimpleBooleanProperty((Object)this, "detachable", true);
    private final BooleanProperty detached = new SimpleBooleanProperty((Object)this, "detached", false);
    private final DoubleProperty arrowSize = new SimpleDoubleProperty((Object)this, "arrowSize", 12.0);
    private final DoubleProperty arrowIndent = new SimpleDoubleProperty((Object)this, "arrowIndent", 12.0);
    private final DoubleProperty cornerRadius = new SimpleDoubleProperty((Object)this, "cornerRadius", 6.0);
    private final StringProperty detachedTitle = new SimpleStringProperty((Object)this, "detachedTitle", "Info");
    private final ObjectProperty<ArrowLocation> arrowLocation = new SimpleObjectProperty((Object)this, "arrowLocation", (Object)ArrowLocation.LEFT_TOP);

    public PopOver() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_TOP_LEFT);
        this.setOnHiding((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent evt) {
                PopOver.this.setDetached(false);
            }
        });
        Label label = new Label("<No Content>");
        label.setPrefSize(200.0, 200.0);
        label.setPadding(new Insets(4.0));
        this.setContentNode((Node)label);
        ChangeListener<Object> repositionListener = new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> value, Object oldObject, Object newObject) {
                if (PopOver.this.isShowing() && !PopOver.this.isDetached()) {
                    PopOver.this.show(PopOver.this.getOwnerNode(), PopOver.this.targetX, PopOver.this.targetY);
                    PopOver.this.adjustWindowLocation();
                }
            }
        };
        this.arrowSize.addListener((ChangeListener)repositionListener);
        this.cornerRadius.addListener((ChangeListener)repositionListener);
        this.arrowLocation.addListener((ChangeListener)repositionListener);
        this.arrowIndent.addListener((ChangeListener)repositionListener);
    }

    public PopOver(Node content) {
        this();
        this.setContentNode(content);
    }

    protected Skin<?> createDefaultSkin() {
        return new PopOverSkin(this);
    }

    public final ObjectProperty<Node> contentNodeProperty() {
        return this.contentNode;
    }

    public final Node getContentNode() {
        return (Node)this.contentNodeProperty().get();
    }

    public final void setContentNode(Node content) {
        this.contentNodeProperty().set((Object)content);
    }

    public final void show(Node owner) {
        this.show(owner, 4.0);
    }

    public final void show(Node owner, double offset) {
        Objects.requireNonNull(owner);
        Bounds bounds = owner.localToScreen(owner.getBoundsInLocal());
        switch (this.getArrowLocation()) {
            case BOTTOM_CENTER: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                this.show(owner, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + offset);
                break;
            }
            case LEFT_BOTTOM: 
            case LEFT_CENTER: 
            case LEFT_TOP: {
                this.show(owner, bounds.getMaxX() - offset, bounds.getMinY() + bounds.getHeight() / 2.0);
                break;
            }
            case RIGHT_BOTTOM: 
            case RIGHT_CENTER: 
            case RIGHT_TOP: {
                this.show(owner, bounds.getMinX() + offset, bounds.getMinY() + bounds.getHeight() / 2.0);
                break;
            }
            case TOP_CENTER: 
            case TOP_LEFT: 
            case TOP_RIGHT: {
                this.show(owner, bounds.getMinX() + bounds.getWidth() / 2.0, bounds.getMinY() + bounds.getHeight() - offset);
                break;
            }
        }
    }

    public final void show(Node owner, double x, double y) {
        this.show(owner, x, y, DEFAULT_FADE_DURATION);
    }

    public final void show(Node owner, double x, double y, Duration fadeInDuration) {
        if (this.ownerWindow != null && this.isShowing()) {
            super.hide();
        }
        this.targetX = x;
        this.targetY = y;
        if (owner == null) {
            throw new IllegalArgumentException("owner can not be null");
        }
        if (fadeInDuration == null) {
            fadeInDuration = DEFAULT_FADE_DURATION;
        }
        if (this.ownerWindow != null) {
            this.ownerWindow.xProperty().removeListener(this.weakXListener);
            this.ownerWindow.yProperty().removeListener(this.weakYListener);
            this.ownerWindow.widthProperty().removeListener((InvalidationListener)this.weakHideListener);
            this.ownerWindow.heightProperty().removeListener((InvalidationListener)this.weakHideListener);
        }
        this.ownerWindow = owner.getScene().getWindow();
        this.ownerWindow.xProperty().addListener(this.weakXListener);
        this.ownerWindow.yProperty().addListener(this.weakYListener);
        this.ownerWindow.widthProperty().addListener((InvalidationListener)this.weakHideListener);
        this.ownerWindow.heightProperty().addListener((InvalidationListener)this.weakHideListener);
        this.setOnShown(evt -> {
            this.getScene().addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent evt) {
                    if (evt.getTarget().equals(PopOver.this.getScene().getRoot()) && !PopOver.this.isDetached()) {
                        PopOver.this.hide();
                    }
                }
            });
            this.adjustWindowLocation();
        });
        super.show(owner, x, y);
        Node skinNode = this.getSkin().getNode();
        skinNode.setOpacity(0.0);
        FadeTransition fadeIn = new FadeTransition(fadeInDuration, skinNode);
        fadeIn.setFromValue(0.0);
        fadeIn.setToValue(1.0);
        fadeIn.play();
    }

    public final void hide() {
        this.hide(DEFAULT_FADE_DURATION);
    }

    public final void hide(Duration fadeOutDuration) {
        if (fadeOutDuration == null) {
            fadeOutDuration = DEFAULT_FADE_DURATION;
        }
        if (this.isShowing()) {
            Node skinNode = this.getSkin().getNode();
            skinNode.setOpacity(0.0);
            FadeTransition fadeOut = new FadeTransition(fadeOutDuration, skinNode);
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            fadeOut.setOnFinished(evt -> super.hide());
            fadeOut.play();
        }
    }

    private void adjustWindowLocation() {
        Bounds bounds = this.getSkin().getNode().getBoundsInParent();
        switch (this.getArrowLocation()) {
            case TOP_CENTER: 
            case TOP_LEFT: 
            case TOP_RIGHT: {
                this.setX(this.getX() + bounds.getMinX() - this.computeXOffset());
                this.setY(this.getY() + bounds.getMinY() + this.getArrowSize());
                break;
            }
            case LEFT_BOTTOM: 
            case LEFT_CENTER: 
            case LEFT_TOP: {
                this.setX(this.getX() + bounds.getMinX() + this.getArrowSize());
                this.setY(this.getY() + bounds.getMinY() - this.computeYOffset());
                break;
            }
            case BOTTOM_CENTER: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                this.setX(this.getX() + bounds.getMinX() - this.computeXOffset());
                this.setY(this.getY() - bounds.getMinY() - bounds.getMaxY() - 1.0);
                break;
            }
            case RIGHT_BOTTOM: 
            case RIGHT_CENTER: 
            case RIGHT_TOP: {
                this.setX(this.getX() - bounds.getMinX() - bounds.getMaxX() - 1.0);
                this.setY(this.getY() + bounds.getMinY() - this.computeYOffset());
            }
        }
    }

    private double computeXOffset() {
        switch (this.getArrowLocation()) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                return this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize();
            }
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return this.getContentNode().prefWidth(-1.0) / 2.0;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return this.getContentNode().prefWidth(-1.0) - this.getArrowIndent() - this.getCornerRadius() - this.getArrowSize();
            }
        }
        return 0.0;
    }

    private double computeYOffset() {
        double prefContentHeight = this.getContentNode().prefHeight(-1.0);
        switch (this.getArrowLocation()) {
            case LEFT_TOP: 
            case RIGHT_TOP: {
                return this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize();
            }
            case LEFT_CENTER: 
            case RIGHT_CENTER: {
                return Math.max(prefContentHeight, 2.0 * (this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize())) / 2.0;
            }
            case LEFT_BOTTOM: 
            case RIGHT_BOTTOM: {
                return Math.max(prefContentHeight - this.getCornerRadius() - this.getArrowIndent() - this.getArrowSize(), this.getCornerRadius() + this.getArrowIndent() + this.getArrowSize());
            }
        }
        return 0.0;
    }

    public final void detach() {
        if (this.isDetachable()) {
            this.setDetached(true);
        }
    }

    public final BooleanProperty detachableProperty() {
        return this.detachable;
    }

    public final void setDetachable(boolean detachable) {
        this.detachableProperty().set(detachable);
    }

    public final boolean isDetachable() {
        return this.detachableProperty().get();
    }

    public final BooleanProperty detachedProperty() {
        return this.detached;
    }

    public final void setDetached(boolean detached) {
        this.detachedProperty().set(detached);
    }

    public final boolean isDetached() {
        return this.detachedProperty().get();
    }

    public final DoubleProperty arrowSizeProperty() {
        return this.arrowSize;
    }

    public final double getArrowSize() {
        return this.arrowSizeProperty().get();
    }

    public final void setArrowSize(double size) {
        this.arrowSizeProperty().set(size);
    }

    public final DoubleProperty arrowIndentProperty() {
        return this.arrowIndent;
    }

    public final double getArrowIndent() {
        return this.arrowIndentProperty().get();
    }

    public final void setArrowIndent(double size) {
        this.arrowIndentProperty().set(size);
    }

    public final DoubleProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public final double getCornerRadius() {
        return this.cornerRadiusProperty().get();
    }

    public final void setCornerRadius(double radius) {
        this.cornerRadiusProperty().set(radius);
    }

    public final StringProperty detachedTitleProperty() {
        return this.detachedTitle;
    }

    public final String getDetachedTitle() {
        return (String)this.detachedTitleProperty().get();
    }

    public final void setDetachedTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException("title can not be null");
        }
        this.detachedTitleProperty().set((Object)title);
    }

    public final ObjectProperty<ArrowLocation> arrowLocationProperty() {
        return this.arrowLocation;
    }

    public final void setArrowLocation(ArrowLocation location) {
        this.arrowLocationProperty().set((Object)location);
    }

    public final ArrowLocation getArrowLocation() {
        return (ArrowLocation)((Object)this.arrowLocationProperty().get());
    }

    public static enum ArrowLocation {
        LEFT_TOP,
        LEFT_CENTER,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_CENTER,
        RIGHT_BOTTOM,
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;

    }
}

