/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import org.controlsfx.control.CheckBitSetModelBase;

public class CheckTreeView<T>
extends TreeView<T> {
    private ObjectProperty<MultipleSelectionModel<TreeItem<T>>> checkModel = new SimpleObjectProperty((Object)this, "checkModel");

    public CheckTreeView() {
        this(null);
    }

    public CheckTreeView(CheckBoxTreeItem<T> root) {
        super(root);
        this.setCheckModel(new CheckTreeViewBitSetCheckModel(this));
        this.setCellFactory(CheckBoxTreeCell.forTreeView());
    }

    public BooleanProperty getItemBooleanProperty(int index) {
        CheckBoxTreeItem treeItem = (CheckBoxTreeItem)this.getTreeItem(index);
        return treeItem.selectedProperty();
    }

    public final void setCheckModel(MultipleSelectionModel<TreeItem<T>> value) {
        this.checkModelProperty().set(value);
    }

    public final MultipleSelectionModel<TreeItem<T>> getCheckModel() {
        return this.checkModel == null ? null : (MultipleSelectionModel)this.checkModel.get();
    }

    public final ObjectProperty<MultipleSelectionModel<TreeItem<T>>> checkModelProperty() {
        return this.checkModel;
    }

    private static class CheckTreeViewBitSetCheckModel<T>
    extends CheckBitSetModelBase<TreeItem<T>> {
        private final CheckTreeView<T> treeView;
        private final TreeItem<T> root;

        CheckTreeViewBitSetCheckModel(CheckTreeView<T> treeView) {
            super(null);
            this.treeView = treeView;
            this.root = treeView.getRoot();
            this.root.addEventHandler(CheckBoxTreeItem.checkBoxSelectionChangedEvent(), new EventHandler<CheckBoxTreeItem.TreeModificationEvent<T>>(){

                public void handle(CheckBoxTreeItem.TreeModificationEvent<T> e) {
                    CheckBoxTreeItem treeItem = e.getTreeItem();
                    int index = this.getItemIndex(treeItem);
                    if (treeItem.isSelected() && !treeItem.isIndeterminate()) {
                        this.select(index);
                    } else {
                        this.clearSelection(index);
                    }
                }
            });
        }

        @Override
        public TreeItem<T> getItem(int index) {
            return this.treeView.getTreeItem(index);
        }

        @Override
        public int getItemCount() {
            return this.treeView.getExpandedItemCount();
        }

        @Override
        public int getItemIndex(TreeItem<T> item) {
            return this.treeView.getRow(item);
        }

        @Override
        BooleanProperty getItemBooleanProperty(TreeItem<T> item) {
            if (item == null) {
                return null;
            }
            return ((CheckBoxTreeItem)item).selectedProperty();
        }

        @Override
        protected void updateMap() {
        }
    }
}

