/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import java.util.BitSet;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;

abstract class CheckBitSetModelBase<T>
extends MultipleSelectionModel<T> {
    private final Map<T, BooleanProperty> itemBooleanMap;
    private final BitSet selectedIndices;
    private final ReadOnlyUnbackedObservableList<Integer> selectedIndicesList;
    private final ReadOnlyUnbackedObservableList<T> selectedItemsList;

    CheckBitSetModelBase(Map<T, BooleanProperty> itemBooleanMap) {
        this.itemBooleanMap = itemBooleanMap;
        this.selectedIndices = new BitSet();
        this.selectedIndicesList = new ReadOnlyUnbackedObservableList<Integer>(){

            public Integer get(int index) {
                if (index < 0 || index >= CheckBitSetModelBase.this.getItemCount()) {
                    return -1;
                }
                int val = CheckBitSetModelBase.this.selectedIndices.nextSetBit(0);
                for (int pos = 0; val >= 0 || pos == index; ++pos) {
                    if (pos == index) {
                        return val;
                    }
                    val = CheckBitSetModelBase.this.selectedIndices.nextSetBit(val + 1);
                }
                return -1;
            }

            public int size() {
                return CheckBitSetModelBase.this.selectedIndices.cardinality();
            }

            public boolean contains(Object o) {
                if (o instanceof Number) {
                    Number n = (Number)o;
                    int index = n.intValue();
                    return index >= 0 && index < CheckBitSetModelBase.this.selectedIndices.length() && CheckBitSetModelBase.this.selectedIndices.get(index);
                }
                return false;
            }
        };
        this.selectedItemsList = new ReadOnlyUnbackedObservableList<T>(){

            public T get(int i) {
                int pos = (Integer)CheckBitSetModelBase.this.selectedIndicesList.get(i);
                if (pos < 0 || pos >= CheckBitSetModelBase.this.getItemCount()) {
                    return null;
                }
                return CheckBitSetModelBase.this.getItem(pos);
            }

            public int size() {
                return CheckBitSetModelBase.this.selectedIndices.cardinality();
            }
        };
        final MappingChange.Map map = new MappingChange.Map<Integer, T>(){

            public T map(Integer f) {
                return CheckBitSetModelBase.this.getItem(f);
            }
        };
        this.selectedIndicesList.addListener((ListChangeListener)new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> c) {
                CheckBitSetModelBase.this.selectedItemsList.callObservers((ListChangeListener.Change)new MappingChange(c, map, (ObservableList)CheckBitSetModelBase.this.selectedItemsList));
                c.reset();
            }
        });
        this.getSelectedItems().addListener(new ListChangeListener<T>(){

            public void onChanged(ListChangeListener.Change<? extends T> c) {
                while (c.next()) {
                    BooleanProperty p;
                    if (c.wasAdded()) {
                        for (Object item : c.getAddedSubList()) {
                            p = CheckBitSetModelBase.this.getItemBooleanProperty(item);
                            if (p == null) continue;
                            p.set(true);
                        }
                    }
                    if (!c.wasRemoved()) continue;
                    for (Object item : c.getRemoved()) {
                        p = CheckBitSetModelBase.this.getItemBooleanProperty(item);
                        if (p == null) continue;
                        p.set(false);
                    }
                }
            }
        });
    }

    public abstract T getItem(int var1);

    public abstract int getItemCount();

    public abstract int getItemIndex(T var1);

    BooleanProperty getItemBooleanProperty(T item) {
        return this.itemBooleanMap.get(item);
    }

    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicesList;
    }

    public ObservableList<T> getSelectedItems() {
        return this.selectedItemsList;
    }

    public void selectAll() {
        for (int i = 0; i < this.getItemCount(); ++i) {
            this.select(i);
        }
    }

    public void selectFirst() {
        this.select(0);
    }

    public void selectIndices(int index, int ... indices) {
        this.select(index);
        for (int i = 0; i < indices.length; ++i) {
            this.select(indices[i]);
        }
    }

    public void selectLast() {
        this.select(this.getItemCount() - 1);
    }

    public void clearAndSelect(int index) {
        this.clearSelection();
        this.select(index);
    }

    public void clearSelection() {
        for (int index = 0; index < this.selectedIndices.length(); ++index) {
            this.clearSelection(index);
        }
    }

    public void clearSelection(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.selectedIndices.clear(index);
        int changeIndex = this.selectedIndicesList.indexOf((Object)index);
        this.selectedIndicesList.callObservers((ListChangeListener.Change)new NonIterableChange.SimpleRemovedChange(changeIndex, changeIndex + 1, (Object)index, this.selectedIndicesList));
    }

    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    public boolean isSelected(int index) {
        return this.selectedIndices.get(index);
    }

    public void select(int index) {
        if (index < 0 || index >= this.getItemCount()) {
            return;
        }
        this.selectedIndices.set(index);
        int changeIndex = this.selectedIndicesList.indexOf((Object)index);
        this.selectedIndicesList.callObservers((ListChangeListener.Change)new NonIterableChange.SimpleAddChange(changeIndex, changeIndex + 1, this.selectedIndicesList));
    }

    public void select(T item) {
        int index = this.getItemIndex(item);
        this.select(index);
    }

    public void selectNext() {
    }

    public void selectPrevious() {
    }

    protected void updateMap() {
        this.itemBooleanMap.clear();
        int i = 0;
        while (i < this.getItemCount()) {
            final int index = i++;
            T item = this.getItem(index);
            SimpleBooleanProperty booleanProperty = new SimpleBooleanProperty(item, "selected", false);
            this.itemBooleanMap.put(item, (BooleanProperty)booleanProperty);
            booleanProperty.addListener(new InvalidationListener((BooleanProperty)booleanProperty){
                final /* synthetic */ BooleanProperty val$booleanProperty;
                {
                    this.val$booleanProperty = booleanProperty;
                }

                public void invalidated(Observable o) {
                    int changeIndex = CheckBitSetModelBase.this.selectedIndicesList.indexOf((Object)index);
                    if (this.val$booleanProperty.get()) {
                        CheckBitSetModelBase.this.selectedIndices.set(index);
                        CheckBitSetModelBase.this.selectedIndicesList.callObservers((ListChangeListener.Change)new NonIterableChange.SimpleAddChange(changeIndex, changeIndex + 1, (ObservableList)CheckBitSetModelBase.this.selectedIndicesList));
                    } else {
                        CheckBitSetModelBase.this.selectedIndices.clear(index);
                        CheckBitSetModelBase.this.selectedIndicesList.callObservers((ListChangeListener.Change)new NonIterableChange.SimpleRemovedChange(changeIndex, changeIndex + 1, (Object)index, (ObservableList)CheckBitSetModelBase.this.selectedIndicesList));
                    }
                }
            });
        }
    }
}

