/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.ParentTraversalEngine;
import com.sun.javafx.scene.traversal.TraversalContext;
import impl.org.controlsfx.skin.ButtonBarSkin;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Skin;
import org.controlsfx.control.ControlsFXControl;
import org.controlsfx.control.action.Action;
import org.controlsfx.tools.Platform;

public final class ButtonBar
extends ControlsFXControl {
    public static final String BUTTON_ORDER_WINDOWS = "L_E+U+FBI_YNOCAH_R";
    public static final String BUTTON_ORDER_MAC_OS = "L_HE+U+FBI_NCYOA_R";
    public static final String BUTTON_ORDER_LINUX = "L_HE+UNYACBXIO_R";
    private ObservableList<ButtonBase> buttons = FXCollections.observableArrayList();
    private final StringProperty buttonOrderProperty = new SimpleStringProperty((Object)this, "buttonOrder");
    private final DoubleProperty buttonMinWidthProperty = new SimpleDoubleProperty((Object)this, "buttonMinWidthProperty");
    private final BooleanProperty buttonUniformSizeProperty = new SimpleBooleanProperty((Object)this, "buttonUniformSize", true);

    public static void setType(ButtonBase button, ButtonType type) {
        button.getProperties().put((Object)"controlfx.button.type", (Object)type);
    }

    public static void setSizeIndependent(ButtonBase button) {
        button.getProperties().put((Object)"controlfx.button.size.indepenence", (Object)true);
    }

    public static void setType(Action action, ButtonType type) {
        action.getProperties().put((Object)"controlfx.button.type", (Object)type);
    }

    public static void setSizeIndependent(Action action) {
        action.getProperties().put((Object)"controlfx.button.size.indepenence", (Object)true);
    }

    public ButtonBar() {
        this(null);
    }

    public ButtonBar(String buttonOrder) {
        this.getStyleClass().add((Object)"button-bar");
        boolean buttonOrderEmpty = buttonOrder == null || buttonOrder.isEmpty();
        switch (Platform.getCurrent()) {
            case OSX: {
                this.setButtonOrder(buttonOrderEmpty ? BUTTON_ORDER_MAC_OS : buttonOrder);
                this.setButtonMinWidth(70.0);
                break;
            }
            case UNIX: {
                this.setButtonOrder(buttonOrderEmpty ? BUTTON_ORDER_LINUX : buttonOrder);
                this.setButtonMinWidth(85.0);
                break;
            }
            default: {
                this.setButtonOrder(buttonOrderEmpty ? BUTTON_ORDER_WINDOWS : buttonOrder);
                this.setButtonMinWidth(75.0);
            }
        }
        this.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                if (!ButtonBar.this.isFocused()) {
                    return;
                }
                boolean focusSet = false;
                for (ButtonBase button : ButtonBar.this.getButtons()) {
                    if (!(button instanceof Button) || !((Button)button).isDefaultButton()) continue;
                    button.requestFocus();
                    focusSet = true;
                    break;
                }
                if (!focusSet && !ButtonBar.this.getButtons().isEmpty()) {
                    ((ButtonBase)ButtonBar.this.getButtons().get(0)).requestFocus();
                }
            }
        });
        ParentTraversalEngine engine = new ParentTraversalEngine((Parent)this, new Algorithm(){

            public Node selectLast(TraversalContext context) {
                return (Node)ButtonBar.this.getButtons().get(0);
            }

            public Node selectFirst(TraversalContext context) {
                return (Node)ButtonBar.this.getButtons().get(ButtonBar.this.getButtons().size() - 1);
            }

            public Node select(Node node, Direction direction, TraversalContext context) {
                if (((Object)((Object)ButtonBar.this)).equals(node)) {
                    if (direction == null || direction.equals((Object)Direction.NEXT)) {
                        return (Node)ButtonBar.this.getButtons().get(0);
                    }
                    if (direction.equals((Object)Direction.PREVIOUS)) {
                        return (Node)ButtonBar.this.getButtons().get(ButtonBar.this.getButtons().size() - 1);
                    }
                }
                return null;
            }
        });
        this.setImpl_traversalEngine(engine);
    }

    protected Skin<?> createDefaultSkin() {
        return new ButtonBarSkin(this);
    }

    public ObservableList<ButtonBase> getButtons() {
        return this.buttons;
    }

    public boolean addButton(ButtonBase button, ButtonType buttonType) {
        if (button == null) {
            return false;
        }
        ButtonBar.setType(button, buttonType);
        this.getButtons().add((Object)button);
        return true;
    }

    public boolean addSizeIndependentButton(ButtonBase button, ButtonType buttonType) {
        Boolean result = this.addButton(button, buttonType);
        if (result.booleanValue()) {
            ButtonBar.setSizeIndependent(button);
        }
        return result;
    }

    public final StringProperty buttonOrderProperty() {
        return this.buttonOrderProperty;
    }

    public final void setButtonOrder(String buttonOrder) {
        this.buttonOrderProperty.set((Object)buttonOrder);
    }

    public final String getButtonOrder() {
        return (String)this.buttonOrderProperty.get();
    }

    public final DoubleProperty buttonMinWidthProperty() {
        return this.buttonMinWidthProperty;
    }

    public final void setButtonMinWidth(double value) {
        this.buttonMinWidthProperty.set(value);
    }

    public final double getButtonMinWidth() {
        return this.buttonMinWidthProperty.get();
    }

    public final BooleanProperty buttonUniformSizeProperty() {
        return this.buttonUniformSizeProperty;
    }

    public final void setButtonUniformSize(boolean value) {
        this.buttonUniformSizeProperty.set(value);
    }

    public final boolean isButtonUniformSize() {
        return this.buttonUniformSizeProperty.get();
    }

    public static enum ButtonType {
        LEFT("L"),
        RIGHT("R"),
        HELP("H"),
        HELP_2("E"),
        YES("Y"),
        NO("N"),
        NEXT_FORWARD("X"),
        BACK_PREVIOUS("B"),
        FINISH("I"),
        APPLY("A"),
        CANCEL_CLOSE("C"),
        OK_DONE("O"),
        OTHER("U"),
        BIG_GAP("+"),
        SMALL_GAP("_");

        private final String typeCode;

        private ButtonType(String type) {
            this.typeCode = type;
        }

        public String getTypeCode() {
            return this.typeCode;
        }
    }
}

