/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import com.sun.javafx.event.EventHandlerManager;
import impl.org.controlsfx.skin.BreadCrumbBarSkin;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.control.TreeItem;
import javafx.util.Callback;
import org.controlsfx.control.ControlsFXControl;

public class BreadCrumbBar<T>
extends ControlsFXControl {
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager((Object)this);
    private final Callback<TreeItem<T>, Button> defaultCrumbNodeFactory = new Callback<TreeItem<T>, Button>(){

        public Button call(TreeItem<T> crumb) {
            return new BreadCrumbBarSkin.BreadCrumbButton(crumb.getValue() != null ? crumb.getValue().toString() : "");
        }
    };
    private final ObjectProperty<TreeItem<T>> selectedCrumb = new SimpleObjectProperty((Object)this, "selectedCrumb");
    private final BooleanProperty autoNavigation = new SimpleBooleanProperty((Object)this, "autoNavigationEnabled", true);
    private final ObjectProperty<Callback<TreeItem<T>, Button>> crumbFactory = new SimpleObjectProperty((Object)this, "crumbFactory");
    private ObjectProperty<EventHandler<BreadCrumbActionEvent<T>>> onCrumbAction = new ObjectPropertyBase<EventHandler<BreadCrumbActionEvent<T>>>(){

        protected void invalidated() {
            BreadCrumbBar.this.eventHandlerManager.setEventHandler(BreadCrumbActionEvent.CRUMB_ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return BreadCrumbBar.this;
        }

        public String getName() {
            return "onCrumbAction";
        }
    };
    private static final String DEFAULT_STYLE_CLASS = "bread-crumb-bar";

    public static <T> TreeItem<T> buildTreeModel(T ... crumbs) {
        TreeItem subRoot = null;
        for (T crumb : crumbs) {
            TreeItem currentNode = new TreeItem(crumb);
            if (subRoot == null) {
                subRoot = currentNode;
                continue;
            }
            subRoot.getChildren().add((Object)currentNode);
            subRoot = currentNode;
        }
        return subRoot;
    }

    public BreadCrumbBar() {
        this(null);
    }

    public BreadCrumbBar(TreeItem<T> selectedCrumb) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setSelectedCrumb(selectedCrumb);
        this.setCrumbFactory(this.defaultCrumbNodeFactory);
    }

    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend((EventDispatcher)this.eventHandlerManager);
    }

    public final ObjectProperty<TreeItem<T>> selectedCrumbProperty() {
        return this.selectedCrumb;
    }

    public final TreeItem<T> getSelectedCrumb() {
        return (TreeItem)this.selectedCrumb.get();
    }

    public final void setSelectedCrumb(TreeItem<T> selectedCrumb) {
        this.selectedCrumb.set(selectedCrumb);
    }

    public final BooleanProperty autoNavigationEnabledProperty() {
        return this.autoNavigation;
    }

    public final boolean isAutoNavigationEnabled() {
        return this.autoNavigation.get();
    }

    public final void setAutoNavigationEnabled(boolean enabled) {
        this.autoNavigation.set(enabled);
    }

    public final ObjectProperty<Callback<TreeItem<T>, Button>> crumbFactoryProperty() {
        return this.crumbFactory;
    }

    public final void setCrumbFactory(Callback<TreeItem<T>, Button> value) {
        if (value == null) {
            value = this.defaultCrumbNodeFactory;
        }
        this.crumbFactoryProperty().set(value);
    }

    public final Callback<TreeItem<T>, Button> getCrumbFactory() {
        return (Callback)this.crumbFactory.get();
    }

    public final ObjectProperty<EventHandler<BreadCrumbActionEvent<T>>> onCrumbActionProperty() {
        return this.onCrumbAction;
    }

    public final void setOnCrumbAction(EventHandler<BreadCrumbActionEvent<T>> value) {
        this.onCrumbActionProperty().set(value);
    }

    public final EventHandler<BreadCrumbActionEvent<T>> getOnCrumbAction() {
        return (EventHandler)this.onCrumbActionProperty().get();
    }

    protected Skin<?> createDefaultSkin() {
        return new BreadCrumbBarSkin(this);
    }

    protected String getUserAgentStylesheet() {
        return BreadCrumbBar.class.getResource("breadcrumbbar.css").toExternalForm();
    }

    public static class BreadCrumbActionEvent<TE>
    extends Event {
        public static final EventType<BreadCrumbActionEvent> CRUMB_ACTION = new EventType("CRUMB_ACTION");
        private final TreeItem<TE> selectedCrumb;

        public BreadCrumbActionEvent(TreeItem<TE> selectedCrumb) {
            super(CRUMB_ACTION);
            this.selectedCrumb = selectedCrumb;
        }

        public TreeItem<TE> getSelectedCrumb() {
            return this.selectedCrumb;
        }
    }
}

